;
; QPEG video driver
; for S3 86c805 chipsets (DELL Local Bus)
; Tested on DELL 433/T. Other S3 cards may require additional code in init.
;
; Lenny Lim, 1993
;
; Note:  If you can't get it to work, try the VESA configuration.
;

        .286
Code    Segment Para 'Code'
        Assume  cs:Code
        Org 100h

Procs   dw      Bank,Init,Exit,0

plan16  db      0               ; stores 1 for planar 16 color mode

Bank:   cmp     plan16,2
        jne     svga
        retf
svga:
        mov     dx, 3d4h        ; Enable extended registers
        push    ax
        mov     al, 38h
        out     dx, al
        inc     dx
        mov     al, 48h
        out     dx, al

        dec     dx              ; Enable write to bank registers
        mov     al, 31h
        out     dx, al
        inc     dx
        mov     al, 89h
        in      al, dx
        push    ax
        dec     dx
        mov     al, 31h
        out     dx, al
        inc     dx
        pop     ax
        or      al, 9
        out     dx, al

        dec     dx              ; Switch banks
        mov     al, 35h
        out     dx, al
        inc     dx
        pop     ax
        cmp     cs:plan16, 1
        jne     col256
        shl     al, 2
col256:
        out     dx, al

        dec     dx              ; Disable extended registers
        mov     al, 38h
        out     dx, al
        inc     dx
        mov     al, 0
        out     dx, al

        retf

Init:   cmp     al, 13h
        jg      svgainit
        mov     cs:plan16, 2
        retf

svgainit:
        and     al, 1
        xor     al, 1
        mov     cs:plan16, al
        retf

Exit:   retf

Code    Ends
        End Procs

; End of source.
