;
; QPEG video driver
; for VESA compatible graphics cards
;
; 15-Oct-93:  1st release
; 04-Nov-93:  several bugs fixed
;

        .286
Code    Segment Para 'Code'
        Assume  cs:Code
        Org 100h

Procs   dw      Bank,Init,Exit,0

Bank:   test    cs:VesaMode,0ffh
        jz      SkipIt          ; don't do bank switching if no VESA mode
        pusha
        push    es
        push    ds
        mul     cs:VesaGranularity
        mov     dx,ax
        push    dx
        xor     bx,bx           ; window A
        mov     ax,4f05h
        int     10h
        pop     dx
        mov     bx,1            ; window B
        mov     ax,4f05h
        int     10h
        pop     ds
        pop     es
        popa
SkipIt: retf

VesaGranularity db 0    ; granularity of video bank address
VesaMode        db 0    ; 0 = not a VESA mode (i.e. no bank switching)

Init:   mov     cs:VesaMode,0
        cmp     ax,4f02h
        jne     Ready           ; skip everything if no VESA mode
        mov     cs:VesaMode,1
        push    cx
        mov     dx,cs
        mov     es,dx
        xor     di,di           ; es:di - VESA info table
        mov     cx,bx           ; mode number
        mov     ax,4f01h        ; get VESA mode info
        int     10h

        mov     cx,cs:[04h]     ; VESA page granularity (in Kb)
        mov     al,1
        test    cx,cx
        je      Gran64
        mov     ax,64
        div     cl
Gran64: mov     cs:VesaGranularity,al

        pop     ax              ; default = minimum bytes per line
        mov     cx,cs:[10h]     ; VESA bytes per line
        cmp     cx,ax
        jae     Ready
        add     cx,cx           ; double if too small
Ready:  retf

Exit:   retf

Code    Ends
        End Procs

; End of source.
