/*

Leaf1
This leaf & stem has a base point at <0 0 0> & arches towards
the negative z with the tip of the leaf at -50 z & the arch 
apexes at 57 y.

*/


//---- Texture for the right side of leaf
#declare Leaf_Texture_R = 
texture {
	color DarkGreen 
	.02
	ambient .25
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .01 10>
	rotate <0 0 45>
}
texture {
	wood
	color_map {
	[0 .5 color Black alpha .8 color DarkGreen alpha .7]
	[.5 1 color DarkGreen alpha .7 color Yellow alpha .7]
	}
	diffuse .4
	scale <30 40 20>
	} 


//---- Texture for left side of leaf
#declare Leaf_Texture_L = 
texture {
	color DarkGreen
	.01
	ambient .25
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .01 10>
	rotate <0 0 -45>
}
texture {
	wood
	color_map {
	[0 .5 color Black alpha .8 color DarkGreen alpha .7]
	[.5 1 color DarkGreen alpha .7 color Yellow alpha .7]
	}
	diffuse .4
	scale <30 40 20>
	} 


//--- Texture for leaf stem
#declare Stem_Texture = 
texture {
	color DarkGreen 
	.02
	ambient .25
	diffuse .5
	waves .8
	frequency .05
	phong .75
	phong_size 40
	scale <10 .1 10>
	rotate <0 0 45>
}


//----- Right 1/2 of leaf
#declare Leaf_R = 
object {
     quadric { Sphere scale <10 20 8> translate <5 0 0> }
	clipped_by {
	  quadric { Sphere scale <12.5 30 12.5> translate <0 15 0> }
	  quadric { Cylinder_X scale <1 22 8> translate <0 0 1.7> inverse }
	  plane { <1 0 0> 0 inverse }
	}
		texture {
		Leaf_Texture_R
		}
}


//--- Left 1/2 of leaf
#declare Leaf_L = 
object {
     quadric { Sphere scale <10 20 8> translate <-5 0 0> }
	clipped_by {
	  quadric { Sphere scale <12.5 30 12.5> translate <0 15 0> }
	  quadric { Cylinder_X scale <1 22 8> translate <0 0 1.7> inverse }
	  plane { <1 0 0> 0 }
	}
		texture {
		Leaf_Texture_L
		}
}



//--- Texture for Stem
#declare YourTexture =    
    texture {
    Stem_Texture
    }



#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

/*----------------------------------------------------------------------------*/

//--- Arched Stem
#declare Stem =
   composite {
      object {
         quadric {
            Dot
            scale     < 1.884620  1.884620  1.884620>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.884409 }
            plane {     < 1.000000  0.000000  0.000000>  1.769032 inverse }
         }
         translate <-1.884409  0.000000  0.000000>
         scale     < 66.871071  1.000000  1.000000>
         translate <-0.028180  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  66.321546>
         rotate    < 0.000000 -90.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.769230  1.769230  1.769230>
            translate < 0.000000  7.067440  3.099220>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.769032 }
            plane {     < 1.000000  0.000000  0.000000>  1.653665 inverse }
         }
         translate <-1.769032  0.000000  0.000000>
         scale     < 66.876887  1.000000  1.000000>
         translate <-0.026452  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  77.073854>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  7.067440  3.099220>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.653850  1.653850  1.653850>
            translate < 0.000000  14.589000  4.825500>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.653665 }
            plane {     < 1.000000  0.000000  0.000000>  1.538288 inverse }
         }
         translate <-1.653665  0.000000  0.000000>
         scale     < 66.871050  1.000000  1.000000>
         translate <-0.024729  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  87.826250>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.000000  14.589000  4.825500>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.538460  1.538460  1.538460>
            translate < 0.000000  22.300560  5.118210>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.538288 }
            plane {     < 1.000000  0.000000  0.000000>  1.422921 inverse }
         }
         translate <-1.538288  0.000000  0.000000>
         scale     < 66.876872  1.000000  1.000000>
         translate <-0.023002  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  81.421487>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  22.300560  5.118210>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.423080  1.423080  1.423080>
            translate < 0.000000  29.931340  3.967090>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.422921 }
            plane {     < 1.000000  0.000000  0.000000>  1.307544 inverse }
         }
         translate <-1.422921  0.000000  0.000000>
         scale     < 66.871072  1.000000  1.000000>
         translate <-0.021279  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  70.669222>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  29.931340  3.967090>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.307690  1.307690  1.307690>
            translate < 0.000000  37.213390  1.412560>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.307544 }
            plane {     < 1.000000  0.000000  0.000000>  1.192177 inverse }
         }
         translate <-1.307544  0.000000  0.000000>
         scale     < 66.876889  1.000000  1.000000>
         translate <-0.019552  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  59.916798>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  37.213390  1.412560>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.192310  1.192310  1.192310>
            translate < 0.000000  43.891000 -2.455700>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.192177 }
            plane {     < 1.000000  0.000000  0.000000>  1.076800 inverse }
         }
         translate <-1.192177  0.000000  0.000000>
         scale     < 66.870990  1.000000  1.000000>
         translate <-0.017828  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  49.164547>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  43.891000 -2.455700>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.076920  1.076920  1.076920>
            translate < 0.000000  49.729690 -7.501830>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.076800 }
            plane {     < 1.000000  0.000000  0.000000>  0.961433 inverse }
         }
         translate <-1.076800  0.000000  0.000000>
         scale     < 66.876938  1.000000  1.000000>
         translate <-0.016101  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  38.412182>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  49.729690 -7.501830>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.961540  0.961540  0.961540>
            translate < 0.000000  54.524450 -13.548670>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.961433 }
            plane {     < 1.000000  0.000000  0.000000>  0.846055 inverse }
         }
         translate <-0.961433  0.000000  0.000000>
         scale     < 66.871053  1.000000  1.000000>
         translate <-0.014377  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  27.659934>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  54.524450 -13.548670>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.846150  0.846150  0.846150>
            translate < 0.000000  58.106910 -20.383860>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.846055 }
            plane {     < 1.000000  0.000000  0.000000>  0.730688 inverse }
         }
         translate <-0.846055  0.000000  0.000000>
         scale     < 66.876810  1.000000  1.000000>
         translate <-0.012651  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  16.907523>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  58.106910 -20.383860>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.730770  0.730770  0.730770>
            translate < 0.000000  60.351260 -27.767400>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.730688 }
            plane {     < 1.000000  0.000000  0.000000>  0.615311 inverse }
         }
         translate <-0.730688  0.000000  0.000000>
         scale     < 66.871100  1.000000  1.000000>
         translate <-0.010927  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  6.155239>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  60.351260 -27.767400>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.615380  0.615380  0.615380>
            translate < 0.000000  61.178710 -35.440030>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.615311 }
            plane {     < 1.000000  0.000000  0.000000>  0.499944 inverse }
         }
         translate <-0.615311  0.000000  0.000000>
         scale     < 66.876872  1.000000  1.000000>
         translate <-0.009201  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -4.597062>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  61.178710 -35.440030>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.500000  0.500000  0.500000>
            translate < 0.000000  60.560200 -43.132320>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.499944 }
            plane {     < 1.000000  0.000000  0.000000>  0.384577 inverse }
         }
         translate <-0.499944  0.000000  0.000000>
         scale     < 66.876832  1.000000  1.000000>
         translate <-0.007476  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -15.349363>
         rotate    < 0.000000  90.000000  0.000000>
         translate < 0.000000  60.560200 -43.132320>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.384620  0.384620  0.384620>
            translate < 0.000000  58.517450 -50.574160>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 47.276732  47.276732  47.276732>
            translate < 0.000000  29.954735 -22.151055>
         }
      }
   }





//--- Complete Leaf & Stem
#declare Leaf1 =
composite {
   object { Leaf_L rotate <90 0 0>  translate <0 54 -38> }
   object { Leaf_R rotate <90 0 0>  translate <0 54 -38> }
   composite { Stem }
}




