{//-------------------------------------------------------------------------}
{/*                                                                         }
{Copyright (C) 1987, 2009 - Apogee Software, Ltd.                           }
{                                                                           }
{This file is part of Kroz. Kroz is free software; you can redistribute it  }
{and/or modify it under the terms of the GNU General Public License         }
{as published by the Free Software Foundation; either version 2             }
{of the License, or (at your option) any later version.                     }
{                                                                           }
{This program is distributed in the hope that it will be useful,            }
{but WITHOUT ANY WARRANTY; without even the implied warranty of             }
{MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                       }
{                                                                           }
{See the GNU General Public License for more details.                       }
{                                                                           }
{You should have received a copy of the GNU General Public License          }
{along with this program; if not, write to the Free Software                }
{Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.}
{                                                                           }
{Original Source: 1987-1990 Scott Miller                                    }
{Prepared for public release: 03/19/09 - Joe Siegler, Apogee Software, Ltd. }
{*/                                                                         }
{//-------------------------------------------------------------------------}
{*** KINGDOM OF KROZ II level layouts.  By Scott Miller 11/12/89 ***}

unit KINGDOM2;

interface

procedure Level1;
procedure Level2;
procedure Level4;
procedure Level6;
procedure Level8;
procedure Level10;
procedure Level12;
procedure Level14;
procedure Level16;
procedure Level18;
procedure Level20;
procedure Level22;
procedure Level24;
procedure Level25;


implementation { ---------------------------------------------------------- }

uses Turbo3, CRT, DOS, Kingdom1;

procedure Level1;
 begin
  FP[1]:= 'W W W W             2 2 2 2 2  C  2 2 2 2 2              W W W W';
  FP[2]:= 'XXXXXXXXXXXXXXXXXXX###########   ###########XXXXXXXXXXXXXXXXXXXX';
  FP[3]:= ' 1           1                               1                  ';
  FP[4]:= '                                    1            XX         1   ';
  FP[5]:= '       1            1                           XXXX            ';
  FP[6]:= '#        XX                    +                 XX            #';
  FP[7]:= '##      XXXX  1                +          1          1        ##';
  FP[8]:= 'T##      XX               2    +    2                        ##T';
  FP[9]:= 'T1##                       W   +   W                        ##1T';
  FP[10]:='T########X                 WX     XW             1    X########T';
  FP[11]:='.        X                2WX  P  XW2                 X        .';
  FP[12]:='T########X         1       WX     XW                  X########T';
  FP[13]:='T1##                       W   +   W         1              ##1T';
  FP[14]:='T##                       2    +    2                        ##T';
  FP[15]:='##   1                         +                      XX      ##';
  FP[16]:='#       XX      1              +                 1   XXXX     1#';
  FP[17]:='       XXXX                 ##   ##                   XX        ';
  FP[18]:='1       XX                 ##     ##     1        1           1 ';
  FP[19]:='                    1#######       ########                     ';
  FP[20]:='    1         ########11111  +++++  111111########              ';
  FP[21]:='WW     ########+++++        #######         WWWWW########1    WW';
  FP[22]:='########                    2 2 2                     C########';
  FP[23]:='L2  +  X      #kingdom#of#kroz#ii#by#scott#miller#      X  +  2L';
  Fast:=#234;{or #1}
  Convert_Format;
 end; { Level1 }

procedure Level2;
 begin
  FP[1]:= '                                                           .   ';
  FP[2]:= '  2#############################K############################   ';
  FP[3]:= '   ##  2    2   2 2    2   2  ###  2  2   2    2    2    2##   ';
  FP[4]:= '  2##+#2   2   2    2  2 2   2  2 2  2   2 2   2   2    2  ##   ';
  FP[5]:= '   ##+#   2  2    2   2   2   2    2    2  2    2    2   2 ##   ';
  FP[6]:= '  2##+# 2    2  2   2  2 2 2 2  2 2  2 2 2   2    2   2   2##   ';
  FP[7]:= '   ##+#2   2  2   2                            2   2   2   ## W ';
  FP[8]:= '  2##+#  2   2   2   XXXXXXXXXXXXXXXXXXXXXXX  2    2  2   2##@@@';
  FP[9]:= '   ##+#2   2  2   2  XXXXXXXXXXXXXXXXXXXXXXX    2   2  2   ##   ';
  FP[10]:='  2##+# 2   2  2 2   XXXXXXXXXXXXXXXXXXXXXXX   2  2   2  2 ##   ';
  FP[11]:='   ##+#   2 2 2   2  XXXXXX    -+-    XXXXXX  2 2    2  2  ##   ';
  FP[12]:='  2##+#2   2   2 2   XXXXXX1   -P-   1XXXXXX  2  2 2   2 2 ##   ';
  FP[13]:='   ##+#  2  2  2  2  XXXXXX    -+-    XXXXXX   2  2 2     2##   ';
  FP[14]:='  2##+# 2 2  2  2    XXXXXXXXXXXXXXXXXXXXXXX  2   2   2 2  ##   ';
  FP[15]:='   ##+#2 2    2   2  XXXXXXXXXXXXXXXXXXXXXXX    2  2   2 2 ##   ';
  FP[16]:='  2##+# 2  2  2  2   XXXXXXXXXXXXXXXXXXXXXXX   2    2 2 2  ##   ';
  FP[17]:='   ##+#  2  2 2   2                           2  2   2   2 ##   ';
  FP[18]:='  2##+#2   2    2   2 2  2  2  2 2  2 2  2  2   2   2  2  2##   ';
  FP[19]:='   ##+# 2    2  2  2 2  2   2   2   2  2  2    2    2   2  ##   ';
  FP[20]:='  2##3#   2   2   2   2   2   2   2   2 2    2    2   2   2##@@@';
  FP[21]:='   ##T#2   2     2  2  2 2   2 ###   2   2 2  2    2   2   ##222';
  FP[22]:='   #############################S#######################XXX##@@@';
  FP[23]:='                                                          I##LLL';
  Fast:=#234;{or #1}
  Convert_Format;
 end; { Level2 }

procedure Level4;
 begin
  FP[1]:= '-..............................3#1#2#3##------;------------;----';
  FP[2]:= '-##############################-##1#2#3#-######################-';
  FP[3]:= '-#.....----......- I#S###### ##K###1#2#3-#///////1///////////1//';
  FP[4]:= '-#.-..-....-....-.# # I####1# ######1#2#-#\1\\\\\\\\\\\\\1\\\\\\';
  FP[5]:= '-#-.-..-..-.....-.# # # ### ## ##1###1#2-#/////1////////////////';
  FP[6]:= '-#-.-.-..-..---..-# # ## # ##1## # ###1#-#CCC\\\\\\\\\1\\\\\\1\\';
  FP[7]:= '-#-.-..-.-.-..-..-# # ### ####  ### K##1-#CCC/////1//////1/////K';
  FP[8]:= '-#-..--...-....--.# # ##################-#######################';
  FP[9]:= '-#-################                                            ';
  FP[10]:='---3333333333-CC### #F######################XXXXXXXX#######-##+';
  FP[11]:='################## ###------------------###############2###-##+';
  FP[12]:='big#######     ## ####22222222222222222#-##-----------###2##-##K';
  FP[13]:='trouble## RRRRR  #######################-##-####U####-####2####+';
  FP[14]:='######## RRRKRRRR #########$;$$$$$$3$T##-##-----------#####2###3';
  FP[15]:='+++++### RR 2 2 RR ####Z###$############-##############Q###2###';
  FP[16]:='++T++## RR 2 P  2RR ### #-U--------------###TT.TT####----####2##';
  FP[17]:='+++++## RR2   2 RR ####1#-####################;###############2#';
  FP[18]:='#O#O#### RR 2  2RR #3## #C####3#3#3#3#3#3#3#3#3#3#3#3#3#3#3#3##D';
  FP[19]:='#X#X##### RRR2CRR ##3## # ###@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@###D';
  FP[20]:='#X#X###### RRRRRR ##3## #3##@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@##K#D';
  FP[21]:='-----; #### RRR  ### ## ###@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#D';
  FP[22]:='-----# #####   # ##W W# ##@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@#@##@#D';
  FP[23]:='22222#      #####       @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#L';
  Fast:=#234;{or #1}
  Convert_Format;
 end; { Level4 }

procedure Level6;
 begin
  FP[1]:= '---###########RRRRR##W        ############W////1/C//\//\\\\\\\\\';
  FP[2]:= '-U---------Z###RRRRR##7######   ##KK   Z##-//////\///1/\\\\\\U\';
  FP[3]:= '---###########RRRRR##7####### P ######## ###-////////\///\\1\\\\';
  FP[4]:= '@#############RRRRR#7####                ####-///\/////////\\\\\';
  FP[5]:= '@2#------.###RRRRR##7#W3; ############## #####-////1//\//1///\\\';
  FP[6]:= '@##;-;###.##RRRRR##7##W3; #WWWWWWWWWWW## #2####--//////////\///\';
  FP[7]:= '@2#-;;##..##RRRRR##7##W3; ######-####### ##2#####-/////\/////1//';
  FP[8]:= '@##;-;##..-##RRRRR##7#### #11111111111## ###2##2##-/////1/////\/';
  FP[9]:= '@2#;;-##..#D##RRRRR##7##T #11111111111## #2##2##2##--///////\///';
  FP[10]:='@##;;;##..#D###RRRRR##7####11111111111## ##2##2##2###---///////1';
  FP[11]:='@2#-;;##..#KK###RRRRR##7###11111111111## ###)##)##)#####--////\/';
  FP[12]:='@##-;;##..#KK##RRRRRRR#7###11111B11111----)))))))))))#####---///';
  FP[13]:='@2#;;;##22####RRRR#RRR##7##11111111111##############)########--/';
  FP[14]:='@##;;-##22###RRRR###RRR##7#11111111111#?##---#*YYYY-63333####D#';
  FP[15]:='@2#;-;##22##RRRR##L##RRR#7#11111111111#O#T#-#-#*YYYY-63333---#D#';
  FP[16]:='@##;;;##22#RRRR##DD##RRR#7#11111111111#O#-4-#-#*YYYY-63333-#-4-#';
  FP[17]:='@2#;-;##-##RRRR#DDD#RRR##7###########-#O#-#-#-#*YYYY-63333-#-#-#';
  FP[18]:='@##;;-##C#RRRR##DDD##RRR##7###+++++##-#O#-#-#-#*YYYY-63333-#-#-#';
  FP[19]:='@2#;;;##H##RRRR#DDDD##RRR##7##+++++##-#O#-#-#-#*YYYY-63333-#-#-#';
  FP[20]:='@##;-;####RRRR##44444##RRR##7###.####-#O#-#-#-#*YYYY-63333-#-#-#';
  FP[21]:='@2#-;;###RRRR####RRR#7###.#K-#-#O#-#-#-#*YYYY-63333-#-#-#';
  FP[22]:='@###-###RRRR##X--------#RRR####.#--#-#-#---#-######-#####-#---#';
  FP[23]:='-----##RRRR##%X---U----##RRR#K##--------#111#--------------#111#';
  Fast:=#234;{or #1}
  Convert_Format;
  HideOpenWall:=true;
 end; { Level6 }

procedure Level8;
 begin
  FP[1]:= '---------------44------------K---;-U-';
  FP[2]:= 'XXXXXXX-XXX-----44---      -----------------    ----#######-;---';
  FP[3]:= '--------------71#####       ---------------      #####-----;;;;';
  FP[4]:= 'K------------71###           -------------          #######; P ';
  FP[5]:= '#17---------71####****        -----------       ****##----W;   ';
  FP[6]:= '##17-------71#####*###         ----K----        ###*#######;   ';
  FP[7]:= '###17-----71######*#             #####            #*## 1   7;   ';
  FP[8]:= '####17---71#######*;     W    W    W    W    W    :*#######;   ';
  FP[9]:= '#####17-71########*#444444444444444444444444444444#*##     ;   ';
  FP[10]:='######---#########*#                              #*##444##;   ';
  FP[11]:='#################U#                              #!##     ;   ';
  FP[12]:='----------------####                              #########;   ';
  FP[13]:='----------------##VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV##     ;   ';
  FP[14]:='----------------##VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV#######;   ';
  FP[15]:='-------------######################################      ;   ';
  FP[16]:='5555555555555555#############the#lava#pit##################;   ';
  FP[17]:='            -------         ------------***********-##+   C;   ';
  FP[18]:='              000            ---######-###########-#######;   ';
  FP[19]:='                                ------7##LL-D-D-D-##      ;   ';
  FP[20]:='                                     ##-##################;   ';
  FP[21]:='                                     ##-7  1   TTT7##     ;   ';
  FP[22]:='       1 1 1 1 1 1 1 1 1 1 1 1 1 1 1##--################;   ';
  FP[23]:='###this#is#the#first#sideways#level####111111111  C##        ';
  Fast:=#234;{or #1}
  Convert_Format;
  LavaFlow:=true; LavaRate:=75;
  GravOn:=true;GravRate:=0;Sideways:=true;
 end; { Level8 }

procedure Level10;
 begin
  FP[1]:= '!+-----+----+------+##%VVOOOOO44U44OOOOVV%##3333333333333333333K';
  FP[2]:= '-----+--+-----+-----##VVVOOOOO44444OOOOVVV##66666666666666666663';
  FP[3]:= '+--+------+--------+##OOOOOOOO##5##OOOOOOO##                  63';
  FP[4]:= '-----+-------+----+-##OOOOOOOO##?##OOOOOOO##                  63';
  FP[5]:= '---+-----+------+---##VVVOOOOOO###OOOOOVVV##XXXXX             63';
  FP[6]:= '-+----+-------+-----##CVVOOOOOOO#OOOOOOVVC##XXXXX             63';
  FP[7]:= '+-------+--------+-U##CVVOOOOOOOOOOOOOOVVC##UXXXX             63';
  FP[8]:= '###############################OOO##############################';
  FP[9]:= 'MMMMMMMMMMMMMMMMMMMM##S                  S##11111111111111111111';
  FP[10]:='MMMMMMMMMMMMMMMMMMMM##                    ##11111111111111111111';
  FP[11]:='@@@@@@@@@@@@@@@@@@@@##         000        ##11111111111111111111';
  FP[12]:='K@@@@@@@@@@@@W                 0P0        HB11111111111B1111111';
  FP[13]:='@@@@@@@@@@@@@@@@@@@@##         000        ##11111111111111111111';
  FP[14]:='MMMMMMMMMMMMMMMMMMMM##                    ##11111111111111111111';
  FP[15]:='MMMMMMMMMMMMMMMMMMMM##S                  S##11111111111111111111';
  FP[16]:='###############################~~~##############################';
  FP[17]:='111111111111111111-U##C00000000---0-000---##U-))I)))))))333))))-';
  FP[18]:='1(((((((((((((((((--##-0000H---0000---0-0-##--)I)))))))333))))-*';
  FP[19]:='1(((((((TTT((((((((1##00000000 00000000000##))I)))))))333))))-*I';
  FP[20]:='1(((((((TTT((((((((1##-0-00000000000000-00##)I)))))))333))))-*I*';
  FP[21]:='1(((((((TTT((((((((1##00-0-----0000000<[|"##I)))))))333))))-*I*I';
  FP[22]:='1((((((((((((((((((1##-#####################)))))))333))))-*I*I*';
  FP[23]:='1111111111111111111##C-------D-D-D]]E&LL##K)))))333))))-*I*I*C';
  Fast:=#234;{or #1}
  Convert_Format;
  HideGems:=true;
 end; { Level10 }

procedure Level12;
 begin
  FP[1]:= 'LLL##U##@@@@@@@@@@@|000---0000000000000000-0--00000000VVV000Y-0V';
  FP[2]:= '```##-##@00000000000000---0000222222220---0000-00000000000--Y-0V';
  FP[3]:= '```##K##@@022222222K000---0000-0000000000-0000-0)))))YYYW-W0Y-0V';
  FP[4]:= '```##6##@@@222222222000---000U*******00000000000)))0000000000-00';
  FP[5]:= '```##6##@@@222222222000---000000000000000000000000222222--000---';
  FP[6]:= '```##6##@@0222222222000---((((((((((((((((((((000222222-C00000-';
  FP[7]:= '333##6##@00000000000000---00004444444444444444(0000000000000000-';
  FP[8]:= '333##6##3CCC....0---------00022222222222222222(K(---------------';
  FP[9]:= '$$$##6##000000000000000---00000000000000000000000000000000000000';
  FP[10]:='   0--00000000000000000---000000000000000000000===============--';
  FP[11]:=' P 00-00+02222222220--------------------------0="===-=--===-==-=';
  FP[12]:='$$$00-00+02222222220-00---0000000000000000000-0==I=-=-==-=-=-==-';
  FP[13]:=' ! 00-00+02222222220-00-Z-0000000000000000000-0=H==-===T==-==--=';
  FP[14]:='00000-00[02222B22220-00---00----03333333CC----0==I==-===-==-====';
  FP[15]:='0--00-00+02222222220-00---00-0000000000000000-0===--==-==-==--==';
  FP[16]:='-0000-00+02222222220-00---00-0000000000000000-0==-===-=-=-====-=';
  FP[17]:='00000-00+02222222220W00---00-----0--------000-0=-==--==-=-=--=T=';
  FP[18]:='0--00-00000000000000000---000000000001110-000-0==T-===-===-==-==';
  FP[19]:='00000-00000000000000000---000000000001110-00000=======-=========';
  FP[20]:='--000----------------- ---0WWWWWWWWK01110-000-000000000000000000';
  FP[21]:='00000-00000000000000000---000-00000001110-000K--<000OO000OOOOO*';
  FP[22]:='--000-000000~~~0000000#---#00-00000000000-000000000000OOOO000000';
  FP[23]:='00C000000********3000##VVV##0-------------00000000boulderville0';
  Fast:=#234;{or #1}
  Convert_Format;
  LavaFlow:=true; LavaRate:=30;
 end; { Level12 }

procedure Level14;
 begin
  FP[1]:= '###<@@@@@@@@@@@@@@@@@@@@@@@@@#one#@@@@@@@@@@@@@@@@@@@@@@@@@FK###';
  FP[2]:= 'K###@@@@@@@@@@@@@@@@@@@@@@@@@;!:@@@@@@@@@@@@@@@@@@@@@@@@@@###$[';
  FP[3]:= '((###@@@@@@@@@@@@@@@@@@@@@@@:::@@@@@@@@@@@@@@@@@@@@@@@@###$$$$';
  FP[4]:= '((((((###@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@###$$$$$$';
  FP[5]:= '(((((((2###222222222222222222222222222222222222222222###2$$$$$$$';
  FP[6]:= '(((((((2((###@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@###$$2$$$$$$$';
  FP[7]:= '(((((((2((((###@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@###$$$$2$$$$$$$';
  FP[8]:= '(((((((2((((((###@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@###$$$$$$2$$$$$$$';
  FP[9]:= 'DD##(((2((((((((###@@@@@@@@@@@@@@@@@@@@@@@@@@###$$$$$$$$2$$$####';
  FP[10]:='DD#f(((2(((((((((##############77##############$$$$$$$$$2$$$##CC';
  FP[11]:='DD#o(((2((((((((##2------------------------2##$$$$$$$$2$$$t#';
  FP[12]:='DD#u(((2((((((((----------F---P----S--------88$$$$$$$$2$$$w#MM';
  FP[13]:='&&#r(((2((((((((##2------------------------2##$$$$$$$$2$$$o#MM';
  FP[14]:='LL##(((2(((((((((##############99##############$$$$$$$$$2$$$##MM';
  FP[15]:='####(((2((((((((###))))))))))))))))))))))###$$$$$$$$2$$$##';
  FP[16]:='(((((((2((((((###))))))))))))))))))))))))))))))###$$$$$$2$$$$$$$';
  FP[17]:='(((((((2((((###))))))))))))))))))))))))))))))))))###$$$$2$$$$$$$';
  FP[18]:='(((((((2((###))))))))))))))))))))))))))))))))))))))###$$2$$$$$$$';
  FP[19]:='(((((((2###))))))))))))))))))))))))))))))))))))))))))###2$$$$$$$';
  FP[20]:='((((((###2222222222222222222222222222222222222222222222###$$$$$$';
  FP[21]:='((((###))))))))))))))))))))))))))))))))))))))))))))))))))###$$';
  FP[22]:='"(###))))))))))))))))))))))))))))))))))))))))))))))))))))))###K';
  FP[23]:='###K)))))))))))))))))))))))#three#))))))))))))))))))))))))F|###';
  Fast:=#234;{or #1}
  Convert_Format;
 end; { Level14 }

procedure Level16;
 begin
  FP[1]:= '##tunnels#of#kroz###########-P--################################';
  FP[2]:= '########################X###----######X##---------------##X####';
  FP[3]:= '############################----#########----------------#######';
  FP[4]:= 'L---N----H######   ######-----------------########----#######';
  FP[5]:= 'L---N-----##X###  CC  555555-----------------#####X##1111#######';
  FP[6]:= '######----######   ###############################----#####X#';
  FP[7]:= '######1111###########################################1111#######';
  FP[8]:= '#X####----##############X#######magic#####X##########----#######';
  FP[9]:= '######1111####################----##############----N-----#';
  FP[10]:='######----####################----K----##############----N-----#';
  FP[11]:='######1111#######X############----#########X##########----#';
  FP[12]:='######----########################-########################1111#';
  FP[13]:='######1111################X#######-########################----#';
  FP[14]:='######----########################---------N-------------------#';
  FP[15]:='###X##----##########################################-----------#';
  FP[16]:='######---------------7########################X####----########';
  FP[17]:='######---------------7-444444444444444444###########1111########';
  FP[18]:='#####O#############--77##################444########----#####X##';
  FP[19]:='####O##############1111#############X#######4%-####1111########';
  FP[20]:='###O#####XXX#######----#############################----########';
  FP[21]:='##O#####X###Q######-------N------`----------------------########';
  FP[22]:='##O##OOO###########-------N------`---------------------##X#####';
  FP[23]:='###OO###########################################################';
  Fast:=#234;{or #1}
  Convert_Format;
  HideStairs:=true; HideOpenWall:=true;
 end; { Level16 }

procedure Level18;
 begin
  FP[1]:= '###########klose#enkounters#of#the#krazy#kubikal#kind##########';
  FP[2]:= '3                               P                              3';
  FP[3]:= '##-##############:########:#######:###########:##############:##';
  FP[4]:= 'XXXXXXXXX##~W~W~W~W~##-M----M.--$$$$$$$$$-9/-/\--\-|##------';
  FP[5]:= '---------##*~*~*~*~*##-.-M--##$$$$$$$$$##\--/-\-/\##YYYYYYYYY';
  FP[6]:= 'MMMMMMMMM##~W~W~W~W~##M---.-M-##111111111##-/-\/--/-##(((((((((';
  FP[7]:= ')))))))))##*~*~*~*~*##.-.--.##222222222##/\--\-\-/##(((((((((';
  FP[8]:= 'C))))))))--~W~W~W~W~##.----M##333333333##-//-\-/-9-(((((((((';
  FP[9]:= '###################-################################9##55555555-';
  FP[10]:='----##YYYYYYYYY##222222222------0---W##RRRRRRRRR##MMMMMMMMM';
  FP[11]:='-----------YYYYYYYYY##@@@@@@@@@##---000---##RXXXXXXXR##MMMMMMMMM';
  FP[12]:='XXXXXXXXX##YYYYYYYYY##@@@@@@@@@##--00G00--##RXXXKXXXR##MMMMMMMMM';
  FP[13]:='---------##YYYYYYYYY##@@XXX@@@@##---000---##RXXXXXXXR##MMMMMMMMM';
  FP[14]:='##YYYYYYYYK##@@XZX@@@@##----0---W##RRRRRRRRR##MMMMMMMMK';
  FP[15]:='-#####################-############################H##Z########';
  FP[16]:='~-~[~-~-~##WWW......1:1:1:1:1:##-773C7--7##=--=I==-=##Y0"';
  FP[17]:='-~-~-~-~-##WWW......##1:1:1:1:1##7-777-77-##!==-=--==##Y00';
  FP[18]:='~-~-~-~-~##.........##:1:1:1:1:##-77--77-7##=======-=##YYY';
  FP[19]:='-~-~-~-~-##.........##1:1:1:1:1##7-7-77-77##-==-=-==I##';
  FP[20]:='K-~-~-~-~-..<......##:1:1:1:1##77-7777---I=--=-=--=##222222222';
  FP[21]:='############################################################44##';
  FP[22]:='LL---V--V-VV-V--VV---D-----D----D----D--66333333333333333-WWWW';
  FP[23]:='LL--V-VV-V--V-VV--V--D-----D----D----D--66YYYYYYYYYYYYYYYYYYYY';
  Fast:=#234;{or #1}
  Convert_Format;
  TreeRate:=35;
 end; { Level18 }

procedure Level20;
 begin
  FP[1]:= '###key#shop###MTMMMMMMMMMMMMMMMMMMMMM-----MMMMMMMMMMMM-MM--!##LL';
  FP[2]:= '##K44@@@@@##MMMMMMMMMMMMMMMMMMMMMM-MMMMM-MMMMMMMMMM-M-M-P-##LL';
  FP[3]:= '##K3##@@@@@@DMMMMMMCMMMMMMMMMMMMMM-MMMMMMM-MMM<MMMM-MMM----##DD';
  FP[4]:= '##K##@@@@@##M-MMMMMMMMMMMMMMMM---MMMMMMMM-MMMMMMM-MMMMMMMM##DD';
  FP[5]:= '#######X######MM-MMMMMMMMMMM----MMMMMMMMMMMM-MMMMM-MMMMMMMMM##DD';
  FP[6]:= '##-----##MMMMMMM-MMMMM-----MMMMMMMMMMMKMMMMM-MMM-MMMMMMMMMM##DD';
  FP[7]:= '##########MMMMMMTMMMMM-MMMMMMMMMMMMMMMMMMMMMMM-M-MMMMMMMMMMMMMMM';
  FP[8]:= 'MMMMMMMMMMMMMMMMMMMMM-MMMMMMMMMMMMMMMMMMMMMMMMM-MMMMMMCMMMMMM-MM';
  FP[9]:= 'MMMMMMMM-----MMMM----MMMMMMMM[MMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-MMM';
  FP[10]:='MMMM----MMMMM----MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMTMMMMMMMMMMM-MMMM';
  FP[11]:='MMM-MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-MMM';
  FP[12]:='MM-MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-MM';
  FP[13]:='MM-MMMMMMCMMMMMMMMMMMMMMMBWWWWWWWWWW-------------------------MMM';
  FP[14]:='MM-MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-MM';
  FP[15]:='MM-MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMTMMMMMMMMMMMMMMM-M';
  FP[16]:='MMM-------MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM-MM';
  FP[17]:='MMMMMMMMMM-----MMMMMMMMMMMMMMMM]MMMMMMMMM-M-MMMMMMMMMMMMMMMM-MMM';
  FP[18]:=')))))))))MMMMMM-MMMMMMMMMMMMMMMMMMMMMM-M-M-M-MMMMMMMMCMMMMM-MMMM';
  FP[19]:='22222222)MMTMMM-MMMMMCMMMMMMMMMMMMMMM-M-MMMMM-MMM-MMMMMMMM-MMMMM';
  FP[20]:='22222222)MMMMMM-MMMMMMMMMMMMMMM------MMMMMMM-MMM-M-MMMMMM-MMMMMM';
  FP[21]:='22222222)MMMMMM-MMMMMMMMMM-----MMMMMMMMMMMM-MMM-MM-MMMMM-MMMMMMM';
  FP[22]:='--222222)MMMMMM-----------MMMMMMMMMMMMMMMM-MM-M-MMM-M-M-MMMMM"MM';
  FP[23]:='K-222222)MMMMMMMMMMMMMMMMMMMMMMMMMM|MMMMMMM--M-MMMMM-M-MMMMMMMMM';
  Fast:=#234;{or #1}
  Convert_Format;
 end; { Level20 }

procedure Level22;
 begin
  FP[1]:= '1111144       ##C######locksmith#shoppe######C##         RRRRRRR';
  FP[2]:= '1111144       ##]##K#K#K#K#K#-3-3#K#K#K#K#K##]##        RRRRRRR';
  FP[3]:= '1111144          ##:::::::::######::::::::;##         RRRRRRRCYY';
  FP[4]:= '1111144          ##------------------------##     666RRRRRRRR66 ';
  FP[5]:= '1111144          #############--#############     6666666666666 ';
  FP[6]:= '1111144                                           HOOOOOOOOH    ';
  FP[7]:= '1111144                                        6666666666666    ';
  FP[8]:= '1111144                                        66RRRRRRR6666    ';
  FP[9]:= '1111144                                        RRRRRRR          ';
  FP[10]:='1111144                                      RRRRRR           YY';
  FP[11]:='1111144               P                    RRRRRR             YZ';
  FP[12]:='1111144                                 RRRRRRRRRR            YY';
  FP[13]:='1111144                              RRRRR333RRRRR              ';
  FP[14]:='1111144                             RRR3333333RRRRR             ';
  FP[15]:='@@@@@##                           RRR3333333333RRRRR            ';
  FP[16]:='MMMMM##                           RRR333333333RRRRR             ';
  FP[17]:=')))))##                          RRR33333333RRRRR               ';
  FP[18]:='MMMMM##                        RRRR333333RRRRRRR        DDDDDDDD';
  FP[19]:='(((((##                       RRRR3LL3RRRRRRRR          DDDDDDDD';
  FP[20]:='MMMMM##                      RRRRRRRRRRRRRR             DDDDDDDD';
  FP[21]:='$$$$$##                     RRRRRRRRRRRR                DDDD7777';
  FP[22]:='MMMMM##                     RRRRRRRR                    DDDD77';
  FP[23]:=']]K]]##                   RRRRRRK]                     DDDD77!';
  Fast:=#234;{or #1}
  Convert_Format;
  HideCreate:=true;
 end; { Level22 }

procedure Level24;
 begin
  FP[1]:= 'T    P  #the#step#of#faith#------~K-------U-----#---D-D-D-D-LL';
  FP[2]:= '######----------------------44444444--------K--#############';
  FP[3]:= '-----------------------------#       ------#####-#------------';
  FP[4]:= '-----------------------------#        -----:------#-----------';
  FP[5]:= '------###--------------------#        -----:------#----------';
  FP[6]:= '--------#--------------------#        -----:------#-#----------';
  FP[7]:= '--------#--------------------#        -----#####--#-#-----------';
  FP[8]:= '--------#--------------------#        -----#---;--#-#----------';
  FP[9]:= '--------#--------------------#        -----#<###--#-#-----------';
  FP[10]:='--------#------------------#         ----#[#----#-#----------';
  FP[11]:='--K-----#########88888888888#         ----#|#----#-#------W---';
  FP[12]:='-XXX----#      #             #         ----#"#----#-#-------W---';
  FP[13]:='        #      #             #          ---#-#----#-#------W---';
  FP[14]:='        #     #             #          ----------#-##-----W---';
  FP[15]:='        #      #             #             ;;;;;- #K#-----W---';
  FP[16]:='        #      #             #                 +-+####------W---';
  FP[17]:='        #      #             #                 +-+---------W---';
  FP[18]:='    XXXX#      #             #                 +-+---------W---';
  FP[19]:='              #             #                 +-+###-----------';
  FP[20]:='       ###     #             #    U            +-+#--------7----';
  FP[21]:='               #             #                 + +#   ##C.!.C## ';
  FP[22]:='               #             #                 + +#   ######### ';
  FP[23]:='VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV';
  Fast:=#234;{or #1}
  Convert_Format;
  GravOn:=true;GravRate:=0;Sideways:=true;  LavaFlow:=true;LavaRate:=75;
 end; { Level24 }

procedure Level25;
 begin
  FP[1]:= 'K    -++++++++++++++++#the#sacred#temple#+++++++++++++++-    K';
  FP[2]:= ' VVVVVV11111111111111111111111111111111111111111111111111\\\\\\ ';
  FP[3]:= ' VVVV;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;\\\\ ';
  FP[4]:= ' VV1111111111;:::-:::111111111#####111111111::-:::::111111111\\ ';
  FP[5]:= ' V11         :-:-:-::        ###A###        :-:-:--:        11\ ';
  FP[6]:= 'X 1          ::-:::B:        RR#`#RR        :B::-::;         1 X';
  FP[7]:= 'X  22####-####-------------RRRR#D#RRRR-------------####-####22 X';
  FP[8]:= 'X  22##3@-@3##;3;3;3;3;3;3RRRRR#`#RRRRR3;3;3;3;3;3;##~~~~~##22 X';
  FP[9]:= 'X  22##3@-@3##3;3;3;3;3;3RR1C##D##C1RR3;3;3;3;3;3##~~~~~##22 X';
  FP[10]:='X  22##3@-@3##;3;3;3;3;3RR11##`##11RR3;3;3;3;3;##~~~~~##22 X';
  FP[11]:='X--####3@-@3####3;3;3;3RR11#####D#####11RR3;3;3;3####~~~~~####-X';
  FP[12]:='X   U##3@@@3##U ;3;3;3RRB11-+T1   1T+-11BRR3;3;3; U##~~~~~##U  X';
  FP[13]:='X--####3@@@3####3;3;3;3RR11#####P#####11RR3;3;3;3####~~~~~####-X';
  FP[14]:='X  22##3@@@3##;3;3;3;3;3RR1111##U##1111RR3;3;3;3;3;##~~~~~##22 X';
  FP[15]:='X  22##3@@@3##3;3;3;3;3;3RR111#####111RR3;3;3;3;3;3##~~~~~##22 X';
  FP[16]:='X  22##3@K@3##;3;3;3;3;3;3RR111111RR3;3;3;3;3;3;##~~K~~##22 X';
  FP[17]:='X  22#########-----B-------RRRRCRRRR-------B-----#########22 X';
  FP[18]:='X 1  ##|0<0                   RRRRR                   0[0"## 1 X';
  FP[19]:=' R11 #######  11111111111111;--->---;11111111111111  #######11= ';
  FP[20]:=' RR111111111111-VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV-11111111111== ';
  FP[21]:=' RRRR111111111-V V V-V V V-2-V*VCV*V-2-V V-V-V V V-11111111==== ';
  FP[22]:='RRRRRR111111-V V V-2-V V V-V*V*V*V*V-V V V-2-V V V-11111======';
  FP[23]:='KVGVV V V V VV*V*V*V*V*VV V V V VVGVK';
  Fast:=#234;{or #1}
  Convert_Format;
  MagicEWalls:=true;
 end; { Level25 }

BEGIN
END. { Level Layouts }

