
#include "redir.h"
#include "stdio.h"

void Redirector::rdopen(char *fid)
{
   if (onoff == 1) exit(1);
   onoff = 1;
   // note 1 is file handle for stdout
   // redirect stdout to output file
   
   if (- 1 == (fout = open(fid,
            O_CREAT | O_TEXT | O_WRONLY, S_IWRITE)))
      exit(1);
   oldstdout = dup(1);
   dup2(fout, 1);
   close(fout);
}
void Redirector::rdclose(void)
{
   if (onoff == 0) exit(1);
   onoff = 0;
   // recapture stdout
   dup2(oldstdout, 1);
   close(oldstdout);
}
/*
main()
{
Redirector junk("c:\\math\\bump\\stdout.dat");
cout << "silly silly silly silly" << endl;
for( int i=1; i<20; i++ ) cout << i << endl;
junk.rdclose();
for( int j=1; j<20; j++ ) cout << j << endl;

return 0;
}

main()
{
filebuf test;
test.open("ss.out",ios::out);
ostream_withassign x;
x = cout;
x << "hi guy";
cout = &test;
cout << "buy buy guy";
x << "hi guy";
cout = x;
cout << "but guy?";

test.close();
return 0;
}
*/
