/*****************************************************************************/
/*	       Copyright (c) 1994 by Jyrki Salmi <jytasa@jyu.fi>             */
/*        You may modify, recompile and distribute this file freely.         */
/*****************************************************************************/

/*
   Error routines used to report errors occurred in the P.DLL as well as
   in the P.EXE.
*/

#include <stdio.h>
#define INCL_DOSMISC
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include "typedefs.h"
#include "errmsgs.h"
#include "tcpipapi.h"

/* Report an error occurred in the OS/2 API */

void os2_error(U32 num,
	       U32 ret_code,
	       U32 module,
	       U32 line_num,
	       U8 *opt_arg) {

  UCHAR buf[4096];
  ULONG msg_len;
  APIRET rc;

  fprintf(stderr, "\rOS/2 Error %lu:%lu@%lu:%lu: ",
	  num, ret_code,		/* First %lu:%lu */
	  module, line_num);		/* Second %lu:%lu */
  /* Show the verbal description */
  fprintf(stderr, os2_error_msg[num - 1], opt_arg);
  if (ret_code != 0) {
    fprintf(stderr, ", OS/2 reports:\n\n");
    rc = DosGetMessage(NULL,
		       0,
		       buf,
		       4096,
		       ret_code,
		       "OSO001.MSG",
		       &msg_len);
    if (rc) {
      fprintf(stderr,
"Couldn't read error message from file OSO001.MSG which is a part of OS/2\n"
"and usually located in \\OS2\\SYSTEM directory.\n");

    } else {
      fprintf(stderr, "%s\n", buf);

      if (strncmp(buf, "SYS", 3) == 0)
	fprintf(stderr,
"Enter \"HELP %.7s\" at OS/2 prompt to get more information.\n", buf);
    }
  } else
    fprintf(stderr, "\n");

  exit(1);
}

/* Report an error occurred in the TCP/IP API */

void tcpip_error(U32 num,
		 U32 ret_code,
		 U32 module,
		 U32 line_num,
		 U8 *opt_arg) {

  fprintf(stderr, "\rTCP/IP Error %lu:%lu@%lu:%lu: ",
	  num, ret_code,		/* First %lu:%lu */
	  module, line_num);		/* Second %lu:%lu */
  /* Show the verbal description */
  fprintf(stderr, tcpip_error_msg[num - 0x30], opt_arg);
  if (ret_code != 0) {
    fprintf(stderr, ", API reports:\n\n");
    psock_errno(NULL);
  } else
    fprintf(stderr, "\n");

  exit(1);
}
