COMMENT ~
/*-------------------------------------------------------------------------+
| Module: RESEMS.ASM                                                       |
| Project: TOOLS                                                           |
| Author: Paul A. Penrose                                                  |
|         (c) 1992, 4D Interactive Systems, Inc.  All rights reserved.     |
| Start Date: 25 Nov 92                                                    |
| Last Revised: 25 Nov 92                                                  |
| Purpose:                                                                 |
|   This is a TSR that will hook into the EMS driver interrupt and limit   |
|   the amount of free pages available.                                    |
+-------------------------------------------------------------------------*/ ~

IDEAL

MODEL SMALL

CODESEG

old_header      DB 64 DUP(?)
old_offset      DW ?
old_segment     DW ?
ems_function    DB ?
signature1      DW ?
signature2      DW ?
reserved_pages  DW ?

PROC    new_isr
;
; Pass on request after saving the function type
;
        cmp  ah,80H
        jnz  new_isr_010
        or   al,al                      ;is it an installation check?
        jnz  new_isr_001
        mov  ah,al
        jmp  new_isr_ret
new_isr_001:
        cmp  al,01                      ;Is it a request to change the
        jne  new_isr_002                ;  number of reserved pages?
        mov  [cs:reserved_pages],bx
        xor  ah,ah
        jmp  new_isr_ret
new_isr_002:
        mov  ah,8Fh                     ;return subfunction unknown error
        jmp  new_isr_ret
new_isr_010:
        mov  [cs:ems_function],ah
        mov  [cs:signature1],bx         ;save possible signature bytes
        mov  [cs:signature2],dx
        pushf
        call [dword ptr cs:old_offset]  ;call the old ISR
        cmp  [cs:ems_function],42h      ;was it a check for unallocated pages?
        jnz  new_isr_ret
        cmp  [cs:signature1],4444h      ;if both signatures are "DD" then
        jne  new_isr_res                ;  we report the true size
        cmp  [cs:signature2],4444h
        je   new_isr_ret   
new_isr_res:
        sub  bx,[cs:reserved_pages]     ;Reduce by # of reserved pages
        jnc  new_isr_ret
        xor  bx,bx
new_isr_ret:
        iret
ENDP

PROC    main
        push cs                 ;Operate out of CS entirely
        pop  ds
        mov  dx,offset title_msg
        mov  cx,66
        mov  ah,40h
        mov  bx,1               ;stdout
        int  21h                ;write error message to stdout
;
; First check to see if there is an EMS driver loaded and ready
;
        mov  ax,3D00H           ;Open file, read only
        mov  dx,offset ASCII_device_name
        int  21H
        jnc  j001
        jmp  no_driver          ;If not found, report no driver
j001:   mov  bx,ax
        push bx
        mov  ax,4400H           ;Get device info
        int  21H
        pop  bx
        jnc  j002
        jmp  no_driver2
j002:   test dx,0080H           ;Is it a device?
        jnz  j003
        jmp  no_driver2
j003:   push bx
        mov  ax,4407H           ;Is the device ready?
        int  21H
        pop  bx
        or   al,al
        jnz  j004
        jmp  no_driver2
j004:   mov  ax,3E00H           ;Close the driver
        int  21H
;
; Check for a number of pages parameter on the command line
;
        mov  si,80H             ;Point to command tail
        mov  cl,[es:si]         ;check the length
        or   cl,cl
        jnz  convert
        mov  dx,offset no_parm_msg
        mov  cx,31
        jmp  error
;
; Convert number from ASCII to binary form
;
convert:
        cmp  cl,5
        jb   convert_cont
convert_err:
        mov  dx,offset bad_number_msg
        mov  cx,36
        jmp  error
convert_cont:
        mov  ax,0               ;Start accumulator with 0
        xor  ch,ch
        dec  cx                 ;skip first blank
        inc  si
convert_next:
        mov  dx,10              ;Shift partial result by decimal digit
        mul  dx
        mov  bx,ax
        inc  si                 ;Get next char
        mov  al,[es:si]
        sub  al,'0'             ;Convert to binary
        jc   convert_err
        cmp  al,9
        ja   convert_err
        xor  ah,0
        add  ax,bx              ;Add to partial result
        loop convert_next
        mov  [reserved_pages],ax
;
; Check to see if we're already installed
;
        mov  ax,8000h
        int  67h
        or   ah,ah
        jnz  j010
        mov  ax,8001h
        mov  bx,[reserved_pages]     ;change number of pages
        int  67h
        mov  dx,offset changed_msg
        mov  cx,35
        mov  ah,40h
        mov  bx,1               ;stdout
        int  21h                ;write error message to stdout
        mov  ax,4C00H           ;Return to DOS
        int  21H
;
; Write out installation message
;
j010:   mov  dx,offset loaded_msg
        mov  cx,29
        mov  ah,40h
        mov  bx,1               ;stdout
        int  21h                ;write error message to stdout
;
; Now hook into the 67H interrupt
;
        push es
        mov  ax,3567h           ;First get the old ISR address
        int  21h
        mov  ax,es
        mov  [old_segment],ax
        mov  [old_offset],bx
        push ds                 ;Copy the header from the old driver
        pop  es
        mov  ds,ax
        mov  si,0
        mov  di,0
        mov  cx,32
        rep  movsw
        push es                 ;restore DS
        pop  ds
        mov  dx,offset new_isr  ;Now put the address of our new isr into
        mov  ax,2567h           ;  the 67h vector
        int  21h
        pop  ax                 ;get old PSP seg
        mov  dx,cs
        sub  dx,ax              ;dx=number of paragraphs from start of psp to
        mov  ax,offset main     ;  start of code segment
        mov  cl,4
        shr  ax,cl
        add  dx,ax              ;add length of isr code (in paragraphs)
        inc  dx                 ;round up
        mov  ax,3100h
        int  21h                ;Terminate and Stay Resident
        
no_driver2:
        mov  ax,3E00H           ;Close the driver
        int  21H
no_driver:
        mov  dx,offset no_driver_msg
        mov  cx,22
error:
        mov  ah,40h
        mov  bx,1               ;stdout
        int  21h                ;write error message to stdout
        mov  ax,4C01H           ;Return to DOS with error 01
        int  21H
ENDP

ASCII_device_name       DB  'EMMXXXX0', 0
no_driver_msg           DB  'No EMS driver found.',0dh,0ah
no_parm_msg             DB  'Usage is:',0dh,0ah,'  RESEMS num_pages',0dh,0ah
loaded_msg              DB  'Resident portion installed.',0dh,0ah
changed_msg             DB  'Number of reserved pages changed.',0dh,0ah
bad_number_msg          DB  'Illegal number of pages specified.',0dh,0ah
title_msg               DB  'RESEMS Ver 1.1',0dh,0ah
copyright_msg           DB  '(c) Copyright 1992, 4D Interactive Systems, Inc.',0dh,0ah

;SMALLSTACK
STACK 256

END main        
