program Simple_System_Reporter ;
uses crt, dos ;
const
   line_vt = '' ;
var
   dsks, pars, sers, gmss : string ;

   f_f : text ;
   sdspace, sd_free, sd_used : string ;
   dspace, d_free, d_used : longint ;
   p_space, p_free, p_used : real ;

   {<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>}

function comma ( i : longint ) : string;
  var w : string[14];
      c : shortint;
  begin
     str ( i, w );

     c := (length ( w ) - 3);
     while c > 0 do begin
        insert ( ',', w, c + 1 );
        c := c - 3
     end;

     comma := w;
  end;

function leadingzero ( w : word ) : string ;
  var
    s : string ;
  begin
     str ( w : 0, s ) ;
     if length ( s ) = 1 then
        s := '0' + s ;
     leadingzero := s ;
  end ;

{-----}

function DisketteDrives : Integer;
{ SWAG snippet, author : GAYLE DAVIS }
  var
    Regs : Registers;
  begin
     FILLChar ( Regs, SIZEOF ( Regs ), #0 );
     INTR ( $11, Regs );
     if Regs.AX and $0001 = 0 then
        DisketteDrives := 0
     else
        DisketteDrives := ( (Regs.AX shl 8) shr 14) + 1;
  end;

function mouse_installed : char ;
{ adapted from Andrew Verba's TMOUSE.pas unit }
{ Returns true if the mouse driver and hardware are installed.
  Also resets mouse to default settings. }

  var regs : registers;

  begin
     regs.ax := 0;                     { invoke mouse function 0 }
     intr ( $33, regs );

     if regs.ax = 0 then
        mouse_installed := 'n'
     else
        mouse_installed := 'Y';
  end; { function mouse_installed }


procedure check_ems ( var installed : boolean; var ver, ver2 : byte );
{ SWAG snippet }
  var
    regs  :  registers;
  begin
     regs.ah := $46;
     intr ( $67, regs );
     installed := (regs.ah = $00);
     if installed then begin
        ver := (Regs.AL shr 4);
        ver2 := (Regs.AL and $0F);
     end;
  end;

procedure CallEmm ( EmmFunction : Byte; var R : Registers );
{ SWAG snippet }
  begin
     R.AH := EmmFunction;
     Intr ( $67, R );
     if R.AH <> 0 then
        {   showhelp (9); } halt ;
  end;


procedure get_ems ( var totalems, free_ems, used_ems : word );
{ SWAG snippet }
  var
   EmmRegs : Registers;   {Registers for interrupt calls  }
  begin
     CallEmm ( $42, EmmRegs );
     totalems := (EmmRegs.DX);
     free_ems := (EmmRegs.BX);
     used_ems := totalems - free_ems;
  end;

function exttotal : integer ;
{ This code courtesy of Mark Shadley. }  { NOT currently used }
  begin
     asm
        Mov    AL, 18h           { ; MSB of total ext in 1k blocks }
        Mov    DX, 70h           { ; port                          }
        Out    DX, AL            { ; write address to port 70      }
        Mov    DX, 71h           { ; get data from port 71         }
        in     AL, DX            { ; do it                         }
        Xchg   AH, AL            { ; into MSB of AX                }

        Mov    AL, 17h           { ; LSB of total ext in 1k blocks }
        Mov    DX, 70h           { ;                               }
        Out    DX, AL            { ; write address to port 71      }
        Mov    DX, 71h           { ; get data from port 71         }
        in     AL, DX            { ; do it (into LSB of AX)        }
        Mov    @result, AX       { ; save it                       }
     end;
  end;

procedure ioinf ( var dskstr, parstr, serstr, gmsstr : string;
                  var cmem, fmem, umem : word );
{ some code adapted from SWAG snippets and INFOPLUS }
  var
    equip           : word ;
    xbyte1          : byte ;
    regs            : registers ;
    xlong,
    dosmem,
    dmem            : longint ;
    game_installed  : char ;

  begin
     str ( disketteDrives, dskstr );
     dskstr := line_vt + ' Diskettes ' + dskstr + ' ' + line_vt;

     with regs do begin
        Intr ( $11, regs );
        equip := AX;
        Intr ( $12, regs );
        DOSmem := longint ( AX ) shl 10;
     end;

     xbyte1 := equip and $0E00 shr 9;
     str ( xbyte1, serstr );
     serstr := line_vt + ' Ser Ports ' + serstr + ' ' + line_vt;

     xbyte1 := equip and $C000 shr 14;
     str ( xbyte1, parstr );
     parstr := line_vt + ' Par Ports ' + parstr + ' ' + line_vt;

     if (equip and $1000) <> $1000 then
        game_installed := 'n'
     else
        game_installed := 'Y';

     gmsstr := line_vt + ' G=' + game_installed + ' Mouse=' + mouse_installed + ' ' + line_vt;

     dmem := DOSmem div 1024;
     xlong := (DOSmem - ( longint ( PrefixSeg ) shl 4)) div 1024 ;
     cmem := dmem ;
     fmem := xlong ;
     umem := (dmem - xlong) ;

  end;

{-----}

procedure sysinf;
  var
      ver                     : word ;
      dosmajor, dosminor,
      dos_ver                 : string [9] ;
      year,month,day, dow,
      hour,min,sec, hund      : word ;
      xday,
      systemdate, systemtime  : string ;
      disks                   : byte ;
      ems_exists              : boolean ;
      emsh, emsl              : byte ;
      memc, memf, memu,
      totalems, free_ems, used_ems : word ;
  begin
     ver := dosversion ;
     str ( lo ( ver ) , dosmajor );
     str ( hi ( ver ) , dosminor );
     if dosminor = '' then dosminor := '0';
     if length ( dosminor ) = 1 then dosminor := dosminor + '0';
     dos_ver := ('DOS ' + dosmajor + '.' + dosminor);
     getdate ( year, month, day, dow ) ;
     systemdate := (leadingzero ( year mod 100 )) + '-' +
        leadingzero ( month ) + '-' +
        leadingzero ( day ) ;
     case dow of
        0 : xday := 'Sun';
        1 : xday := 'Mon';
        2 : xday := 'Tue';
        3 : xday := 'Wed';
        4 : xday := 'Thu';
        5 : xday := 'Fri';
        6 : xday := 'Sat';
     end;
     xday := ' ' + xday ;
     gettime ( hour, min, sec, hund ) ;
     systemtime := leadingzero ( hour ) + ':' +
        leadingzero ( min ) + ':' +
        leadingzero ( sec ) ;

     ioinf ( dsks, pars, sers, gmss, memc, memf, memu );

     check_ems ( ems_exists, emsh, emsl );
     if ems_exists then
        get_ems ( totalems, free_ems, used_ems )
     else begin
        EMSh := 0;
        EMSl := 0;
        totalems := 0 ;
        free_ems := 0 ;
        used_ems := 0 ;
     end;
     totalems := totalems * 16 ;
     free_ems := free_ems * 16 ;
     used_ems := used_ems * 16 ;

     writeln ( f_f, line_vt, 'Vers' : 9, 'Total' : 7, 'Used' : 7, 'Free ' : 8, dsks,
                    ' SSR Simple System Report 1.00 ', line_vt );
     writeln ( f_f, line_vt, dos_ver : 9, memc : 6, 'k', memu : 6, 'k', memf : 6, 'k ', sers,
                    ' Copyright (c) 1994 Reign Ware ', line_vt );
     writeln ( f_f, line_vt, ' EMS ', emsh : 1, '.', emsl : 1, ' ',
              totalems : 6, 'k', used_ems : 6, 'k', free_ems : 6, 'k ',
                       pars, ' (David Daniel Anderson) Free! ', line_vt );
     writeln ( f_f, line_vt, ' DOS+EMS ',
        memc + totalems : 6, 'k', memu + used_ems : 6, 'k', memf + free_ems : 6, 'k ',
                 gmss, ' Date ', systemdate, xday,
                 ' at ', systemtime, ' ', line_vt );

  end;

function makebar ( numb : byte ) : string ;
  var cntr : byte ;
      mbar : string ;
      full : boolean ;
  begin
     mbar := '';
     if numb > 0 then mbar := '' ;

     full := ( numb > 97 );

     numb := numb div 4 ;

     for cntr := 2 to numb do
        mbar := mbar + '' ;
     while length ( mbar ) < 25 do
        mbar := mbar + '' ;
     if full then mbar[25] := '' ;
     makebar := mbar ;
  end;

procedure writedriveinfo ( cdrive : byte ) ;
  var
       ds, du, df : longint ;
       sds, sdu, sdf : string ;
       pspace, pfree, pused : real ;
       barl : byte ;
       dots : string [25];
  begin
     ds := disksize ( cdrive );
     df := diskfree ( cdrive );
     du := ds - df;

     dspace := dspace + ds; d_free := d_free + df; d_used := d_used + du;

     pfree := df; pused := du;

     pspace := ( pfree + pused  );
     pfree := ( pfree / pspace ) * 100 ;
     pused := ( pused / pspace ) * 100 ;

     ds := ds div 1024; df := df div 1024; du := du div 1024;

     sds := comma ( ds ); sdf := comma ( df ); sdu := comma ( du );

     barl := round ( pused );
     dots := makebar ( barl ) ;

     writeln ( f_f, line_vt, '  ', chr ( cdrive + 64 ) , ':',
        sds : 10, sdu : 10, sdf : 10,
                 pused : 6 : 1, '%', pfree : 6 : 1, '%  ', dots, '  ' );
  end;

{=============================================================================}

function IsDriveValid ( cDrive : Char; var bLocal, bSUBST : Boolean ): Boolean;
{ ** SWAG snippet

  Parameters: cDrive is the drive letter, 'A' to 'Z', that's about
  to be checked. if not in this range, the Function will return False.

  Returns: Function returns True if the given drive is valid, else
  False (!). bLocal is set if drive is local, bSUBST if drive is
  substituted. if Function returns False, the Booleans are undefined.
}
  var
    rCPU: Dos.Registers;
  begin
     { --- Call Dos and process returns --- }
     if not (UpCase ( cDrive ) in ['A'..'Z']) then
     { --- letter OK?--- }
        IsDriveValid := False
     else begin
        { --- Valid letter, set up For the Dos-call --- }
        rCPU.bx := ord ( UpCase ( cDrive ) ) - ord ( 'A' ) + 1;
        rCPU.ax := $4409;
        { --- Call the Dos IOCTL (InOutConTroL)-Functions --- }
        Intr ( $21, rCPU );
        if (rCPU.ax and FCarry) = FCarry then
           IsDriveValid := False
        else begin
           { --- drive is valid, check status --- }
           IsDriveValid := True;
           bLocal := ((rCPU.dx and $1000) = $0000);
           if bLocal then
              bSUBST := ((rCPU.dx and $8000) = $8000)
           else
              bSUBST := False;
        end;
     end;
  end; { IsDriveValid }
{=============================================================================}

const
line1 = 'Ŀ';
line2 = 'Ĵ';
line3 = ' Drv   Total-k    Used-k    Free-k  Used%  Free%  0Utilization100  ';
line4 = '          ';
line5 = '';

var
   cCurChar : Char ;          { loop counter, drive }
   bLocal,
   bSUBST   : Boolean ;       { drive local/remote?; SUBSTed or not? }
   dashes : string [25];

begin
   assign ( f_f , '' );
   rewrite ( f_f );
   writeln ( f_f, line1 );
   sysinf;
   writeln ( f_f, line2 );
   writeln ( f_f, line3 );

   dspace := 0 ;
   d_used := 0 ;
   d_free := 0 ;

   for cCurChar := 'C' to 'Z' do
      if IsDriveValid ( cCurChar, bLocal, bSUBST ) then
         if blocal and (not bSUBST) then
            WriteDriveInfo ( ord ( cCurChar ) - 64 );

   dspace := dspace div 1024;
   d_free := d_free div 1024;
   d_used := d_used div 1024;

   sdspace := comma ( dspace );
   sd_free := comma ( d_free );
   sd_used := comma ( d_used );

   writeln ( f_f, line4 );

   p_free := d_free;
   p_used := d_used;

   p_space := ( p_free + p_used  );
   p_free  := ( p_free / p_space ) * 100 ;
   p_used  := ( p_used / p_space ) * 100 ;

   dashes := makebar ( round ( p_used ) );

   writeln ( f_f, line_vt, ' ALL',
      sdspace : 10, sd_used : 10, sd_free : 10,
      p_used : 6 : 1, '%', p_free : 6 : 1, '%  ',
      dashes, '  ' );

   writeln ( f_f, line5 );
   close ( f_f );
end.
