    DEFINT A-Z

    CONST FALSE = 0
    CONST TRUE = 1

    DECLARE SUB DoQuote (FileName$)
    DECLARE SUB ParseCommandLine (Num%, Arg$())
    DECLARE SUB PutQuote (Text$)
    DECLARE SUB PrintDoc (FileName$)
    DECLARE SUB ShowGimme ()
    DECLARE SUB ShowHelp ()
    DECLARE SUB ShowSyntax ()

    DIM ErrorString$(76): FOR j = 1 TO 76: READ ErrorString$(j): NEXT
    DIM Arguments$(1 TO 20)
    DIM SHARED QuoteText$(1 TO 22)
    DIM SHARED ForeColor, BackColor, Justification
    DIM SHARED StartCol, EndCol, TopLine, WipeScreen

    PRINT
   
    CALL ParseCommandLine(NumArgs%, Arguments$())

    IF Arguments$(1) = "" THEN ShowSyntax

    FOR i = 1 TO NumArgs%
        SELECT CASE LEFT$(Arguments$(i), 2)
        CASE "/?"
            ShowHelp
        CASE "/F"
            IF MID$(Arguments$(i), 3, 1) = ":" THEN
                ExpectedArg$ = MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                SELECT CASE ExpectedArg$
                CASE "BLACK", "BLK"
                    ForeColor% = 1
                CASE "BLUE", "BLU"
                    ForeColor% = 2
                CASE "GREEN", "GRN"
                    ForeColor% = 3
                CASE "CYAN", "CYA"
                    ForeColor% = 4
                CASE "RED"
                    ForeColor% = 5
                CASE "MAGENTA", "MAG"
                    ForeColor% = 6
                CASE "BROWN", "BRN"
                    ForeColor% = 7
                CASE "WHITE", "WHT"
                    ForeColor% = 8
                CASE "GRAY", "GREY", "GRY"
                    ForeColor% = 9
                CASE "LTBLUE", "LBL"
                    ForeColor% = 10
                CASE "LTGREEN", "LGR"
                    ForeColor% = 11
                CASE "LTCYAN", "LCY"
                    ForeColor% = 12
                CASE "LTRED", "LRD"
                    ForeColor% = 13
                CASE "LTMAGENTA", "LMG"
                    ForeColor% = 14
                CASE "YELLOW", "YEL"
                    ForeColor% = 15
                CASE "BRWHITE", "BRW"
                    ForeColor% = 16
                CASE ELSE
                    CommandError = TRUE
                    PRINT "Invalid foreground specification:  "; ExpectedArg$
                END SELECT
                ExpectedArg$ = ""
            ELSE
                CommandError = TRUE
                PRINT "Missing colon in switch:  "; Arguments$(i)
            END IF
        CASE "/B"
            IF MID$(Arguments$(i), 3, 1) = ":" THEN
                ExpectedArg$ = MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                SELECT CASE ExpectedArg$
                CASE "BLACK", "BLK"
                    BackColor% = 1
                CASE "BLUE", "BLU"
                    BackColor% = 2
                CASE "GREEN", "GRN"
                    BackColor% = 3
                CASE "CYAN", "CYA"
                    BackColor% = 4
                CASE "RED"
                    BackColor% = 5
                CASE "MAGENTA", "MAG"
                    BackColor% = 6
                CASE "BROWN", "BRN"
                    BackColor% = 7
                CASE "WHITE", "WHT"
                    BackColor% = 8
                CASE "GRAY", "GREY", "GRY"
                    BackColor% = 9
                CASE "LTBLUE", "LBL"
                    BackColor% = 10
                CASE "LTGREEN", "LGR"
                    BackColor% = 11
                CASE "LTCYAN", "LCY"
                    BackColor% = 12
                CASE "LTRED", "LRD"
                    BackColor% = 13
                CASE "LTMAGENTA", "LMG"
                    BackColor% = 14
                CASE "YELLOW", "YEL"
                    BackColor% = 15
                CASE "BRWHITE", "BRW"
                    BackColor% = 16
                CASE ELSE
                    CommandError = TRUE
                    PRINT "Invalid background specification:  "; ExpectedArg$
                END SELECT
                ExpectedArg$ = ""
            ELSE
                CommandError = TRUE
                PRINT "Missing colon in switch:  "; Arguments$(i)
            END IF
        CASE "/L"
            IF LEN(Arguments$(i)) = 2 THEN
                IF NOT (Justification) THEN
                    Justification = 1
                ELSE
                    CommandError = TRUE
                    PRINT "Multiple text justifications are not allowed:  "; Arguments$(i)
                END IF
            ELSE
                CommandError = TRUE
                PRINT "Invalid switch:  "; Arguments$(i)
            END IF
        CASE "/C"
            IF LEN(Arguments$(i)) = 2 THEN
                IF NOT (Justification) THEN
                    Justification = 2
                ELSE
                    CommandError = TRUE
                    PRINT "Multiple text justifications are not allowed:  "; Arguments$(i)
                END IF
            ELSE
                CommandError = TRUE
                PRINT "Invalid switch:  "; Arguments$(i)
            END IF
        CASE "/R"
            IF LEN(Arguments$(i)) = 2 THEN
                IF NOT (Justification) THEN
                    Justification = 3
                ELSE
                    CommandError = TRUE
                    PRINT "Multiple text justifications are not allowed:  "; Arguments$(i)
                END IF
            ELSE
                CommandError = TRUE
                PRINT "Invalid switch:  "; Arguments$(i)
            END IF
        CASE "/S"
            IF MID$(Arguments$(i), 3, 1) = ":" THEN
                ExpectedArg = VAL(MID$(Arguments$(i), 4, LEN(Arguments$(i))))
                IF (ExpectedArg > 0) AND (ExpectedArg < 31) THEN
                    StartCol = ExpectedArg
                ELSE
                    CommandError = TRUE
                    PRINT "Invalid starting column:  "; MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                END IF
                ExpectedArg = 0
            ELSE
                CommandError = TRUE
                PRINT "Missing colon in switch:  "; Arguments$(i)
            END IF
        CASE "/E"
            IF MID$(Arguments$(i), 3, 1) = ":" THEN
                ExpectedArg = VAL(MID$(Arguments$(i), 4, LEN(Arguments$(i))))
                IF (ExpectedArg > 49) AND (ExpectedArg < 81) THEN
                    EndCol = ExpectedArg
                ELSE
                    CommandError = TRUE
                    PRINT "Invalid ending column:  "; MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                END IF
                ExpectedArg = 0
            ELSE
                CommandError = TRUE
                PRINT "Missing colon in switch:  "; Arguments$(i)
            END IF
        CASE "/T"
            IF MID$(Arguments$(i), 3, 1) = ":" THEN
                ExpectedArg = VAL(MID$(Arguments$(i), 4, LEN(Arguments$(i))))
                IF (ExpectedArg > 0) AND (ExpectedArg < 25) THEN
                    TopLine = ExpectedArg
                ELSE
                    CommandError = TRUE
                    PRINT "Invalid top line:  "; MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                END IF
                ExpectedArg = 0
            ELSE
                CommandError = TRUE
                PRINT "Missing colon in switch:  "; Arguments$(i)
            END IF
        CASE "/W"
            IF LEN(Arguments$(i)) = 2 THEN
                WipeScreen = TRUE
            ELSE
                CommandError = TRUE
                PRINT "Invalid switch:  "; Arguments$(i)
            END IF
        CASE "/$"
            IF CommandError = FALSE THEN
                IF LEN(Arguments$(i)) = 2 THEN
                    ShowGimme
                ELSE
                    CommandError = TRUE
                    PRINT "Invalid switch:  "; Arguments$(i)
                END IF
            END IF
        CASE "/D"
            ON ERROR GOTO PrintDocError
            IF CommandError = FALSE THEN
                IF MID$(Arguments$(i), 3, 1) = ":" THEN
                    FileName$ = MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                    IF FileName$ <> "" THEN
                        IF FileName$ <> "CLOCK$" THEN
                            FileName$ = MID$(Arguments$(i), 4, LEN(Arguments$(i)))
                        ELSE
                            ERROR 25
                        END IF
                        CALL PrintDoc(FileName$)
                    ELSE
                        FileName$ = "DAYQUOTE.DOC"
                        CALL PrintDoc(FileName$)
                    END IF
                ELSE
                    FileName$ = "DAYQUOTE.DOC"
                    CALL PrintDoc(FileName$)
                END IF
            END IF
        CASE ELSE
            IF LEFT$(Arguments$(i), 1) = "/" THEN
                CommandError = TRUE
                PRINT "Invalid switch:  "; Arguments$(i)
            ELSE
                QuoteFile$ = Arguments$(i)
            END IF
        END SELECT
    NEXT i

    IF QuoteFile$ = "" THEN
        PRINT "Quote file not specified."
        PRINT
        PRINT "Type 'DAYQUOTE /?' for help."
    ELSE
        IF (CommandError) THEN
            PRINT
            PRINT "Type 'DAYQUOTE /?' for help."
        ELSE
            SELECT CASE QuoteFile$
            CASE "CON", "AUX", "PRN", "CLOCK$", "COM1", "COM2"
                PRINT "Quote file can not be a reserved device name:  "; QuoteFile$
            CASE "COM3", "COM4", "LPT1", "LPT2", "LPT3"
                PRINT "Quote file can not be a reserved device name:  "; QuoteFile$
            CASE ELSE
                CALL DoQuote(QuoteFile$)
            END SELECT
        END IF
    END IF

    SYSTEM


QuoteFileError:
    SELECT CASE ERR
    CASE 6
        PRINT "Overflow reading file:  "; QuoteFile$
        PRINT QuoteFile$; " is too large."
        SYSTEM
    CASE 53
        PRINT "Problem looking for quote file:  "; QuoteFile$
        SYSTEM
    CASE 57
        PRINT "Unsupported disk format encountered looking for file:  "; QuoteFile$
        SYSTEM
    CASE 64
        PRINT "Bad file name:  "; QuoteFile$
        SYSTEM
    CASE 71
        PRINT "Drive not ready looking for quote file:  "; QuoteFile$
        SYSTEM
    CASE 76
        PRINT "Path not found looking for quote file:  "; QuoteFile$
        SYSTEM
    CASE ELSE
        PRINT "System error number #"; LTRIM$(STR$(ERR)); " handling quote file:  "; QuoteFile$
        PRINT "- "; ErrorString$(ERR); " -"
        SYSTEM
    END SELECT

PrintDocError:
    SELECT CASE ERR
    CASE 25
        SELECT CASE FileName$
        CASE "CLOCK$"
            PRINT "Are you really that determined to fuck things up?"
        CASE "PRN"
            PRINT "Printer is not responding at attempt to print file."
        CASE "COM1", "COM2", "COM3", "COM4", "LPT1", "LPT2", "LPT3"
            PRINT FileName$; " is not responding at attempt to print file."
        CASE ELSE
            PRINT "Device fault error printing to file:  "; FileName$
        END SELECT
        SYSTEM
    CASE 57
        PRINT "Unsupported disk format encountered printing to file:  "; FileName$
        SYSTEM
    CASE 64
        PRINT "Bad file name:  "; FileName$
        SYSTEM
    CASE 68
        PRINT "Path not found printing to file:  "; FileName$
        SYSTEM
    CASE 71
        PRINT "Drive not ready printing to file:  "; FileName$
        SYSTEM
    CASE 75
        SELECT CASE TryDirectory
        CASE FALSE
            TryDirectory = TRUE
            SELECT CASE RIGHT$(FileName$, 1)
            CASE ":", "\"
                FileName$ = FileName$ + "DAYQUOTE.DOC"
            CASE ELSE
                FileName$ = FileName$ + "\DAYQUOTE.DOC"
            END SELECT
            RESUME
        CASE ELSE
            PRINT "Path not found printing to file:  "; FileName$
            SYSTEM
        END SELECT
    CASE 76
        PRINT "Path not found printing to file:  "; FileName$
        SYSTEM
    CASE ELSE
        IF ERR = 61 THEN KILL FileName$: PRINT
        PRINT "System error number #"; LTRIM$(STR$(ERR)); " printing to file:  "; FileName$
        PRINT "- "; ErrorString$(ERR); " -"
        SYSTEM
    END SELECT

MiscErrors:
    SELECT CASE ERR
    CASE ELSE
        PRINT "System error number #"; LTRIM$(STR$(ERR)); " displaying quote from file:  "; QuoteFile$
        PRINT "- "; ErrorString$(ERR); " -"
        SYSTEM
    END SELECT


'
'   BASIC ERRor string data
'
    DATA "NEXT without FOR"
    DATA "Syntax error"
    DATA "RETURN without GOSUB"
    DATA "Out of DATA"
    DATA "Illegal function call"
    DATA "Overflow"
    DATA "Out of memory"
    DATA "Undefined line number"
    DATA "Subscript out of range"
    DATA "Duplicate definition"
    DATA "Division by zero"
    DATA "Illegal direct"
    DATA "Type mismatch"
    DATA "Out of string space"
    DATA "String too long"
    DATA "String formula too complex"
    DATA "Can't continue"
    DATA "Undefined user function"
    DATA "No RESUME"
    DATA "RESUME without error"
    DATA "Description not found"
    DATA "Missing operand"
    DATA "Line buffer overflow"
    DATA "Device timeout"
    DATA "Device fault"
    DATA "FOR without NEXT"
    DATA "Out of paper"
    DATA "Description not found"
    DATA "WHILE without WEND"
    DATA "WEND without WHILE"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Description not found"
    DATA "FIELD overflow"
    DATA "Internal error"
    DATA "Bad file number"
    DATA "File not found"
    DATA "Bad file mode"
    DATA "File already open"
    DATA "Description not found"
    DATA "Device I/O error"
    DATA "File already exists"
    DATA "Description not found"
    DATA "Description not found"
    DATA "Disk full"
    DATA "Input past end"
    DATA "Bad record number"
    DATA "Bad file name"
    DATA "Description not found"
    DATA "Direct statement in file"
    DATA "Too many files"
    DATA "Device unavailable"
    DATA "Communication buffer overflow"
    DATA "Disk write-protected - Permission denied"
    DATA "Disk not ready"
    DATA "Disk media error"
    DATA "Advanced feature"
    DATA "Rename across disks"
    DATA "Path/file access error"
    DATA "Path not found"

SUB DoQuote (QuoteFile$)

    ON ERROR GOTO QuoteFileError
  
    OPEN QuoteFile$ FOR INPUT AS #1
    CLOSE #1

    OPEN QuoteFile$ FOR BINARY AS #1

    IF LOF(1) = 0 THEN
        PRINT "Attempt to read an empty file:  "; QuoteFile$
        CLOSE #1
        EXIT SUB
    END IF
   
    RANDOMIZE TIMER
    Position! = FIX(RND * LOF(1)) + 2

    DO WHILE BeginningFound = FALSE
        GET #1, Position!, Dummy%
        Char$ = LEFT$(MKI$(Dummy%), 1)
      
        SELECT CASE Char$
        CASE CHR$(13), CHR$(10)
            Count = Count + 1
            IF Count = 4 THEN
                IF BeginningReady = TRUE THEN
                    IF (FIX(RND * 10) + 1) > 3 THEN
                        BeginningFound = TRUE
                    ELSE
                        BeginningReady = FALSE
                        Count = 0
                    END IF
                END IF
            END IF
        CASE CHR$(32), CHR$(9)
            Count = 0
        CASE CHR$(0) TO CHR$(8), CHR$(11), CHR$(12), CHR$(26), CHR$(29), CHR$(30)
            PRINT "Attempt to read a binary file or non-text characters found in:  "; QuoteFile$
            IF Position! < 100 THEN
                Position! = Position! + (100 - Position!)
            ELSE
                Position! = Position! - 100
            END IF
            BreakPos! = Position!
            StartPos! = Position!
            PRINT
            PRINT "Reference block:"
            PRINT STRING$(80, "");
            DO WHILE Done = FALSE
                IF (Position! = LOF(1)) THEN Done = TRUE
                IF (Position! = BreakPos! + 200) THEN Done = TRUE
                GET #1, Position!, Dummy%
                Char$ = LEFT$(MKI$(Dummy%), 1)
                SELECT CASE Char$
                CASE CHR$(10)
                    IF Last$ <> CHR$(13) THEN
                        PRINT Char$;
                    END IF
                CASE CHR$(7), CHR$(11), CHR$(12), CHR$(29), CHR$(30)
                CASE ELSE
                    PRINT Char$;
                END SELECT
                Position! = Position! + 1
                Last$ = Char$
            LOOP
            PRINT STRING$(80, "")
            PRINT "found at location"; StartPos!; "to"; Position!
            CLOSE #1
            EXIT SUB
        CASE ELSE
            BegPos! = Position!
            BeginningReady = TRUE
            Count = 0
        END SELECT

        Size% = Size% + 1
        IF Size% > 1672 THEN
            PRINT "File read error - size of object in:  "; QuoteFile$
            PRINT QuoteFile$; " is possibly not a quote file."
            CLOSE #1
            EXIT SUB
        END IF
     
        Position! = Position! - 1
        IF Position! = 0 THEN
            IF BeginningReady = TRUE THEN
                BeginningFound = TRUE
            ELSE
                Position! = LOF(1)
            END IF
        END IF
    LOOP
   
    Count = 0
    Size% = 0
    Position! = BegPos!
  
    DO WHILE EndingFound = FALSE
        IF Position! = LOF(1) THEN EndingFound = TRUE
        GET #1, Position!, Dummy%
        Char$ = LEFT$(MKI$(Dummy%), 1)
      
        SELECT CASE Char$
        CASE CHR$(13), CHR$(10)
            IF INT(Count / 2) = Count / 2 THEN Quote$ = Quote$ + CHR$(32)
            Last$ = CHR$(32)
            Count = Count + 1
            IF EndingReady = TRUE THEN
                Count = 0
                EndingFound = TRUE
            END IF
            IF Count = 2 THEN
                EndingReady = TRUE
            END IF
            IF Position! = LOF(1) THEN
                Count = 0
                EndingFound = TRUE
            END IF
        CASE CHR$(32), CHR$(9)
            IF Last$ <> Char$ THEN Quote$ = Quote$ + Char$
            Count = 0
        CASE CHR$(0) TO CHR$(8), CHR$(11), CHR$(12), CHR$(26), CHR$(29), CHR$(30)
            PRINT "Attempt to read a binary file or non-text characters found in:  "; QuoteFile$
            IF Position! < 100 THEN
                Position! = Position! + (100 - Position!)
            ELSE
                Position! = Position! - 100
            END IF
            BreakPos! = Position!
            StartPos! = Position!
            PRINT
            PRINT "Reference block:"
            PRINT STRING$(80, "");
            DO WHILE Done = FALSE
                IF (Position! = LOF(1)) THEN Done = TRUE
                IF (Position! = BreakPos! + 200) THEN Done = TRUE
                GET #1, Position!, Dummy%
                Char$ = LEFT$(MKI$(Dummy%), 1)
                SELECT CASE Char$
                CASE CHR$(10)
                    IF Prev$ <> CHR$(13) THEN
                        PRINT Char$;
                    END IF
                CASE CHR$(7), CHR$(11), CHR$(12), CHR$(29), CHR$(30)
                CASE ELSE
                    PRINT Char$;
                END SELECT
                Position! = Position! + 1
                Prev$ = Char$
            LOOP
            PRINT STRING$(80, "")
            PRINT "found at location"; StartPos!; "to"; Position!
            CLOSE #1
            EXIT SUB
        CASE ELSE
            Quote$ = Quote$ + Char$
            IF EndingReady = TRUE THEN EndingReady = FALSE
            Count = 0
        END SELECT
      
        Size% = Size% + 1
        IF Size% > 1672 THEN
            PRINT "File read error - size of object in:  "; QuoteFile$
            PRINT "  "; QuoteFile$; " is possibly not a quote file."
            CLOSE #1
            EXIT SUB
        END IF
    
        Position! = Position! + 1
        Last$ = Char$
    LOOP
    Count = 0
  
    CLOSE #1

    IF Quote$ <> "" THEN
        Quote$ = LTRIM$(RTRIM$(Quote$)) + CHR$(32)
        CALL PutQuote(Quote$)
    ELSE
        PRINT "No quotes found in file:  ", QuoteFile$
        EXIT SUB
    END IF

END SUB

SUB ParseCommandLine (NumArgs%, Args$())

    NumArgs% = 0: in = FALSE: switch = FALSE
    Comline$ = COMMAND$
    Length = LEN(Comline$)
    FOR Increment = 1 TO Length
        Char$ = MID$(Comline$, Increment, 1)
        SELECT CASE Char$
        CASE CHR$(32), CHR$(9)
            IF (in) THEN
                IF NumArgs% = 20 THEN EXIT FOR
                NumArgs% = NumArgs% + 1
                in = FALSE
            END IF
        CASE "/"
            IF (in) OR (NumArgs% = 0) THEN NumArgs% = NumArgs% + 1
            in = TRUE
            Args$(NumArgs%) = Args$(NumArgs%) + Char$
        CASE ELSE
            IF (NumArgs% = 0) THEN NumArgs% = NumArgs% + 1
            in = TRUE
            Args$(NumArgs%) = Args$(NumArgs%) + Char$
        END SELECT
    NEXT Increment

    IF NumArgs% > 0 THEN IF Args$(NumArgs%) = "" THEN NumArgs% = NumArgs% - 1

END SUB

SUB PutQuote (Text$)

    ON ERROR GOTO MiscErrors

    CurrentLine = CSRLIN
   
    IF StartCol = 0 THEN StartCol = 10
    IF EndCol = 0 THEN EndCol = 70
    IF TopLine = 0 THEN TopLine = CurrentLine
   
    QuoteWidth = EndCol - StartCol + 1 - 4
    StringLength = LEN(Text$) - 1           ' -1 nullifies terminating char
   
    IF StringLength > QuoteWidth THEN
        IF (StringLength / QuoteWidth) = INT(StringLength / QuoteWidth) THEN
            NumLines = StringLength / QuoteWidth
        ELSE
            NumLines = INT(StringLength / QuoteWidth) + 1
        END IF
    ELSE
        NumLines = 1
    END IF

    IF NumLines > 21 THEN
        PRINT "Quote text is too long to fit in the specified frame."
        EXIT SUB
    END IF

    IF INSTR(Text$, "~~") THEN
        MarkPos = INSTR(Text$, "~~")
        AttribName$ = "- " + LEFT$(RTRIM$(MID$(Text$, MarkPos + 2, StringLength - MarkPos + 2)), QuoteWidth)
        AttribText$ = SPACE$(QuoteWidth - LEN(AttribName$)) + AttribName$
        Text$ = RTRIM$(LEFT$(Text$, MarkPos - 1)) + CHR$(32)
        Attribute = TRUE
    END IF

Compensate:

    FOR j = 1 TO NumLines
        Portion$ = MID$(Text$, LastRef + 1, QuoteWidth + 1)
        FOR k = LEN(Portion$) TO 1 STEP -1
            IF MID$(Portion$, k, 1) = CHR$(32) THEN
                QuoteText$(j) = LTRIM$(RTRIM$(MID$(Portion$, 1, k - 1)))
                LastRef = LastRef + k
                EXIT FOR
            ELSEIF k = 1 THEN
                QuoteText$(j) = MID$(Portion$, 1, LEN(Portion$) - 2) + "-"
                LastRef = LastRef + LEN(Portion$) - 2
                EXIT FOR
            ELSE
                QuoteText$(j) = LTRIM$(RTRIM$(MID$(Portion$, 1, k)))
            END IF
        NEXT k

        IF j = NumLines THEN
            IF RIGHT$(QuoteText$(j), 1) <> MID$(Text$, StringLength, 1) THEN
                LastRef = 0
                NumLines = NumLines + 1
                IF NumLines > 21 THEN
                    PRINT "Quote text is too long to fit in the specified frame."
                    EXIT SUB
                END IF
                GOTO Compensate
            END IF
        END IF
  
    NEXT j
   
    IF Attribute = TRUE THEN QuoteText$(j - 1) = AttribText$
  
    IF (TopLine + NumLines) > 22 THEN
        TopLine = TopLine - ((TopLine + NumLines) - 22)
        PRINT STRING$(NumLines + 1, CHR$(10))
    END IF

    IF WipeScreen = TRUE THEN CLS

    IF ForeColor > 0 THEN COLOR ForeColor - 1
    IF BackColor > 0 THEN COLOR , BackColor - 1
   
    LOCATE TopLine, StartCol
    PRINT ""; STRING$(QuoteWidth + 2, ""); "";

    FOR i = 1 TO NumLines
        j = TopLine + i

        LOCATE j, StartCol
        PRINT ""; STRING$(QuoteWidth + 2, " "); "";
                   
        SELECT CASE Justification
        CASE 1        'LEFT
            LOCATE j, StartCol + 2
        CASE 2        'CENTERED
            LOCATE j, StartCol + 2 + INT((QuoteWidth - LEN(QuoteText$(i))) / 2)
        CASE 3        'RIGHT
            LOCATE j, StartCol + 2 + (QuoteWidth - LEN(QuoteText$(i)))
        CASE ELSE     'LEFT DEFAULT
            LOCATE j, StartCol + 2
        END SELECT
        PRINT QuoteText$(i);
    NEXT i

    LOCATE j + 1, StartCol
    PRINT ""; STRING$(QuoteWidth + 2, ""); "";
   
    IF j + 2 > CurrentLine THEN CurrentLine = j + 2

    COLOR 7, 0
    PRINT ;
   
    LOCATE CurrentLine, 1

END SUB

SUB ShowGimme

    PRINT
    PRINT "       Ŀ         ";
    PRINT "        Dayquote 1.0    Copyright 1994, 1995 by Freeware Unlimited.          ";
    PRINT "       Ĵ         ";
    PRINT "                                                                              ";
    PRINT "         That's Right!  If you send me money, then I'll send 10% of           ";
    PRINT "         it directly back to you!!!  The more money you send to me,           ";
    PRINT "         the more money that will be sent to *YOU*...  Think of it!           ";
    PRINT "                                                                              ";
    PRINT "         As a FREE bonus,  I'll also send you a catalog,  if I have           ";
    PRINT "         one finished, as well as MORE FREE SOFTWARE, if I have any           ";
    PRINT "         more programs done.  If you'll tell me what this program's           ";
    PRINT "         version number is, I'll ALSO send you a FREE UPGRADE,  if,           ";
    PRINT "         of course, there is one available.  Thank you, in advance.           ";
    PRINT "                                                                              ";
    PRINT "                                                                              ";
    PRINT "               FreeWare Unlimited                 ";
    PRINT "                                                                              ";
    PRINT "              12316 138th Street    Largo, Florida 34644-3016                ";
    PRINT "                                                                              ";
    PRINT "                ";
    PRINT

    SYSTEM

END SUB

SUB ShowHelp

    PRINT
    PRINT "       Ŀ         ";
    PRINT "        DayQuote 1.0    Copyright 1994, 1995 by Freeware Unlimited.          ";
    PRINT "       Ĵ         ";
    PRINT "        Usage: DAYQUOTE [switches] quotefil.ext                               ";
    PRINT "                                                                              ";
    PRINT "         Switches:                                                            ";
    PRINT "          /?     - Shows this help screen.                                    ";
    PRINT "          /F:c   - Use foreground color 'c', as listed below.                 ";
    PRINT "          /B:c   - Use background color 'c', as listed below.                 ";
    PRINT "          /L     - Left-justify the text.                                     ";
    PRINT "          /R     - Right-justify the text.                                    ";
    PRINT "          /C     - Center the text.                                           ";
    PRINT "          /S:#   - Start at specified column # (1-30). Default = 10           ";
    PRINT "          /E:#   - End at specified column # (50-80).  Default = 70           ";
    PRINT "          /T:#   - Top line # to begin on (1-24). Default = current           ";
    PRINT "          /W     - Wipe (clear) the screen before displaying.                 ";
    PRINT "          /D[:n] - Create documentation file, DAYQUOTE.DOC, or 'n'.           ";
    PRINT "          /$     - Get money sent to you.                                     ";
    PRINT "                                                                              ";
    PRINT "           Available foreground colors and background colors are:             ";
    PRINT "                                                                              ";
    PRINT "         BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, WHITE, GRAY           ";
    PRINT "         LTBLUE, LTGREEN, LTCYAN, LTRED, LTMAGENTA, YELLOW, BRWHITE           ";
    PRINT "                ";

    SYSTEM

END SUB

SUB ShowSyntax

    PRINT "Usage: DAYQUOTE [switches] quotefil.ext"
    PRINT
    PRINT "(Type 'DAYQUOTE /?' for help.)"
    SYSTEM

END SUB

