/**********************************************************************/
/*                                                                    */
/* Demonstration of the Pentium Floating-Point Division Bug.          */
/*                                                                    */
/* The program performs the floating-point calculation C = (A/B)*B    */
/* for all values of A and B over a carefully selected limited range. */
/* If A and C differ by more than 1 binary count, the program reports */
/* the error. Printout columns 1,2,3 are A,B,C in decimal. (Notice    */
/* that columns 1 and 3 are unequal.) Columns 4,5,6 are A,B,C in      */
/* hexadecimal. Column 7 is C-A, the error's magnitude.               */
/*                                                                    */
/* The division bug doesn't seem to care about the sign or binary     */
/* exponent, so similar errors occur if you use negative values or    */
/* values scaled by a power of two.                                   */
/*                                                                    */
/* The bug seems to be 100% stable and consistent on 90MHz Pentiums.  */
/* A similar bug exists in double precision division.                 */
/*                                                                    */
/**********************************************************************/

#include <stdio.h>


int main(void)
{
  int mistakes=0;
  float a, b, c;
  #define i (*(unsigned long*)&a)    /* access the floats as ulongs */
  #define j (*(unsigned long*)&b)
  #define k (*(unsigned long*)&c)

  printf("\nChecking for Pentium floating-point division bug...\n");
  for (i=0x40000000L; i<=0x40001000L; i++)   /* Don't care bits: 0xFF800000 */
    for (j=0x403FFFC0L; j<=0x40400000L; j++) /* Don't care bits: 0xFF800000 */
    {
      c = a/b;
      c *= b;
      if ((long)(i-k)<-1 || (long)(i-k)>1)
      {
        printf("  %.7f / %.7f : %.7f    %08lX / %08lX : %08lX (%+ld)\n", a, b, c, i, j, k, k-i);
        mistakes++;
      }
    }
  if (mistakes)
    printf("%d mistakes. You have a genuine Intel Pentium CPU.\n", mistakes);
  else
    printf("No mistakes.\n");
  return 0;
}
