/*
 * ISDEVICE - Will invoke Ms-Dos IOCTL function to "get" the attributes of
 * the specified DOS handle.
 *
 * Result := True     If the specified handle is a device. := False    If the
 * specified handle is a file.
 *
 * Caution: A True return only indicates that the handle is assigned to a device
 * driver.  These include the CON, PRN, AUX and any user installed device
 * drivers.
 *
 * A False return indicates that the handle is assigned to a file that may be on
 * a Floppy, Hard Disk or Ram Disk.
 */

#include <stdio.h>
#include <dos.h>

 int
isdevice (int handle) {
	union REGS      R;

	R.x.ax = 0x4400;			/* MS-DOS IOCTL "Get" function */
	R.x.bx = handle;			/* ... Handle for IOCTL "Get"  */
	R.x.dx = 0;
	intdos(&R, &R);				/* ... MS-DOS Entry Interrupt  */
	if ((R.x.dx & 0x80) == 0) return (0);
	else return (1);
}
