{BLOKE and related files were created by Lee David Rimar}
{ Released to public domain in September 1994 }

{ Compiler directives }

{$D+,L+}   { Include debugging code?             }
{$I-,R-}   { Don't check I/O or array ranges yet }
{$A+,B-}   { Align data, do fast boolean checks  }
{$S-,V-}   { Don't check stack, vars             }
{$N-,E-}   { No FPU, real or emulated            }
{$F-,O-}   { Don't use far calls or overlays     }
{$G-}      { Don't expect world to have 286/386  }

{$DEFINE PCPLUS} {Define to produce ProComm Plus .DIRs}
                 {UNdefining it saves some .exe size}

PROGRAM BLOKE(INPUT, OUTPUT);
USES Dos, Overlay;

CONST

  CreditString = 'BLOKE 5.3f: by Lee David Rimar';

  {$I NPA313.inc }

  { now would be a good time to introduce some genuine constants }

  modeLoc = 1;
  modeMid = 2;
  modeFar = 3;

  { Other miscellaneous pre-initialized strings }

  ofile  : STRING[12] = '.LOC';
  modstr : ARRAY[1..3] OF STRING[3] = ('LOC', 'MID', 'FAR');
  s4     : STRING[04] = '';
  s3     : STRING[03] = '';
  s2     : STRING[02] = '';
  mode   : INTEGER = 1;
  i      : INTEGER = 0;
  j      : INTEGER = 0;
  k      : INTEGER = 0;
  ii     : INTEGER = 0;
  quit   : BOOLEAN = FALSE;
  fexist : BOOLEAN = FALSE;
  acodes : BOOLEAN = TRUE;
  {$IFDEF PCPLUS}
  pcplus : BOOLEAN = FALSE;
  {$ENDIF}

TYPE

  Strip   = ARRAY[0..maxexc] OF BOOLEAN;

  Str95   = STRING[95];
  LinePtr = ^LineRec;
  LineRec = RECORD
    nxt   : LinePtr;  { 4 bytes, pointer to next record }
    txt   : Str95;    { 96 bytes (95 + length), text from file }
    loc   : SHORTINT; { 1 byte, location of BBS }
  END;

  {$IFDEF PCPLUS}
  ddrec = RECORD                       { stuff I use or change: }
    ddnp       : ARRAY[1..46] OF BYTE; { chunk of horst mann's list }
    ddbaud     : INTEGER;              { baud rate }
    ddpar      : BYTE;                 { parity    }
    dddata     : BYTE;                 { data bits }
    ddstop     : BYTE;                 { stop bits }
    dddup      : BYTE;                 { duplex    }
    ddscript   : ARRAY[1..9] OF BYTE;
    ddlast     : ARRAY[1..9] OF BYTE;
    ddtotal    : INTEGER;
    ddproto    : BYTE;
    ddterm     : BYTE;                 { terminal type }
    ddmode     : BYTE;
    ddpassword : ARRAY[1..11] OF BYTE;
    ddmacfile  : ARRAY[1..9] OF BYTE;
    ddkbdfile  : ARRAY[1..9] OF BYTE;
    ddport     : BYTE;                 { com port to use }
    ddnotefile : ARRAY[1..9] OF BYTE;
  END;

  ddrecPtr = ^ddrec;

  dirFile = RECORD
    header : ARRAY[1..250] OF CHAR;
    entry : ARRAY[1..200] OF ddrec;
  END;

  parmFile = RECORD
    port        : INTEGER;
    baud        : INTEGER;
    parity      : INTEGER;
    sbits       : INTEGER;
    dbits       : INTEGER;
    mdm_timeout : INTEGER;
    mdm_pause   : INTEGER;
    abdetect    : INTEGER;
    ddtrflg     : INTEGER;
    redialc     : INTEGER;
    cdover      : INTEGER;
    maxcalls    : INTEGER;
    mdminit     : ARRAY[1..47] OF BYTE;
    mdmcmd      : ARRAY[1..25] OF BYTE;
    mdmsuf      : ARRAY[1..25] OF BYTE;
    hu_str      : ARRAY[1..25] OF BYTE;
    ans_str     : ARRAY[1..25] OF BYTE;
    no_ans_str  : ARRAY[1..25] OF BYTE;
    mdm_msg     : ARRAY[1..11] OF ARRAY[1..16] OF BYTE;
    baseaddr    : ARRAY[1..8] OF INTEGER;
    irqnumbr    : ARRAY[1..8] OF INTEGER;
    termtype    : INTEGER;
    echo_flag   : INTEGER;
  END; { There's more to this structure, but I don't use it all }
  {$ENDIF}

VAR

  mptr     : ARRAY[1..MaxExc+1] OF INTEGER;
  bfile    : TEXT;
  first,
  curPtr   : LinePtr;
  fpath    : PathStr;
  local    : ARRAY [1..3] OF Strip;
  lastDigit: INTEGER;

  {$IFDEF PCPLUS}
  pcpfile  : FILE;
  nptxt    : ddrecPtr;
  theDir   : dirFile;
  theParms : parmFile;
  {$ENDIF}

PROCEDURE Help1;
BEGIN;
  WRITELN('Invoke with no options for interactive use');
  WRITELN;
  WRITELN('BLOKE P???');
  WRITELN('- Prefix, where ??? = first 3 digits of your phone number');
  WRITELN;
  WRITELN('BLOKE V??');
  WRITELN('- Version, where ?? = version number in filename 313BBS??.LST');
  WRITELN('- If you rename 313BBS??.LST to 313BBS.LST, it loads without');
  WRITELN('  using the V option.  Use V00 to skip reading the BBS list.');
  WRITELN;
  WRITELN('BLOKE A');
  WRITELN('- Omit area codes from text output and dialing directories');
  WRITELN;
  WRITELN('BLOKE Q');
  WRITELN('- Quit after listing information for just one area');
  WRITELN;
  WRITELN('BLOKE M or F');
  WRITELN('- Midrange or Far areas listed instead of local');
  WRITELN;
  WRITELN('BLOKE R');
  WRITELN('- Read-only, listings to screen instead of disk');
  WRITELN('- Use Control-S to pause; Control-Q to continue; Control-C to abort');
  WRITELN('- Use Control-P to echo screen output to printer');
  WRITELN('- If you > redirect or | pipe output, be sure to also use the P, V,');
  WRITELN('  and Q options, since you won''t get any on-screen prompts!');
  HALT(0);
END;

PROCEDURE Help2;
BEGIN;
  WRITELN('At the prompt, you may enter:');
  WRITELN;
  WRITELN(' - The first 3 digits of your phone number');
  WRITELN(' - A 3-digit code for the area you would like to list');
  WRITELN(' - 0 (zero) to list all available area names and codes');
  WRITELN(' - LOC to select listing of local numbers');
  WRITELN(' - MID to select listing of midrange numbers');
  WRITELN(' - FAR to select listing of far-off numbers');
  WRITELN(' - END to exit');
END;

PROCEDURE ReadBFile;
BEGIN
  fpath := '313BBS.LST';
  INSERT(s2,fpath,7);
  fpath := FSEARCH(fpath, GETENV('PATH'));
  IF fpath <> '' THEN BEGIN
    fexist := TRUE;
    ASSIGN(bfile, fpath);
    RESET(bfile);
    NEW(first);
    curPtr := first;
    WHILE (NOT eof(bfile)) AND (MemAvail > 1024) DO BEGIN
      READLN(bfile, curPtr^.txt);
      curPtr^.loc := 0;
      VAL(COPY(curPtr^.txt,30,4),j,i);
      IF (i = 0) THEN BEGIN
        VAL(COPY(curPtr^.txt,26,3),j,i);
        IF (i = 0) AND (j > 199) AND (curPtr^.txt[29] = '-') THEN BEGIN
          curPtr^.loc := nnx[j];
          IF curPtr^.loc = 0 THEN BEGIN
            WRITELN;
            WRITELN('WARNING: Listing with unknown prefix!');
            WRITELN(curPtr^.txt);
            WRITELN;
          END ELSE IF (acodes) THEN BEGIN {insert area codes}
            IF (curPtr^.loc < 0) THEN BEGIN
              INSERT('1-313-', curPtr^.txt, 26);
            END ELSE BEGIN
              INSERT('1-810-', curPtr^.txt, 26);
            END;
            lastDigit := 39;
          END ELSE BEGIN
            lastDigit := 33;
          END;
        END;
      END;
      NEW(curPtr^.nxt);
      curPtr := curPtr^.nxt;
    END;
    curPtr^.nxt := NIL;
    CLOSE(bfile);
  END;
END;

{ Main program }

BEGIN

  WriteLn(CreditString); { Print my message }

  { Initialize mptr array }

  mptr[1] := 1;
  j := 1;
  i := 0;
  REPEAT
    i := i + 1;
    IF eas[i] = 0 THEN BEGIN
      j := j + 1;
      mptr[j] := i + 1;
    END;
  UNTIL j = MaxExc+1;

  { Get command line }

  FOR i := 1 TO PARAMCOUNT DO BEGIN
    s4 := PARAMSTR(i);
    j  := LENGTH(s4);
    CASE UPCASE(s4[1]) OF
      'A' : BEGIN
              acodes := FALSE;
            END;
      'M' : BEGIN
              mode := 2;
            END;
      'F' : BEGIN
              mode := 3;
            END;
      'P' : s3 := COPY(s4,2,j);
      'V' : s2 := COPY(s4,2,j);
      'R' : ofile := '';
      'Q' : quit := TRUE;
    ELSE
      Help1; { Print usage instructions }
    END;
  END;

  { Load mods }

  fpath := FSEARCH('BLOKE.MOD', GETENV('PATH'));
  IF fpath <> '' THEN BEGIN
    ASSIGN(bfile,fpath);
    RESET(bfile);
    REPEAT
      {$I+} { for input type checking only }
      READLN(bfile, i, j);
      {$I-}
      IF (j <= maxexc) AND (i < 1000) AND (i>199) THEN nnx[i] := j;
    UNTIL EOF(bfile);
    CLOSE (bfile);
  END;

  { Get BBS list file }

  IF s2 <> '00' THEN BEGIN
    ReadBFile;
    IF NOT fexist THEN BEGIN
      WRITE('What version of 313BBS??.LST do you have? ');
      READLN (s2);
      ReadBFile;
      IF NOT fexist THEN BEGIN
        WRITELN('313BBS',s2,'.LST not found, can''t list BBS numbers');
      END;
    END;
  END;

  { Get a telephone prefix }

  REPEAT

    WHILE (k = 0) DO BEGIN
      WRITELN;
      IF s3 = '' THEN BEGIN
        WRITE (modstr[mode]:3,
        '> Enter first 3 digits of your phone number (or ? for help): ');
        READLN (s3);
      END;
      FOR i := 1 TO 3 DO s3[i] := UPCASE(s3[i]);
      IF s3 = modstr[1] THEN BEGIN
        mode := 1;
      END ELSE IF s3 = modstr[2] THEN BEGIN
        mode := 2;
      END ELSE IF s3 = modstr[3] THEN BEGIN
        mode := 3;
      END ELSE IF s3 = 'END' THEN BEGIN
        HALT(0);
      END ELSE BEGIN
        VAL(s3,j,i);
        IF (i <> 0) THEN BEGIN
          Help2;
        END ELSE BEGIN
          IF (j>0) AND (j<=maxexc) THEN k := j
          ELSE IF (j>199) THEN k := ABS(nnx[j]);;
          IF (k = NotInUse) THEN BEGIN
            WRITELN(s3:3, ' is not a known prefix in any of these areas:');
            i := 0;
            j := 1;
            REPEAT
              INC(i);
              WRITE(i:3, '. ':2,   ntext[i]);
              IF j = 5 THEN BEGIN
                WRITELN;
                j := 1;
              END ELSE BEGIN
                WRITE(' ':11-Length(ntext[i]));
                INC(j);
              END;
            UNTIL i = maxexc;
          END;
        END;
      END;
      if k = 0 THEN s3 := '';
    END;

    { Setup output files }

    IF ofile <> '' THEN BEGIN

      { Zero-pad leading blanks }

      FOR i := 1 TO 3-LENGTH(s3) DO
      IF s3[1] = ' ' THEN s3[1] := '0' ELSE INSERT('0',s3,1);

      { Set up the text output name }

      IF ofile <> '' THEN BEGIN

        ofile := CONCAT('.', modstr[mode]);
        INSERT(ntext[k], ofile, 1);
        WRITE('Writing ',   ofile, ': ');

        {$I+} { start i/o checking now, I want to abort on errors }

        ASSIGN(OUTPUT, ofile);
        REWRITE(OUTPUT);

        {$IFDEF PCPLUS}
        { Check for PCPLUS files }

        fpath := FSEARCH('PCPLUS.DIR', GetEnv('PCPLUS'));
        IF (fpath = '') THEN fpath := FSEARCH('PCPLUS.DIR', GetEnv('PATH'));
        IF (fpath <> '') THEN BEGIN
          ASSIGN(pcpfile, fpath);
          RESET(pcpfile, 1);
          i := FILESIZE(pcpfile);
          CLOSE(pcpfile);
          IF (i = SIZEOF(theDir)) THEN BEGIN
            fpath[0] := CHAR(LENGTH(fpath)-3);
            fpath := CONCAT(fpath, 'PRM');
            ASSIGN(pcpfile, fpath);
            RESET(pcpfile, 1);
            BLOCKREAD(pcpfile, theParms, SIZEOF(theParms), i);
            CLOSE(pcpfile);
            IF (i = SIZEOF(theParms)) THEN BEGIN
              FILLCHAR(theDir, SIZEOF(theDir), 0);
              WITH theDir.entry[1] DO BEGIN
                WITH theParms DO BEGIN
                  ddbaud := baud;
                  ddpar  := parity;
                  dddata := dbits;
                  ddstop := sbits;
                  ddport := 0;
                  dddup  := echo_flag;
                  ddterm := termtype;
                END;
              END;
              FOR j := 2 TO 200 DO theDir.entry[j] := theDir.entry[1];
              pcplus := TRUE;
            END;
          END;
        END;
        {$ENDIF}
      END;
    END;

    { Find local and midrange areas }

    FILLCHAR(local, SIZEOF(local), 0);
    local[modeLoc,k] := TRUE;
    FOR i := mptr[k] TO mptr[k+1]-2 DO BEGIN
      j := eas[i];
      local[modeLoc,j] := TRUE;
      for ii := mptr[j] TO mptr[j+1]-2 DO local[modeMid,eas[ii]] := TRUE;
    END;

    { Exclude local from midrange areas }

    FOR j := 1 TO maxexc DO
      IF local[modeLoc,j] THEN local[modeMid,j] := FALSE;

    { Find distant areas and decide who to list }

    IF mode = modeFar THEN
      FOR j := 1 TO maxexc
        DO local[modeFar,j] := NOT (local[modeLoc,j] OR local[modeMid,j]);

    local[modeLoc,0] := FALSE; { Make sure I didn't touch these }
    local[modeMid,0] := FALSE;
    local[modeFar,0] := FALSE;

    { List whatever names I'm using }

    s2 := '  ';
    WRITELN;
    FOR j := 1 TO maxexc DO BEGIN
      IF local[mode,j] THEN BEGIN
        IF j = k THEN s2[2] := '*' ELSE s2[2] := ' ';
        WRITELN(j:5,s2:2,ntext[j]);
      END;
    END;

    { Dump local exchanges }

    WRITELN;
    i := 0;
    FOR j := 200 TO 999 DO BEGIN
      IF local[mode,ABS(nnx[j])] THEN BEGIN
        IF ABS(nnx[j]) = k THEN s2[2] := '*' ELSE s2[2] := ' ';
        WRITE(s2:2, j:3);
        IF (nnx[j] < 0) THEN WRITE('s') ELSE WRITE('n');
        IF i = 11 THEN BEGIN
          WRITELN;
          i := 0;
        END ELSE BEGIN
          INC(i);
        END;
      END;
    END;
    WRITELN;

    { Dump BBS numbers }

    i := 0;
    IF fexist THEN BEGIN
      WRITELN;
      curPtr := first;
      WHILE (curPtr^.nxt <> NIL) DO BEGIN
        IF local[mode,ABS(curPtr^.loc)] THEN BEGIN
          INC(i);
          WRITELN(curPtr^.txt);
          {$IFDEF PCPLUS}
          IF pcplus AND (i<=200) THEN BEGIN
            nptxt := @curptr^.txt[1];
            WITH theDir.entry[i] DO BEGIN
              ddnp := nptxt^.ddnp;
              FOR j := lastDigit DOWNTO 26 DO BEGIN
                ddnp[j+1] := ddnp[j];
              END;
              ddnp[25] := 0;  { end of ddname  }
              ddnp[26] := 65; { start all ddphones with 'A' }
              ddnp[lastDigit+2] := 0;  { end of ddphone }
            END;
          END;
          {$ENDIF}
        END;
        curPtr := curPtr^.nxt;
      END;
      WRITELN;

    END;

    { Flush output, reset stdout, and announce results }

    CLOSE(OUTPUT);
    ASSIGN(OUTPUT,'');
    REWRITE(OUTPUT);
    IF fexist THEN WRITELN(i:3, 'listing(s) found for ':22, ntext[k]);

    {$IFDEF PCPLUS}
    { Write a PCPLUS directory if needed }

    IF (pcplus) AND (i > 0) THEN BEGIN
      FOR i := 1 TO LENGTH(fpath) DO fpath[i] := UPCASE(fpath[i]);
      fpath[0] := CHAR(LENGTH(fpath)-10);
      fpath := CONCAT(fpath, 'BBS-', s3, modstr[mode][1], '.DIR');
      WRITELN('Also written to ',   fpath);
      ASSIGN(pcpfile, fpath);
      REWRITE(pcpfile, SIZEOF(theDir));
      BLOCKWRITE(pcpfile, theDir, 1);
      CLOSE(pcpfile);
    END;
    {$ENDIF}

    { Set things up in case I need to repeat }

    k := 0;
    s3 := '';

  UNTIL quit;

END.
