#!/usr/bin/msub

# A script for converting <Tab>s in a text file to spaces.
# Assumes tab stops every 8 columns.
#
# Should be fast enough: One iteration per tab column in file.
# Plus it uses fully deterministic regexps.

# Sharps are used for tab stop marking, so first they must be removed
# Note: The exact length of the replace text must be 8*n+1 for some n
"#"
"<Sharp!!>"

!newpass

# Introduce sharps at tab stops, starting at left margin
^
^"#"


              # Implicit !newpass with !begin
!begin
!iterate=30
            # Works the tab stop marker rightwards, 8
            # columns at a time, changing tabs to spaces
            # in those eight columns (if there are any
	    # tabs in a column, the the tab will be the
	    # last char, as tab advances to the next column).

	    # First, columns with tabs:

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$][^\9$][^\9$]`\9
`" #"

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$][^\9$]`\9
`"  #"

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$]`\9
`"   #"

"#"`[^\9$][^\9$][^\9$][^\9$]`\9
`"    #"

"#"`[^\9$][^\9$][^\9$]`\9
`"     #"

"#"`[^\9$][^\9$]`\9
`"      #"

"#"`[^\9$]`\9
`"       #"

"#"\9
"        #"

		# Next, columns without tabs.
		# If there are 8 chars or more left, then
		# go on to the next column.


"#"`[^\9$][^\9$][^\9$][^\9$][^\9$][^\9$][^\9$][^\9$]`
`"#"

!end

                # Fewer than 8 chars:
		# Done with this line, remove the sharp.

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$][^\9$][^\9$]$`
`

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$][^\9$]$`
`

"#"`[^\9$][^\9$][^\9$][^\9$][^\9$]$`
`

"#"`[^\9$][^\9$][^\9$][^\9$]$`
`

"#"`[^\9$][^\9$][^\9$]$`
`

"#"`[^\9$][^\9$]$`
`

"#"`[^\9$]$`
`

"#"`$`
`

# Finally, bring back the removed sharps:
!newpass
"<Sharp!!>"
"#"
