#!/usr/bin/msub

# Consider this script:

	# This search-replace pair removes duplicate spaces.
/" "" "+/[^ ]
" "

	# This pair removes space before a comma.
" ,"
","

# Unfortunately it doesn't work with the text "  , after the comma":
# The first two spaces will match the first search expression,
# but then MSUB will continue searching for a match for
# ", after the comma".

# To fix this you just run the script twice; you could do that manually,
# by invoking MSUB twice, but you don't need to; just go

!iterate

# This will re-apply the changes in this script repeatedly until
# there is nothing more to change.
# You could limit the repetitions by giving a numeric argument:
#    !iterate=2


# Actually you don't need to iterate this script for it to work:
# A
#	!newpass
# directive between the two search-replace pairs would serialize
# them such that all duplicate space removal would be finished before
# beginning to remove before-comma space.
