/*
ͻ
 What's it called: EPMGCC  V1.00                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains the menu definition. The commands       
                   and procedures are defined in a separate file and linked   
                   in an additional modul because of the size limitation      
                   of emx.ex (64K).                                           
                                                                              
 Who and When:     B. Bablok 12/93 - 01/94                                    
                                                                              
ͼ

Ŀ
  Defining default constants if not defined in GCCENV.E                       

*/
TRYINCLUDE 'gccenv.e'

COMPILE IF not defined(GCC_MENU_ALWAYS_ON)
   CONST   GCC_MENU_ALWAYS_ON = 0              --  default is to grey out GCC-
COMPILE ENDIF                                  --  menu for non c/cc files

COMPILE IF not defined(GCC_D_COMPILE_OPTIONS)
   CONST   GCC_D_COMPILE_OPTIONS = '-c -g %*'  --  default: compile and create
COMPILE ENDIF                                  --  debug information

COMPILE IF not defined(GCC_P_COMPILE_OPTIONS)
   CONST GCC_P_COMPILE_OPTIONS = '-O2 -o %**P%**N.exe %*' --  default: compile
COMPILE ENDIF                                             --  with optimization
                                                          --  and link

COMPILE IF not defined(GCC_D_BUILD_OPTIONS)
   CONST   GCC_D_BUILD_OPTIONS = '-k -f %* MODE=D' -- default debug build option
COMPILE ENDIF

COMPILE IF not defined(GCC_P_BUILD_OPTIONS)
   CONST   GCC_P_BUILD_OPTIONS = '-k -f %* MODE=P' -- default production build
COMPILE ENDIF                                      -- options

COMPILE IF not defined(GCC_AUTOSAVE_FILE)
   CONST   GCC_AUTOSAVE_FILE = 1               --  default is to turn on smart
COMPILE ENDIF                                  --  save before compile

COMPILE IF not defined(GCC_DEBUG_MODE)
   CONST   GCC_DEBUG_MODE = 1                  -- default is to turn on debug -
COMPILE ENDIF                                  -- mode

COMPILE IF not defined(GCC_VERBOSE_MODE)
   CONST   GCC_VERBOSE_MODE = 0                -- default is to turn off verbose
COMPILE ENDIF                                  -- mode
/*
Ŀ
   English language support for GCC menu help                                  

*/
CONST
  GCC_MENU__MSG      = \1'Menus related to GCC support'
  GCC_OPEN__MSG      = \1'Open (define) the current project'
  GCC_EDIT__MSG      = \1'Edit the current project'
  GCC_CLOSE__MSG     = \1'Close the current project'
  GCC_COMP_OPT__MSG  = \1'Set compile options'
  GCC_COMP__MSG      = \1'Compile the current file'
  GCC_BUILD_OPT__MSG = \1'Set build options'
  GCC_BUILD__MSG     = \1'Build the current project'
  GCC_VIEW__MSG      = \1'View compile results'
  GCC_RUN__MSG       = \1'Run EXE - file'
  GCC_DEBUG__MSG     = \1'Debug EXE - file'
  GCC_DEBUGMODE__MSG = \1'Toggle debug-mode'
  GCC_AUTOSAVE__MSG  = \1'Toggle autosave mode'
  GCC_VERBOSE__MSG   = \1'Verbose mode for troubleshooting GCC commands.'
/*
Ŀ
  Define EPMGCC variables and post menu build                                 

*/
DEFINIT
    UNIVERSAL gcc_project,            -- project name
              gcc_project_file,       -- make file name
              gcc_d_comp_options,     -- compile options (debug)
              gcc_p_comp_options,     -- compile options (production)
              gcc_d_make_options,     -- make    options (debug)
              gcc_p_make_options,     -- make    options (production)
              gcc_error_file,         -- latest error-file
              gcc_error_file_id,      -- ID of latest error-file
              gcc_debug,              -- debug mode
              gcc_autosave,           -- auto-save mode
              gcc_verbose,            -- verbose mode
              gcc_runtime_arguments   -- runtime arguments

    gcc_project           = ''
    gcc_project_file      = ''
    gcc_d_comp_options    = GCC_D_COMPILE_OPTIONS
    gcc_p_comp_options    = GCC_P_COMPILE_OPTIONS
    gcc_d_make_options    = GCC_D_BUILD_OPTIONS
    gcc_p_make_options    = GCC_P_BUILD_OPTIONS
    gcc_error_file        = ''
    gcc_error_file_id     = ''
    gcc_debug             = GCC_DEBUG_MODE
    gcc_autosave          = GCC_AUTOSAVE_FILE
    gcc_verbose           = GCC_VERBOSE_MODE
    gcc_runtime_arguments = ''

    'PostMe LINK gccproc'    -- else the epm.ex file would be > 64k
    'PostMe BuildGCCMenu'    -- delay creating menu until after the definit
/*
Ŀ
  GCC menu registering                                                        

*/
DEFSELECT
   'PostMe GCCMenuEnable'

DEFLOAD
   'PostMe GCCMenuEnable'
/*
Ŀ
  Define GCC menu system                                                       

*/
DEFC BuildGCCMenu =
    UNIVERSAL defaultmenu

    BUILDSUBMENU defaultmenu, 33, '~GCC', GCC_MENU__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3301, '~Open Project',
                               'open_project'GCC_OPEN__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3302, '~Edit Project',
                               'edit_project'GCC_EDIT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3303, 'C~lose Project',
                               'close_project'GCC_CLOSE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3304, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 33, 3305, 'Set com~pile options  c-F11',
                               'set_comp_options'GCC_COMP_OPT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3306, '~Compile current file  c-F12',
                               'compile_file'GCC_COMP__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3307, 'Set b~uild options     s-F11',
                               'set_make_options'GCC_BUILD_OPT__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3308, '~Build current project s-F12',
                               'build_project'GCC_BUILD__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3309, '~View results',
                               'view_results'GCC_VIEW__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3310, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 33, 3311, '~Run Exe',
                               'run_exe'GCC_RUN__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3312, '~Debug Exe',
                               'debug_exe'GCC_DEBUG__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3313, \0, '', 4, 0
    BUILDMENUITEM defaultmenu, 33, 3314, 'Debug ~Mode',
                               'toggle_debug_mode'GCC_DEBUGMODE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3315, 'Auto ~Save',
                               'toggle_autosave_mode'GCC_AUTOSAVE__MSG, 0,0
    BUILDMENUITEM defaultmenu, 33, 3316, 'Verbose (~test) Mode',
                               'toggle_verbose_mode'GCC_VERBOSE__MSG, 0,0

    SHOWMENU defaultmenu
    'PostMe  GCCMenuEnable'

-- enable the GCC menu only if a c/cc/h-, error- or make-file is loaded -
-- or if GCC_MENU_ALWAYS_ON is set

DEFC GCCMenuEnable =
 COMPILE IF GCC_MENU_ALWAYS_ON = 1
    gcc_enabled = 1
 COMPILE ELSE
    ext = FILETYPE()
    gcc_enabled = WORDPOS(ext,'C CC CPP CXX H ERR EMX GCC MAK') > 0
 COMPILE ENDIF
 SetMenuAttribute(33, 16384, gcc_enabled)
 RETURN
