/* Ray Tracing Procedure with Graphical */
/* user interface  for use with OS/2 version */
/* of POVRAY 1.0 or 2.0 */
/* Written by:  Greg Spath */
/* last revision 11/22/93 */

'@echo off'
call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP

/*--------------------------------------------------- */
/* Set these up to match your system */
/*----------------------------------------------------*/

init = "c:\proc\render.ini"             /* file that contains the last in/out file names */
program="d:\render\povray"   /* directory and name of ray-tracer */
datadrive="d:"                              /* default drive for  data file */
datadir="\data\raytrace"           /* default directory for data file */

START:
call VDialogPos 50, 50
parse arg infile outfile
afile = linein(init,1,1)

if infile = '' then infile = afile
if outfile = '' then outfile = linein(init)
datadrive
cd datadir

prompt.0 = 2   /* 2 prompt lines */
prompt.1 ='Input File Name'
prompt.2 = 'Output File Name'

width.0 = 2
width.1 = 30  
width.2 = 30   

hide.0 = 2
hide.1 = 0     
hide.2 = 0     

fname.0 = 2
fname.1 = infile  
fname.2 = outfile  

button = VMultBox('Choose file to Render', prompt, width, hide, fname, 3)

if button = 'OK' then do
        infile = fname.1
        outfile = fname.2
        call FIXNAME
        call lineout init, infile, 1
        call lineout init, outfile
        call lineout init
        call RESOLUTION
else 
        exit

RESOLUTION:
        res.0 = 6
        res.1 = '80 x 60'       
        res.2 = '320 x 200'     
        res.3 = '640 x 480'     
        res.4 = '800 x 600'     
        res.5 = '1024 x 768'    
        res.6 = 'custom'

        call VRadioBox 'Select a Resolution', res, 1
        if res.vstring = '80 x 60' then do
                width = 80
                height = 60
        end
        if res.vstring = '320 x 200' then do
                width = 320
                height = 200
        end 
        if res.vstring = '640 x 480' then do
                width = 640
                height = 480
        end  /* Do */
        if res.vstring = '800 x 600' then do
                width = 800
                height = 600
        end  /* Do */
        if res.vstring = '1024 x 768' then do
                width = 1024
                height = 768
        end  /* Do */
        if res.vstring = 'custom' then call CUSTRES
                   
VERSION:
        ver.0 = 2
        ver.1 = '1.0'
        ver.2 = '2.0'
        call VRadioBox 'Which Version of POV?', ver, 1
        version = ver.vstring
DO_IT:
       program' +i'infile' +o'outfile' +w'width' +h'height' +ld:\render\include +x +v +P +B128 +FT +MV'version

CLEANUP:
        call VExit
        exit

CUSTRES:
prompt.0 = 2   /* 2 prompt lines */
prompt.1 = 'Horizontal Resoultion'
prompt.2 = 'Vertical Resolution'

width.0 = 2
width.1 = 5   /* widths in character units */
width.2 = 5    /* for both entryfields */

hide.0 = 2
hide.1 = 0     /* echo the User ID input */
hide.2 = 0     /* don't echo the Password */

resol.0 = 2
resol.1 = 32  /* these are the default strings */
resol.2 = 32  /* which will contain the input */

button = VMultBox('Choose file to Render', prompt, width, hide, resol, 3)

if button = 'OK' then do
        width = resol.1
        height = resol.2
        return
else
        call RESOLUTION


FIXNAME:
   if \ (substr(infile, length(infile) -3, 1) = '.') then
      infile = infile'.pov'
   if \ (substr(outfile, length(outfile) - 3, 1) = '.')  then
      outfile = outfile'.tga'
   return
