; Demonstration of the use of _rmpmirqset.
; Under DMPI control is not given up with INT33. So the protected mode IRQ
;  should still be there, unless the DPMI host is buggy.

        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc

public  _main

;
; DATA
;
msg0    db      'We are now waiting for a keypress in protected mode. Notice the protected',0dh,0ah
        db      ' mode timer IRQ handler going off (upper right corner of the screen).',0dh,0ah,0dh,0ah,'$'
msg1    db      'Now we are waiting in real mode (not under the control of PMODE). The',0dh,0ah
        db      ' protected mode IRQ handler is gone (unless this is a DPMI system).',0dh,0ah,0dh,0ah,'$'
msg2    db      'We are still in real mode, but a callback has been created using _rmpmirqset',0dh,0ah
        db      ' so the PMODE IRQ handler the IRQ even when PMODE doesn''t have control.',0dh,0ah,0dh,0ah,'$'

buf     db      21 dup(?)

;
; CODE
;

include pdosmsg.rt

;
irq0:                                   ; Protected mode timer IRQ handler
        push eax ds

        mov ds,cs:_seldata
        @rlp eax,0b8000h+158            ; Toggle a box on the screen
        xor byte ptr [eax],0fbh

        pop ds
        mov al,20h
        out 20h,al
        pop eax
        sti
        iretd

;
_main:                                  ; Program starts here
        sti

        mov v86r_ax,3                   ; Clear the screen
        mov al,10h
        int 33h

        mov edx,offset irq0             ; Set timer vector to our own
        xor bl,bl
        call _setirqvect

        mov edx,offset msg0             ; Put first message and wait for key
        call _putdosmsg
        call _pmwaitforkey

        mov edx,offset msg1             ; Put next message and wait for key
        call _putdosmsg
        call _rmwaitforkey

        mov edi,offset buf              ; Create real mode callback
        xor bl,bl
        call _rmpmirqset
        push edx

        mov edx,offset msg2             ; Next message and wait for key
        call _putdosmsg
        call _rmwaitforkey

        pop edx                         ; Restore real mode IRQ vector
        call _rmpmirqfree               ; 'mov gs:[4*8],edx' would do as well

        jmp _exit

;-----------------------------------------------------------------------------
_pmwaitforkey:                          ; Wait for keypress in protected mode
        mov ax,gs:[41ah]
        cmp ax,gs:[41ch]
        je _pmwaitforkey
        mov gs:[41ch],ax
        ret

;-----------------------------------------------------------------------------
_rmwaitforkey:                          ; Wait for keypress in real mode
        mov v86r_ah,0
        mov al,16h
        int 33h                 ; notice its 33h (gives up PMODE control).
        ret

code32  ends
        end

