/* Rexx */

/* This

/* Register Rexx external functions */
If RxFuncQuery('RXACSMGT') Then
  Call RxFuncAdd 'RXACSMGT','YDBAACSM','YDBAACSM'
If RxFuncQuery('rxappc') Then
  Call RxFuncAdd 'rxappc','rxappcfd','rxappcfd'
If RxFuncQuery('SYSSLEEP') Then
  Do
  Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  Call SysLoadFuncs
  End
If RxFuncQuery('RxCreateRexxThread') Then
  Do
  Call RxFuncAdd 'RxYdbaUtilInit','YDBAUTIL','RxYdbaUtilInit'
  Call RxYdbaUtilInit
  End

Call RxAcsMgt 'display_sna_global_info','sg.'
loclu=sg.4;Drop sg.

/* Prompt user */
Say;Say 'Enter LU-Alias of remote workstation:'
Say '(Type * to end)'
Parse Upper LineIn partlu
If partlu = '*' Then
  Exit
pq = partlu
If Pos('.',pq) > 0 Then
  Parse Var pq . '.' pq

/* Set security info */
Say;Say 'Enter userid, followed by password:'
Parse Upper LineIn uidpw
uidpw = Space(Translate(uidpw,' ',','))

If uidpw = '*' Then
  si = 'None'
Else
  Do
  If Words(uidpw) <> 2 Then
    Do
    Say 'You must supply both a userid and a password.'
    Exit
    End
  Parse Var uidpw uid pw .
  si = 'Pgm' uid pw
  End

call syscls

appcrc = rxappc('Tp_Started', loclu, 'RC1', 'tpid')
If appcrc <> 0 Then
  Do;Say;Say 'Tp_Started failed with rc =' appcrc
  Exit
  End
Signal On Syntax Name Trap_Allocate_Syntax
convtype = 'mfn'       /* mapped, full-duplex, non-blocking */
synclvl = 'n'
retctl = 'a'
convstyle = 's'
mode = '#INTER'
ptp = 'RC3'
appcrc = rxAppc('Allocate',convtype,tpid,synclvl,retctl,convstyle,
               ,partlu,mode,ptp,si,'inf.')
Signal Off Syntax
If appcrc <> 0 Then
  Do;Say;Say 'Mc_Allocate failed with rc =' appcrc
  Call rxAppc 'Tp_Ended', tpid, 's'
  Exit
  End
convid = inf.1
appcrc = rxappc('Send_Data',convtype,tpid,convid,'n',Cryption(uid pw),'inf.')
If appcrc <> 0 Then
  Do;Say;Say 'Send_Data (uid/pw) failed with rc =' appcrc
  Call rxAppc 'Tp_Ended', tpid,'s'
  Exit
  End

appcrc = rxappc('Flush',convtype,tpid,convid,)
If appcrc <> 0 Then
  Do;Say;Say 'Flush (uid/pw) failed with rc =' appcrc
  Call rxappc 'Tp_Ended', tpid,'s'
  Exit
  End

If rxpmprintf(pq,' ') = 0 Then
  Do
  Call rxstartsession 'pmprintf.exe','queue' pq,'Child'
  call syssleep 3
  End

call rxcreaterexxthread 'rc2', pq, tpid, convid

Do Forever
  call syscls
  Say Center('Issuing Commands at Remote Workstation "'partlu'"',50)
  Say;Say 'Enter string to be interpreted by Rexx on remote workstation:'
  Say '(Type * to terminate)'
  Parse LineIn cmdstr
  If cmdstr = '*' Then
    Leave
  If cmdstr = '' Then
    cmdstr = ' '
  Call Process_CmdStr
End

Call rxappc 'Deallocate', convtype, tpid, convid, 's','inf.'
Call rxappc 'Tp_Ended', tpid,'s'

Exit

/* ======================================================================= */
/* Process Command String                                                  */
/* ======================================================================= */
Process_CmdStr:

appcrc = rxappc('Send_Data',convtype,tpid,convid,'n',Cryption(cmdstr),'inf.')
If appcrc <> 0 Then
  Do;Say;Say 'Send_Data failed with appcrc =' appcrc
  Call rxappc 'Tp_Ended', tpid,'s'
  Exit
  End

appcrc = rxappc('Flush',convtype,tpid,convid,)
If appcrc <> 0 Then
  Do;Say;Say 'Flush failed with appcrc =' appcrc
  Call rxappc 'Tp_Ended', tpid,'s'
  Exit
  End

Return

Trap_Allocate_Syntax:
Say 'Partner LU name' partlu 'is invalid.'
Say 'It must be either an lu-alias (1-8 chars), or a fully qualified name'
Say '(1-8 char network name, a period, and a 1-8 char lu-name).'
Address 'CMD' '@PAUSE'
Exit

Cryption:
Return BitXor(Arg(1),Copies('ff'x,Length(Arg(1))))
