/* emxdll.h -- Global header file for emx.dll
   Copyright (c) 1992-1994 by Eberhard Mattes

This file is part of emx.

emx is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

emx is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emx; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

As special exception, emx.dll can be distributed without source code
unless it has been changed.  If you modify emx.dll, this exception
no longer applies and you must remove this paragraph from all source
files for emx.dll.  */


#define STR(X)  #X
#define XSTR(X) STR(X)

#define ENTRY_POINT     0x10000
#define U_OFFSET        0x0400
#define KERNEL_U_ADDR   0x0e0000000

/* Bits in `handle_flags[]' and `files[].flags' */

#define HF_FILE         0x0001
#define HF_DEV          0x0002
#define HF_UPIPE        0x0004
#define HF_NPIPE        0x0008
#define HF_CON          0x0010
#define HF_NUL          0x0040
#define HF_CLK          0x0080
#define HF_ASYNC        0x0100
#define HF_SOCKET       0x0200
#define HF_OPEN         0x1000
#define HF_APPEND       0x2000
#define HF_NDELAY       0x4000

#define L_FLAG_DLL              0x0001
#define L_FLAG_LINK386          0x0002

#define FORK_REQ_DONE           0
#define FORK_REQ_INIT           1
#define FORK_REQ_MEM            2

#define FORK_OBJ_SIZE           0x20000 /* 128KB */

#define DEBUG_STDERR    1
#define DEBUG_STACK     2
#define DEBUG_SETMEM    4
#define DEBUG_SYSCALL   8
#define DEBUG_TERMIO    16

#define NSIG 22

#define FLAG_C          0x0001
#define FLAG_Z          0x0040

typedef void (sigfun)(int signo);

struct _find;
struct timeb;
struct timeval;
struct stat;
struct _select;
struct _new_proc;

struct signal_entry
{
  sigfun *handler;              /* Signal handler, SIG_DFL, or SIG_IGN */
  ULONG sa_mask;                /* Signals to be blocked */
  ULONG sa_flags;               /* Flags */
};

typedef struct
{
  ULONG text_base;
  ULONG text_end;
  ULONG data_base;
  ULONG data_end;
  ULONG bss_base;
  ULONG bss_end;
  ULONG heap_base;
  ULONG heap_end;
  ULONG heap_brk;
  ULONG heap_off;
  ULONG os2_dll;
  ULONG stack_base;
  ULONG stack_end;
  ULONG flags;
  ULONG reserved[2];
  char options[64];
} layout_table;

typedef struct
{
  ULONG last_sys_errno;         /* Error code for last syscall */
  ULONG prev_sys_errno;         /* Previous value of the above */
  ULONG find_handle;
  ULONG find_count;
  ULONG sig_blocked;            /* Blocked signals */
  ULONG sig_pending;            /* Pending signals */
  ULONG sig_prev_blocked;       /* Previous signal mask */
  FILEFINDBUF3 find_buf;
  struct signal_entry sig_table[NSIG];
} thread_data;

typedef union
{
  struct
    {
      ULONG edi;
      ULONG esi;
      ULONG ebp;
      ULONG esp;
      ULONG ebx;
      ULONG edx;
      ULONG ecx;
      ULONG eax;
      ULONG eflags;
      ULONG eip;
    } e;
  struct
    {
      USHORT di;
      USHORT edi_hi;
      USHORT si;
      USHORT esi_hi;
      USHORT bp;
      USHORT ebp_hi;
      USHORT sp;
      USHORT esp_hi;
      USHORT bx;
      USHORT ebx_hi;
      USHORT dx;
      USHORT edx_hi;
      USHORT cx;
      USHORT ecx_hi;
      USHORT ax;
      USHORT eax_hi;
      USHORT flags;
      USHORT eflags_hi;
      USHORT ip;
      USHORT eip_hi;
    } x;
  struct
    {
      ULONG edi;
      ULONG esi;
      ULONG ebp;
      ULONG esp;
      UCHAR bl;
      UCHAR bh;
      USHORT ebx_hi;
      UCHAR dl;
      UCHAR dh;
      USHORT edx_hi;
      UCHAR cl;
      UCHAR ch;
      USHORT ecx_hi;
      UCHAR al;
      UCHAR ah;
      USHORT eax_hi;
      ULONG eflags;
      ULONG eip;
    } b;
} syscall_frame;

struct fork_data_mem
{
  ULONG req_code;
  ULONG address;
  ULONG count;
  void *shared;
  char buf[1];
};

struct fork_data_init
{
  ULONG req_code;               /* Request code */
  ULONG msize;                  /* Size of shared memory object */
  ULONG brk;
  ULONG stack_base;
  ULONG stack_page;
  ULONG reg_ebp;
  struct signal_entry sig_actions[NSIG];
  ULONG umask;
  ULONG umask1;
  ULONG uflags;                 /* User flags */
  HEV req_sem;
  HEV ack_sem;
};

typedef union
{
  ULONG req_code;
  struct fork_data_mem mem;
  struct fork_data_init init;
} fork_data;


struct my_datetime
{
  ULONG seconds;
  ULONG minutes;
  ULONG hours;
  ULONG day;
  ULONG month;
  ULONG year;
};


struct termio;
struct termios;


extern BYTE opt_drive;
extern BYTE opt_trunc;
extern BYTE opt_expand;
extern BYTE opt_quote;
extern ULONG debug_flags;
extern HEV process_death;
extern HEV process_birth;
extern HMTX common_mutex;
extern BYTE debug_same_sess;
extern ULONG pipe_number;
extern ULONG queue_number;
extern HFILE errout_handle;
extern HEV signal_sem;
extern HEV kbd_sem_new;
extern ULONG stack_base;
extern ULONG stack_end;
extern ULONG heap_base;
extern ULONG heap_off;
extern ULONG brk_ptr;
extern BYTE exe_name[];
extern HFILE exe_fhandle;
extern BYTE exe_heap;
extern BYTE nocore_flag;
extern BYTE no_popup;
extern thread_data *threads[];
extern ULONG layout_flags;
extern BYTE interface;
extern ULONG umask_bits;
extern ULONG umask_bits1;
extern char *startup_env;
extern layout_table *layout;
extern ULONG heap_size;
extern ULONG heap_end;
extern char kbd_started;
extern ULONG my_pid;
extern BYTE fork_flag;
extern ULONG fork_exec_pid;
extern char const signal_valid[NSIG];
extern ULONG uflags;
extern int zombie_count;
extern char sig_flag;
extern BYTE dont_doskillthread;
extern ULONG version_major;
extern ULONG version_minor;

#if defined (INCL_DOSPROCESS)
extern PIB *init_pib_ptr;
#endif

#if defined (INCL_DOSEXCEPTIONS)
extern EXCEPTIONREGISTRATIONRECORD *exc_reg_ptr;
#endif


#define LOCK_COMMON    do_lock_common ()
#define UNLOCK_COMMON  DosReleaseMutexSem (common_mutex)


void truncate_name (char *dst, const char *src);
ULONG set_error (ULONG rc);
int xlate_errno (int e);
void child_started (void);
void start_cwait_thread (void);
ULONG debug (void);
ULONG debug_read_byte (ULONG addr, BYTE *dst);
ULONG debug_read_word (ULONG addr, ULONG *dst);
ULONG kbd_avail (void);
int termio_read (ULONG handle, char *dst, unsigned count, int *errnop);
void otext (const char *msg);
void odword (ULONG x);
void core_dump (void);
ULONG core_main (ULONG handle);
void core_regs_i (syscall_frame *frame);
void generate_signal (thread_data *td, int signo);
thread_data *get_thread (void);
int get_tid (void);
int proc_check (int pid);
ULONG querysysinfo (ULONG index);
unsigned long long get_clock (int init_flag);
void init_signal16 (void);
void touch (void *base, ULONG count);
void conout (UCHAR chr);

#if defined (INCL_DOSEXCEPTIONS)
void core_regs_e (CONTEXTRECORD *context);
int initthread (EXCEPTIONREGISTRATIONRECORD *registration);
void unwind (EXCEPTIONREGISTRATIONRECORD *registration,
    EXCEPTIONREPORTRECORD *report);
int deliver_pending_signals (thread_data *td, syscall_frame *frame,
    CONTEXTRECORD *context_record);
#endif

void init_fileio (void);
void init_processes (void);
void init_memory (void);
void init_fork (const char *s);
void init_exceptions (void);
void use_layout (void);
void initialize1 (void);
void initialize2 (void);
void *allocate_obj (ULONG size, ULONG flags);
ULONG free_obj (void *mem);
ULONG setmem (ULONG base, ULONG size, ULONG flags, ULONG error);
ULONG setmem_error (ULONG rc);
void *allocate_sub (ULONG size);
ULONG sub_alloc (void **mem, ULONG size);
ULONG sub_free (void *mem, ULONG size);
void error (ULONG rc, const char *msg);
void receive_signals (void);
ULONG reset_event_sem (HEV sem);
sigfun *do_signal (ULONG signo, sigfun *handler, syscall_frame *frame);
void do_raise (int signo, syscall_frame *frame);
int do_kill (int signo, int pid, syscall_frame *frame, int *errnop);
void sig_block_start (void);
void sig_block_end (void);
ULONG set_alarm (ULONG value);
void stop_alarm (void);
ULONG do_wait (ULONG *ptermstatus, ULONG *errnop);
ULONG do_waitpid (ULONG pid, ULONG opt, ULONG *ptermstatus,
    ULONG *errnop);
void init_heap (void);
long do_sbrk (long incr);
long do_brk (ULONG brkp);
int do_fcntl (ULONG handle, ULONG request, ULONG arg, int *errnop);
int do_ioctl1 (ULONG handle, int *errnop);
int do_ioctl2 (ULONG handle, ULONG request, ULONG arg, int *errnop);
int do_dup (ULONG handle, ULONG target, int *errnop);
int do_close (ULONG handle);
ULONG do_read (ULONG handle, void *dst, ULONG count, int *errnop);
ULONG do_write (ULONG handle, void *src, ULONG count, int *errnop);
ULONG do_seek (ULONG handle, ULONG origin, LONG distance, int *errnop);
int do_pipe (int *dst, ULONG pipesize);
int do_ftruncate (ULONG handle, ULONG fsize);
int do_chsize (ULONG handle, ULONG fsize);
int do_fsync (ULONG handle, int *errnop);
int do_filesys (char *dst, ULONG dst_size, const char *drv_name, int *errnop);
int do_mkdir (const char *path);
int do_rmdir (const char *path);
int do_chdir (const char *path);
int do_delete (const char *path);
int do_rename (const char *old_path, const char *new_path);
UCHAR do_getdrive (void);
ULONG do_selectdisk (ULONG drv);
int old_creat (const char *path, ULONG attr, int *errnop);
int old_open (const char *path, ULONG mode, int *errnop);
int sys_open (const char *path, unsigned flags, int *errnop);
int do_stat (const char *path, struct stat *dst, int *errnop);
int do_fstat (ULONG handle, struct stat *dst, int *errnop);
int do_utimes (const char *path, const struct timeval *tv, int *errnop);
void do_lock_common (void);
ULONG create_event_sem (HEV *psem, ULONG attr);
ULONG create_mutex_sem (HMTX *psem);
void request_mutex (HMTX sem);
ULONG get_attr (const char *path, int *errnop);
ULONG set_attr (const char *path, ULONG attr);
ULONG do_getcwd (char *dst, int drive);
ULONG do_find_first (const char *path, ULONG attr, struct _find *dst);
ULONG do_find_next (struct _find *dst);
ULONG do_get_timestamp (ULONG handle, ULONG *time, ULONG *date);
ULONG do_set_timestamp (ULONG handle, ULONG time, ULONG date);
ULONG do_imphandle (ULONG handle, int *errnop);
int check_npipe (const char *s);
void copy_fork (void);
ULONG new_thread (ULONG tid, int *errnop);
ULONG end_thread (ULONG tid, int *errnop);
void kbd_stop (void);
void kbd_init (void);
void kbd_restart (void);
void quit (ULONG rc) __attribute__ ((noreturn));
void do_ftime (struct timeb *dst);
ULONG do_spawn (struct _new_proc *np, ULONG *result);
void do_pause (void);
int do_ptrace (ULONG request, ULONG pid, ULONG addr, ULONG data,
    ULONG *errnop);
ULONG spawn_debug (ULONG pid, ULONG sid);
int do_fork (syscall_frame *frame, ULONG *errnop);
int do_select (struct _select *args, int *errnop);
int execname (char *buf, ULONG bufsize);
void debug_set_wait (ULONG pid, ULONG wait_ret, ULONG end);
void unix2time (struct my_datetime *dst, ULONG src);
ULONG packed2unix (FDATE date, FTIME time);
int kbd_input (UCHAR *dst, int binary_p, int echo_p, int wait_p,
    int check_avail_p);
void conin_string (UCHAR *buf);
int sprintf (char *dst, const char *fmt, ...);
void oprintf (const char *fmt, ...);
ULONG query_async (ULONG handle);
ULONG translate_async (ULONG handle);
void init_termio (ULONG handle);
void termio_set (ULONG handle, const struct termio *tio);
void termio_get (ULONG handle, struct termio *tio);
void termios_set (ULONG handle, const struct termios *tio);
void termios_get (ULONG handle, struct termios *tio);
void termio_flush (ULONG handle);
ULONG termio_avail (ULONG handle);
ULONG async_avail (ULONG handle);

#if defined (_SIGSET_T)
int do_sigaction (int sig, const struct sigaction *iact,
    struct sigaction *oact);
int do_sigpending (sigset_t *set);
int do_sigprocmask (int how, const sigset_t *iset, sigset_t *oset,
    syscall_frame *frame);
int do_sigsuspend (const sigset_t *mask);
#endif
