/* main.c for wm-FPU-emu
   Copyright (c) 1994 by Eberhard Mattes

See the files "README" and "COPYING" for further copyright and warranty
information.  */

#include <stdio.h>
#include <stdlib.h>
#include <linux/linkage.h>
#include <linux/sched.h>
#include "fpu_emu.h"
#include "fpu_prot.h"


#define FPUC_INIT       0
#define FPUC_NEXT       1
#define FPUC_SIGNAL     2

#define FPUN_NEWPROC    0
#define FPUN_ENDPROC    1
#define FPUN_EMU        2

#define MAX_PROCESSES   8

struct fpucom
{
  int notify;
  int pnum;
  int signal;
  struct info frame;
};


static struct task_struct proc_table[MAX_PROCESSES];
int orig_eip;
struct task_struct *current;


int __fpemu (int cmd, struct fpucom *p)
{
  int rc;

  __asm__ ("movb $127, %%ah;"
           "movb $58, %%al;"
           "call ___syscall"
           : "=a"(rc) : "c"(cmd), "d"(p));
  return (rc);
}


void send_sig (int sig, struct task_struct *task, int priv)
{
  struct fpucom com;

  com.signal = sig;
  __fpemu (FPUC_SIGNAL, &com);
}


int main (int argc, char *argv[])
{
  static char banner[] =
    "wm-FPU-emu -- Copyright (C) 1992, 1993, 1994 W. Metzenthen";
  struct fpucom com;
  char *p;

  if (argc != 0)
    {
      puts (banner);
      puts ("This program is loaded automatically by emx when required");
      fflush (stdout);
      return (0);
    }
  p = getenv ("EMXOPT");
  if (p)
    while (*p != 0)
      {
        while (*p == ' ')
          ++p;
        if (strncmp (p, "-V", 2) == 0)
          {
            puts (banner);
            break;
          }
        while (*p != 0 && *p != ' ')
          ++p;
      }

  if (__fpemu (FPUC_INIT, NULL) != 0)
    return (1);
  while (__fpemu (FPUC_NEXT, &com) == 0)
    switch (com.notify)
      {
      case FPUN_NEWPROC:
        /* fprintf (stderr, "FPUN_NEWPROC %d\n", com.pnum); */
        if (com.pnum < 0 || com.pnum >= MAX_PROCESSES)
          {
            fprintf (stderr, "emxfpemu: Invalid process number %d\n",
                     com.pnum);
            return (1);
          }
        proc_table[com.pnum].pnum = com.pnum;
        proc_table[com.pnum].used_math = 0;
        break;

      case FPUN_ENDPROC:
        /* fprintf (stderr, "FPUN_ENDPROC %d\n", com.pnum); */
        break;

      case FPUN_EMU:
        /* fprintf (stderr, "FPUN_EMU %d\n", com.pnum); */
        current = &proc_table[com.pnum];
        math_emulate ((long)&com.frame);
        break;

      default:
        return (1);
      }
  return (1);
}
