;
; SIGNAL.INC --  Signal processing
;
; Copyright (c) 1991-1994 by Eberhard Mattes
;
; This file is part of emx.
;
; emx is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2, or (at your option)
; any later version.
;
; emx is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with emx; see the file COPYING.  If not, write to
; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;
; See emx.asm for a special exception.
;

;
; Cf. /emx/include/signal.h
;
SIGHUP    =      1                      ; Hangup
SIGINT    =      2                      ; Interrupt (Ctrl-C)
SIGQUIT   =      3                      ; Quit
SIGILL    =      4                      ; Illegal instruction
SIGTRAP   =      5                      ; Single step (debugging)
SIGABRT   =      6                      ; abort ()
SIGEMT    =      7                      ; ???
SIGFPE    =      8                      ; Floating point
SIGKILL   =      9                      ; Kill process
SIGBUS    =     10                      ; ???
SIGSEGV   =     11                      ; Segmentation fault
SIGSYS    =     12                      ; Invalid argument to system call
SIGPIPE   =     13                      ; Broken pipe
SIGALRM   =     14                      ; Alarm
SIGTERM   =     15                      ; Termination, process killed
SIGUSR1   =     16                      ; User-defined signal #1
SIGUSR2   =     17                      ; User-defined signal #2
SIGCLD    =     18                      ; Death of a child process
SIGBREAK  =     21                      ; Break (Ctrl-Break)

SIGNALS   =     22                      ; Signals 0..21

;
; Cf. /emx/include/signal.h
;
SIG_DFL   =     0                       ; Default handler
SIG_IGN   =     1                       ; Ignore signal
SIG_ACK   =     4                       ; Acknowledges receipt of a signal

SIG_ERR   =     -1                      ; Return value of signal()

SA_NOCLDSTOP    =       0001H           ; See POSIX.1
SA_SYSV         =       0002H           ; Reset to SIG_DFL
SA_ACK          =       0004H           ; Don't unblock automatically
SA_TRAP         =       8000H           ; Signal generated by an exception

SIG_BLOCK       =       1
SIG_UNBLOCK     =       2
SIG_SETMASK     =       3

;
; struct sigaction
;
SIGACTION       STRUC
SA_HANDLER      DD      ?
SA_MASK         DD      ?
SA_FLAGS        DD      ?
SIGACTION       ENDS

;
; Stack frame for signal handlers
;
SIGFRAME        STRUC
SF_EIP          DD      ?
SF_ARG          DD      ?
SF_SIGNATURE    DD      ?
SF_SIGNO        DD      ?
SF_FLAGS        DD      ?
SF_MASK         DD      ?
SIGFRAME        ENDS

SIG_BLOCK_MASK  =       NOT (1 SHL SIGKILL)

SIG_SIGNATURE   =       9A003CFFH       ; See PMINT.ASM & EXCEPT.ASM for details
SIG_EIP         =       -42             ; Beyond CS limit

              IFNDEF __SIGNAL

SV_DATA         SEGMENT

                EXTRN   CRIT_ERR_FLAG:BYTE
                EXTRN   SIG_CORE:BYTE           ; Signals which dump core
                EXTRN   SIG_VALID:BYTE          ; Valid signal numbers
                EXTRN   EMERGENCY_TIMER:BYTE    ; Timer for emergency exit
                EXTRN   EMERGENCY_FLAG:BYTE     ; Flag for emergency exit

SV_DATA         ENDS


SV_CODE         SEGMENT

                EXTRN   SIG_DELIVER_PENDING:NEAR ; Deliver pending signals
                EXTRN   SIG_USER_CALL:NEAR      ; Invoke user signal handler
                EXTRN   SIG_RETURN:NEAR         ; Return from signal handler
                EXTRN   SIG_MSG:NEAR            ; Display "Stopped by ..."
                EXTRN   DO_SIGNAL:NEAR          ; Implement __signal()
                EXTRN   DO_SIGACTION:NEAR       ; Implement __sigaction()
SV_CODE         ENDS


INIT_CODE       SEGMENT

                EXTRN   HOOK_INT:NEAR           ; Hook interrupts
                EXTRN   CLEANUP_SIGNAL:NEAR     ; Remove interrupt hooks

INIT_CODE       ENDS

              ENDIF
