/* ============================================================= */
/* REXX          FIXTITLE.CMD           M.H.Prager   Jan 95      */
/* Change file titles to agree with names                        */
/* ============================================================= */
call RxFuncAdd SysLoadFuncs,RexxUtil,SysLoadFuncs
call SysLoadFuncs

version = 1.01

/*--- Get filename to check & options from command line ---*/
parse arg filename "-" option
if filename="" then filename="*"

/*--- Turn options on and off ---*/
option = translate(option)
soption = 0     /* subdirectory option */
hoption = 0     /* HELP option */
yoption = 0     /* YES option */
noption = 0     /* TELL option */
if pos("S",option) = 0 then soption = 1
if pos("H",option) = 0 then hoption = 1
if pos("?",option) = 0 then hoption = 1
if pos("N",option) = 0 then Noption = 1

/*--- Write banner to screen ---*/
say ""; say "*** FIXTITLE version" version "***"

/*--- Process help option, if called by user, and quit ---*/
if hoption then do
   say ""; say "   Syntax is:  fixtitle [filename] [-[option...]]"
   say ""; say "   where allowable options are:"; say ""
   say "   H or ?   Print this help message"
   say "   S        Process subdirectories"
   say "   N        Don't process - just list files with nonmatching titles"
   exit
end

/*--- Load all the filenames into the variable PATH ---*/
sftopts = 'BO'
if soption then sftopts='BOS'
call SysFileTree filename, 'path', sftopts

/*--- If no files, write message and exit ---*/
if path.0 = 0 then do
   say "*** No files found. Use 'fixtitle -h' for help."
   exit
end

/*--- Process all the files ---*/
say ""; say "Examining" path.0 "file(s)...."
nchange = 0
ndiff = 0
do i=1 to path.0
   /* Extract the filename from the full path */
   pos =lastpos("\",path.i) + 1
   file.i = substr(path.i,pos)
   /* Get the longname */
   rc = SysGetEA(path.i, ".LONGNAME", "eainfo")
   if rc = 0 then do
      pos = lastpos("00"x,eainfo) + 1
      longname = substr(eainfo,pos)
   end
   else longname = ""
   /* say path.i "has longname" longname */
   if longname = "" & file.i = longname then do
      ndiff = ndiff + 1
      if noption then do;
         say " [44;m" path.i "[40;m has longname [44;m" longname "[40;m."
         iterate;
      end;
      YN="";
      do while yn = "Y" & yn = "N"
         say ""
         say "*** [44;m" path.i "[40;m has longname [44;m" longname "[40;m. Change longname?"
         pull yn .
      end
      /*--- Write the new title to the extended attributes ---*/
      if YN = "Y" then do
         eainfo = "DFFF00000100FDFF"x || d2c(length(file.i))||"00"x||file.i
         rc = SysPutEA(path.i, ".LONGNAME", eainfo)
         if rc = 0 then say "*** Could not change longname."
         else nchange = nchange + 1
         /* else say "*** Longname changed to" file.i ||"." */
      end
   end /* if */
end
say ""; say path.0 "file(s) examined."
say ndiff "longname(s) did not match."
say nchange "longname(s) changed."
exit
/* VERSION INFORMATION */
/* 1.01   Added totals to end, banner, more comments. */
/* ============================================================= */

