/*****************************************************************************
 * $Id: tar.h,v 2.14 1994/11/08 20:12:11 ak Exp $
 *****************************************************************************
 * $Log: tar.h,v $
 * Revision 2.14  1994/11/08  20:12:11  ak
 * Optional case-sensitive compare.
 * Moved include of port.h to tar.h.
 *
 * Revision 2.13  1994/10/29  20:58:11  ak
 * Bugfix multivolume QFA.
 *
 * Revision 2.12  1994/10/17  02:04:45  ak
 * Allow --buffer control the buffer program, similar to --zip.
 * Fixed argument passing for --zip (comma).
 * --zip now requires explicit -d, if prog specified.
 *
 * Revision 2.11  1994/09/07 18:45:27  edvkai
 * AIX
 *
 * Revision 2.10  1994/07/11 16:02:19  edvkai
 * Dump ACL to single file, if filename specified with --dump-acl.
 * Show ACL fetch errors.
 *
 * Revision 2.9  1994/07/05 18:45:12  edvkai
 * 2.35: Posix support for long filenames and magic name.
 *
 * Lots of changes in filename handling, I hope I found all places. Added
 * decode_filename() with result in var 'filename' for this. header.name
 * should no longer be used. The diffarch kludge FILENAME is no longer
 * necessary.
 *
 * Treatment of links is not up-to-date, I fear - what's defined by Posix
 * about long link names?
 *
 * Due to NONAMES, prior versions created "oldarch" style archives without
 * magic name. Now magic is "ustar\0""00" for Posix and "ustar  \0" else.
 *
 * Unused header space is used to support multi-volume archives in Posix -
 * THIS IS SPECIFIC TO GTAK.
 *
 * Note that Posix conflicts with atime/ctime.
 *
 * Revision 2.8  1994/07/05 14:56:41  edvkai
 * Access Control Lists.
 *
 * Added --substitute, allows redirection of UNC names. No support for links yet.
 *
 * Streamlined absolute path treatment. No skipcrud any more.
 *
 * Bugfix: If a directory existed, EAs were not attached.
 *
 * Revision 2.7  1994/05/31 23:24:03  ak
 * Reversed meaning of --old-ea to stay compatible to gtak 2.12. The
 * 32-bit API should have a longer life anyway (PowerPC?) and is faster.
 *
 * Avoid _ead_read like the plague (sorry E.M.). Crashed in diffarch if
 * the EMX libs where being used but worked when I compiled the patched
 * ead* sources into TAR. Now using ea_load in diffarch too.
 *
 * Removed EA_MODE conditionals.
 *
 * Revision 2.6  1994/05/31 21:33:48  ak
 * Still there seems to be a memory leak somewhere in EMX _ead_read.
 * Didn't find it with dbmalloc though. Added EA_MODE (former EMX_EA) of
 * 2, using my own ea_* functions to load the attributes and the EMX
 * functions to manipulate them. The leak seems to be gone now. Added
 * --old-ea to allow creating the gtak 2.12 EA records.
 *
 * Revision 2.5  1994/01/01 11:03:06  ak
 * Both SCO UNIX and AIX TAR create header checksums interpreting
 * filename characters above 127 as signed values. So accept both
 * signed and unsigned checksum when reading and create signed
 * checksum on request (--signed-checksum). I don't know what the
 * standard defines.
 *
 * Revision 2.4  1993/11/29  17:02:51  edvkai
 * Multivolume QFA fixes.
 * Smaller size of tape directory.
 *
 * Revision 2.3  1993/11/25  20:23:53  edvkai
 * Major QFA changes.
 *
 * QFA now supports both block id and relative addressing. Relative
 * addressing is more efficient with short distances. 4mm and 8mm devices
 * do well with relative addressing only. For the sake of QIC tapes, TAR
 * optimizes QFA using block ids for large distances.
 *
 * The format of the tape-directory changed. No longer compatible to prior
 * versions. Maybe I'll add a utility for conversion.
 *
 * Rmt interface changed. Now using block numbers instead of byte offsets
 * for seek. Previously the lseek limitation to 2GB limited QFA archive
 * capacity. Changed rmtlseek to rmtseek to indicate that it is different.
 *
 * QFA should be able to handle multi-volume archives now.
 *
 * If a volume name is specified on the command line, QFA skips archives
 * having a different volume name.
 *
 * Code for header pretty-printing cleaned. Doesn't depend on hstat any
 * longer and requires less globals. No explanation text behind names in
 * tape directory.
 *
 * A few bugfixes.
 *
 * Revision 2.2  1993/09/17  15:11:03  edvkai
 * - Better support for GZip, reorganized compression options.
 * - Buffered mode now available without compression.
 * - Merged GNU dumps and archive bit backups into a single set of options.
 *
 * Revision 2.1  1993/08/08  19:11:08  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.7  1992/12/13  09:39:27  ak
 * f_archive/f_reset_archive added to support the "archived" bit.
 *
 * Revision 1.6  1992/10/25  10:20:37  ak
 * Don't archive/extract ctime+atime if a single -p or --same-perm is
 * specified. It make trouble on incremental backups and file transfers.
 * Added an option --all-timestamps or twice -p to archive/extract
 * ctime+atime.
 *
 * Revision 1.5  1992/09/26  08:31:55  ak
 * *** empty log message ***
 *
 * Revision 1.4  1992/09/20  07:46:53  ak
 * Fixes from Kai Uwe Rommel
 *   --checkpoints instead of --semi-verbose (1.11)
 *   -g filenames
 *
 * Revision 1.3  1992/09/12  15:57:02  ak
 * - Usenet patches for GNU TAR 1.10
 * - Bugfixes and patches of Kai Uwe Rommel:
 *         filename conversion for FAT
 *         EMX 0.8e
 *         -0..1 alias for a: b:
 *         -2..7 alias for +++TAPE$x
 *
 * Revision 1.2  1992/09/02  20:08:51  ak
 * Version AK200
 * - Tape access
 * - Quick file access
 * - OS/2 extended attributes
 * - Some OS/2 fixes
 * - Some fixes of Kai Uwe Rommel
 *
 * Revision 1.1.1.1  1992/09/02  19:22:51  ak
 * Original GNU Tar 1.10 with some filenames changed for FAT compatibility.
 *
 * Revision 1.1  1992/09/02  19:22:50  ak
 * Initial revision
 *
 *****************************************************************************/

/*
 * Modified by Andreas Kaiser July 92.
 * See CHANGES.AK for info.
 */

/*

	Copyright (C) 1988 Free Software Foundation

GNU tar is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY.  No author or distributor accepts responsibility to anyone
for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.
Refer to the GNU tar General Public License for full details.

Everyone is granted permission to copy, modify and redistribute GNU tar,
but only under the conditions described in the GNU tar General Public
License.  A copy of this license is supposed to have been given to you
along with GNU tar so you can know your rights and responsibilities.  It
should be in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.

In other words, go ahead and share GNU tar, but don't try to stop
anyone else from sharing it farther.  Help stamp out software hoarding!
*/

/*
 * Header file for tar (tape archive) program.
 *
 * @(#)tar.h 1.24 87/11/06
 *
 * Created 25 August 1985 by John Gilmore, ihnp4!hoptoad!gnu.
 */

#include "testpad.h"

#if defined(DEBUG) && DEBUG > 1
  #include <dbmalloc.h>
  void *_p_;
  #define ck_malloc(n) ((_p_ = malloc(n)) ? _p_ : panic("Couldn't allocate memory"))
  #define ck_realloc(p,n) ((_p_ = realloc(p,n)) ? _p_ : panic("Couldn't re-allocate memory"))
  #define valloc(n) malloc(n)
#else
  extern char *ck_malloc(),*ck_realloc(), *valloc();
#endif

/* major() and minor() macros (among other things) defined here for hpux */
#ifdef hpux
#include <sys/mknod.h>
#endif

/*
 * Kludge for handling systems that can't cope with multiple
 * external definitions of a variable.  In ONE routine (tar.c),
 * we #define TAR_EXTERN to null; here, we set it to "extern" if
 * it is not already set.
 */
#ifndef TAR_EXTERN
#define TAR_EXTERN extern
#endif

#if defined(USG) && !defined(XENIX) && !defined(HAVE_SIZE_T)
typedef int size_t;
#endif

/*
 * Header block on tape.
 *
 * I'm going to use traditional DP naming conventions here.
 * A "block" is a big chunk of stuff that we do I/O on.
 * A "record" is a piece of info that we care about.
 * Typically many "record"s fit into a "block".
 */
#define	RECORDSIZE	512
#define	NAMSIZ		100
#define PREFIX		155
#define	TUNMLEN		32
#define	TGNMLEN		32
#define SPARSE_EXT_HDR  21
#define SPARSE_IN_HDR	4

struct sparse {
	char offset[12];
	char numbytes[12];
};

struct sp_array {
	int offset;
	int numbytes;
};

union record {
	char		charptr[RECORDSIZE];
	struct header {
		char	name[NAMSIZ];
		char	mode[8];
		char	uid[8];
		char	gid[8];
		char	size[12];
		char	mtime[12];
		char	chksum[8];
		char	linkflag;
		char	linkname[NAMSIZ];
		char	magic[8];
		char	uname[TUNMLEN];
		char	gname[TGNMLEN];
		char	devmajor[8];
		char	devminor[8];
		/* these following fields were added by JF for gnu */
		/* and are NOT standard */
		char	atime[12];
		char	ctime[12];
		char	offset[12];
		char	longnames[4];
#ifdef NEEDPAD
		char    pad;
#endif
		struct	sparse sp[SPARSE_IN_HDR];
		char	isextended;
		char	realsize[12];		/* true size of the sparse file */
/*		char	ending_blanks[12];*/	/* number of nulls at the
						   end of the file, if any */
	} header;
	struct extended_header {
		struct sparse sp[21];
		char isextended;
	} ext_hdr;
	struct posix_header {
		char	name[NAMSIZ];
		char	mode[8];
		char	uid[8];
		char	gid[8];
		char	size[12];
		char	mtime[12];
		char	chksum[8];
		char	linkflag;
		char	linkname[NAMSIZ];
		char	magic[6];
		char	version[2];
		char	uname[TUNMLEN];
		char	gname[TGNMLEN];
		char	devmajor[8];
		char	devminor[8];
		char	prefix[PREFIX];
		char	offset[12];
	} posix;
};

/* The checksum field is filled with this while the checksum is computed. */
#define	CHKBLANKS	"        "	/* 8 blanks, no null */

/* The magic field is filled with this if uname and gname are valid. */
#define	TMAGIC		"ustar  "	/* 7 chars and a null */
#define	TMAGIC_POSIX	"ustar"		/* 5 chars and a null */
#define TVERSION_POSIX	"00"

/* The linkflag defines the type of file */
#define	LF_OLDNORMAL	'\0'		/* Normal disk file, Unix compat */
#define	LF_NORMAL	'0'		/* Normal disk file */
#define	LF_LINK		'1'		/* Link to previously dumped file */
#define	LF_SYMLINK	'2'		/* Symbolic link */
#define	LF_CHR		'3'		/* Character special file */
#define	LF_BLK		'4'		/* Block special file */
#define	LF_DIR		'5'		/* Directory */
#define	LF_FIFO		'6'		/* FIFO special file */
#define	LF_CONTIG	'7'		/* Contiguous file */
/* Further link types may be defined later. */

/* Note that the standards committee allows only capital A through
   capital Z for user-defined expansion.  This means that defining something
   as, say '8' is a *bad* idea. */
#define LF_DUMPDIR	'D'		/* This is a dir entry that contains
					   the names of files that were in
					   the dir at the time the dump
					   was made */
#define LF_MULTIVOL	'M'		/* This is the continuation
					   of a file that began on another
					   volume */
#define LF_NAMES	'N'		/* For storing filenames that didn't
					   fit in 100 characters */
#define LF_SPARSE	'S'		/* This is for sparse files */
#define LF_VOLHDR	'V'		/* This file is a tape/volume header */
					/* Ignore it on extraction */
#define LF_EATTR	'A'		/* extended attributes (OS/2) */
#define LF_ACL		'L'		/* access control lists (OS/2) */

/*
 * Exit codes from the "tar" program
 */
#define	EX_SUCCESS	0		/* success! */
#define	EX_ARGSBAD	1		/* invalid args */
#define	EX_BADFILE	2		/* invalid filename */
#define	EX_BADARCH	3		/* bad archive */
#define	EX_SYSTEM	4		/* system gave unexpected error */
#define EX_BADVOL	5		/* Special error code means
					   Tape volume doesn't match the one
					   specified on the command line */

#define ListLong	0x01
#define ListCheck	0x02
#define ListBlock	0x04
#define ListAttr	0x08
#define ListModes	0x10

/*
 * Global variables
 */
TAR_EXTERN union record	*ar_block;	/* Start of block of archive */
TAR_EXTERN union record	*ar_record;	/* Current record of archive */
TAR_EXTERN union record	*ar_last;	/* Last+1 record of archive block */
TAR_EXTERN char		ar_reading;	/* 0 writing, !0 reading archive */
TAR_EXTERN int		blocking;	/* Size of each block, in records */
TAR_EXTERN int		blocksize;	/* Size of each block, in bytes */
TAR_EXTERN char		*ar_file;	/* File containing archive */
TAR_EXTERN char		*info_script;	/* Script to run at end of each tape change */
TAR_EXTERN char		*name_file;	/* File containing names to work on */
TAR_EXTERN char		*tar;		/* Name of this program */
TAR_EXTERN struct sp_array *sparsearray;/* Pointer to the start of the scratch space */
TAR_EXTERN int		sp_array_size;	/* Initial size of the sparsearray */
TAR_EXTERN long		tot_written;    /* Total blocks written to output */
TAR_EXTERN struct re_pattern_buffer
  			*label_pattern;	/* compiled regex for extract label */
TAR_EXTERN int		is_device;	/* Archive is device */

#define filename file_name		/* name conflict */
TAR_EXTERN char		filename[260+2]; /* current filename */

/*
 * Flags from the command line
 */
TAR_EXTERN int cmd_mode;
#define CMD_NONE	0
#define CMD_CAT		1		/* -A */
#define CMD_CREATE	2		/* -c */
#define CMD_DIFF	3		/* -d */
#define CMD_APPEND	4		/* -r */
#define CMD_LIST	5		/* -t */
#define CMD_UPDATE	6		/* -u */
#define CMD_EXTRACT	7		/* -x */
#define CMD_DELETE	8		/* -D */
#define CMD_VERSION	9		/* +version */

					/* -[0-9][lmh] */
			/* CMD_CAT	   -A */
					/* -b */
TAR_EXTERN int	f_reblock;		/* -B */
			/* CMD_CREATE	   -c */
					/* -C */
			/* CMD_DIFF	   -d */
/* TAR_EXTERN char	f_dironly;	/* -D */
TAR_EXTERN int	f_checkpoints;		/* -E */
					/* -f */
TAR_EXTERN int	f_run_script_at_end;	/* -F */
TAR_EXTERN int 	f_gnudump;		/* -G */
TAR_EXTERN int	f_follow_links;		/* -h */
TAR_EXTERN int	f_host;			/* -H */
TAR_EXTERN int	f_ignorez;		/* -i */
			/* CMD_DELETE	   -J */
TAR_EXTERN int	f_keep;			/* -k */
TAR_EXTERN int	f_startfile;		/* -K */
TAR_EXTERN int	f_local_filesys;	/* -l */
TAR_EXTERN int  tape_length;		/* -L */
TAR_EXTERN int	f_modified;		/* -m */
TAR_EXTERN int 	f_multivol;		/* -M */
TAR_EXTERN int	f_new_files;		/* -N */
TAR_EXTERN int	f_oldarch;		/* -o */
TAR_EXTERN int  f_exstdout;		/* -O */
TAR_EXTERN int	f_use_protection;	/* -p */
TAR_EXTERN int  f_absolute_paths;	/* -P */
TAR_EXTERN int	f_sayblock;		/* -R */
TAR_EXTERN int  f_show_omitted_dirs;	/* +show-omitted-dirs */
TAR_EXTERN int	f_sorted_names;		/* -s */
TAR_EXTERN int	f_sparse_files;		/* -S  ... JK */
TAR_EXTERN int	f_namefile;		/* -T */
			/* CMD_UPDATE	   -u */
TAR_EXTERN int	f_verbose;		/* -v */
TAR_EXTERN char *f_volhdr;		/* -V */
TAR_EXTERN int  f_confirm;		/* -w */
TAR_EXTERN int  f_verify;		/* -W */
			/* CMD_EXTRACT     -x */
TAR_EXTERN int  f_exclude;		/* -X */
TAR_EXTERN int 	f_no_recursion;		/* -Y */
TAR_EXTERN int 	f_compress;		/* -z */
TAR_EXTERN char *f_buffered;		/* +buffered */
TAR_EXTERN int	f_do_chown;		/* +do-chown */
TAR_EXTERN int  f_totals;		/* +totals */
TAR_EXTERN char	*f_map_file;		/* +tape-directory */
TAR_EXTERN char	f_map_mode;		/* +tape-directory, prefix */
TAR_EXTERN int	f_one_level;		/* +no-recursion */
TAR_EXTERN int	f_fat;			/* +fat */
TAR_EXTERN char *f_zip;			/* +zip */
TAR_EXTERN int	f_all_timestamps;	/* +all-timestamps */
#ifdef OS2
TAR_EXTERN int	f_archive;		/* 'f'irst, 's'econd, 'i'ncremental */
TAR_EXTERN int	f_old_ea;		/* 2.12-style EAs */
#endif
TAR_EXTERN int	f_signed_checksum;	/* --signed-checksum */
TAR_EXTERN int	f_acl;			/* --acl */
TAR_EXTERN int	f_dump_acl;		/* --dump-acl */
TAR_EXTERN char * f_substitute;		/* --substitute */
TAR_EXTERN int	f_posix;		/* --posix */

	/* --substitute: */
TAR_EXTERN char * subst_from;
TAR_EXTERN int	  subst_from_len;
TAR_EXTERN char * subst_to;
TAR_EXTERN int	  subst_to_len;

TAR_EXTERN FILE * acl_file;

/*
 * We now default to Unix Standard format rather than 4.2BSD tar format.
 * The code can actually produce all three:
 *	f_standard	ANSI standard
 *	f_oldarch	V7
 *	neither		4.2BSD
 * but we don't bother, since 4.2BSD can read ANSI standard format anyway.
 * The only advantage to the "neither" option is that we can cmp our
 * output to the output of 4.2BSD tar, for debugging.
 */
#define		f_standard		(!f_oldarch)

/*
 * Structure for keeping track of filenames and lists thereof.
 */
struct name {
	struct name	*next;
	short		length;		/* cached strlen(name) */
	char		found;		/* A matching file has been found */
	char		firstch;	/* First char is literally matched */
	char		regexp;		/* This name is a regexp, not literal */
	char		*change_dir;	/* JF set with the -C option */
	char		*dir_contents;	/* JF for f_gnudump */
	char		fake;		/* dummy entry */
	char		name[1];
};

TAR_EXTERN struct name	*namelist;	/* Points to first name in list */
TAR_EXTERN struct name	*namelast;	/* Points to last name in list */

TAR_EXTERN int		archive;	/* File descriptor for archive file */
TAR_EXTERN int		errors;		/* # of files in error */

TAR_EXTERN char *	gnu_dumpfile;

TAR_EXTERN char *	save_name;	/* Name of the file we are currently writing */
TAR_EXTERN long		save_totsize;	/* total size of file we are writing.  Only
					   valid if save_name is non_zero */
TAR_EXTERN long		save_sizeleft;	/* Where we are in the file we are writing.
					   Only valid if save_name is non-zero */

/*
 * Error recovery stuff
 */
TAR_EXTERN char		read_error_flag;


/*
 * Declarations of functions available to the world.
 */
union record *findrec();
void userec();
union record *endofrecs();
void anno();

/* Do not prototype these for BSD--see port.c [DOPRNT_MSG].  */
#if defined(__STDC__) && (!defined(BSD42) || defined(STDC_MSG)) || defined(ANSI_C)
void msg(char *, ...);
void msg_perror(char *, ...);
#else
void msg();
void msg_perror();
#endif
/* #define	 annorec(stream, msg)	anno(stream, msg, 0)	/* Cur rec */
/* #define	annofile(stream, msg)	anno(stream, msg, 1)	/* Saved rec */


/* OS/machine/compiler/environment specific things */
#include "port.h"
