/*****************************************************************************
 * $Id: ak_os2.c,v 2.17 1994/11/08 20:12:14 ak Exp $
 *****************************************************************************
 * $Log: ak_os2.c,v $
 * Revision 2.17  1994/11/08  20:12:14  ak
 * Optional case-sensitive compare.
 * Moved include of port.h to tar.h.
 *
 * Revision 2.16  1994/10/29  20:57:00  ak
 * Bugfix QFA.
 *
 * Revision 2.15  1994/10/19  01:56:03  ak
 * Tape directory support in buffered mode.
 * Volume labels in tape directory were wrong.
 * Alias -Q for --buffered.
 * Priority control for buffered mode.
 *
 * Revision 2.14  1994/10/17 21:34:57  ak
 * Finally, I hope...
 *
 * Revision 2.13  1994/10/17 21:20:41  ak
 * f_zip, f_buffered fixed.
 *
 * Revision 2.12  1994/10/17 17:52:29  edvkai
 * Bugfix --buffered.
 * Chdir support now works.
 *
 * Revision 2.11  1994/10/17 02:04:43  ak
 * Allow --buffer control the buffer program, similar to --zip.
 * Fixed argument passing for --zip (comma).
 * --zip now requires explicit -d, if prog specified.
 *
 * Revision 2.10  1994/07/11 16:02:01  edvkai
 * Dump ACL to single file, if filename specified with --dump-acl.
 * Show ACL fetch errors.
 *
 * Revision 2.9  1994/07/05 18:44:45  edvkai
 * 2.35: Posix support for long filenames and magic name.
 *
 * Lots of changes in filename handling, I hope I found all places. Added
 * decode_filename() with result in var 'filename' for this. header.name
 * should no longer be used. The diffarch kludge FILENAME is no longer
 * necessary.
 *
 * Treatment of links is not up-to-date, I fear - what's defined by Posix
 * about long link names?
 *
 * Due to NONAMES, prior versions created "oldarch" style archives without
 * magic name. Now magic is "ustar\0""00" for Posix and "ustar  \0" else.
 *
 * Unused header space is used to support multi-volume archives in Posix -
 * THIS IS SPECIFIC TO GTAK.
 *
 * Note that Posix conflicts with atime/ctime.
 *
 * Revision 2.8  1994/05/31 21:33:07  ak
 * Still there seems to be a memory leak somewhere in EMX _ead_read.
 * Didn't find it with dbmalloc though. Added EA_MODE (former EMX_EA) of
 * 2, using my own ea_* functions to load the attributes and the EMX
 * functions to manipulate them. The leak seems to be gone now. Added
 * --old-ea to allow creating the gtak 2.12 EA records.
 *
 * Revision 2.7  1993/11/30 22:28:04  ak
 * Bugfix zip_opts.
 *
 * Revision 2.6  1993/11/29  17:02:33  edvkai
 * Multivolume QFA fixes.
 * Smaller size of tape directory.
 *
 * Revision 2.5  1993/11/25  20:23:23  edvkai
 * Major QFA changes.
 *
 * QFA now supports both block id and relative addressing. Relative
 * addressing is more efficient with short distances. 4mm and 8mm devices
 * do well with relative addressing only. For the sake of QIC tapes, TAR
 * optimizes QFA using block ids for large distances.
 *
 * The format of the tape-directory changed. No longer compatible to prior
 * versions. Maybe I'll add a utility for conversion.
 *
 * Rmt interface changed. Now using block numbers instead of byte offsets
 * for seek. Previously the lseek limitation to 2GB limited QFA archive
 * capacity. Changed rmtlseek to rmtseek to indicate that it is different.
 *
 * QFA should be able to handle multi-volume archives now.
 *
 * If a volume name is specified on the command line, QFA skips archives
 * having a different volume name.
 *
 * Code for header pretty-printing cleaned. Doesn't depend on hstat any
 * longer and requires less globals. No explanation text behind names in
 * tape directory.
 *
 * A few bugfixes.
 *
 * Revision 2.4  1993/09/17  15:25:48  edvkai
 * *** empty log message ***
 *
 * Revision 2.3  1993/09/17  15:10:42  edvkai
 * - Better support for GZip, reorganized compression options.
 * - Buffered mode now available without compression.
 * - Merged GNU dumps and archive bit backups into a single set of options.
 *
 * Revision 2.2  1993/08/08  19:27:36  ak
 * *** empty log message ***
 *
 * Revision 2.1  1993/08/08  19:06:22  ak
 * Merge of network TAR with 2.12.
 *
 * Revision 1.2  1993/05/28  12:55:03  AK
 * Added GZip option.
 * Version 2.20.
 *
 * Revision 1.1  1993/04/26  15:16:48  AK
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: ak_os2.c,v 2.17 1994/11/08 20:12:14 ak Exp $";

/* System specific code for OS/2.
   Copyright (C) 1988 Free Software Foundation

This file is part of GNU Tar.

GNU Tar is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Tar is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Tar; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_DOSMODULEMGR
#define INCL_DOSPROCESS
#define INCL_DOSQUEUES
#include <os2.h>

#include "tar.h"
#include "rmt.h"

#undef opendir
#include <dirent.h>

void ck_close();

#undef strcmp
#undef strncmp
int (*strIcmp)(const char *, const char *) = stricmp;
int (*strnIcmp)(const char *, const char *, unsigned long) = strnicmp;

void
case_sensitive(void)
{
	strIcmp  = strcmp;
	strnIcmp = strncmp;
}

/*----------------------------------------------------------------------*/
/*		OS/2 Utilites						*/

void
get_fileattr(char *name, struct stat *st)
{
	ULONG attr;
	FILESTATUS3 fi;
	if (!f_use_protection)
		return;
	st->st_mode &= ~0077;
#ifdef __EMX__
	attr = st->st_attr;
#else
	if (DosQueryPathInfo(name, FIL_STANDARD, &fi, sizeof fi))
		return;
	attr = fi.attrFile;
#endif
	if (attr & A_HIDDEN)
		st->st_mode |= 0010;
	if (attr & A_SYSTEM)
		st->st_mode |= 0001;
}

void
put_fileattr(char *name, struct stat *st)
{
	FILESTATUS3 fi;
	if (!f_use_protection)
		return;
	if (DosQueryPathInfo(name, FIL_STANDARD, &fi, sizeof fi))
		return;
	if (st->st_mode & 0010)
		fi.attrFile |= A_HIDDEN;
	if (st->st_mode & 0001)
		fi.attrFile |= A_SYSTEM;
	DosSetPathInfo(name, FIL_STANDARD, &fi, sizeof fi, 0);
}

void
reset_archive(char *name)
{
	FILESTATUS3 fi;
	if (DosQueryPathInfo(name, FIL_STANDARD, &fi, sizeof fi))
		return;
	fi.attrFile &= ~A_ARCHIVE;
	DosSetPathInfo(name, FIL_STANDARD, &fi, sizeof fi, 0);
}

static void
mkos2time(long sec, PFTIME pftime, PFDATE pfdate)
{
	struct tm *p;
	if (sec)
		sec -= timezone;
	else
		time(&sec);
	p = gmtime (&sec);
  	*(USHORT *)pftime = 
	  p->tm_sec / 2 + (p->tm_min << 5) + (p->tm_hour << 11);
	*(USHORT *)pfdate = 
	  p->tm_mday + ((p->tm_mon + 1) << 5) + ((p->tm_year - 80) << 9);
}

void
put_filetime(char *name, struct stat *st)
{
  	struct tm *p;
	FILESTATUS3 fi;
	if (DosQueryPathInfo(name, FIL_STANDARD, &fi, sizeof fi))
		return;
	if (!f_posix) {
		mkos2time(st->st_atime, &fi.ftimeLastAccess, &fi.fdateLastAccess);
		mkos2time(st->st_ctime, &fi.ftimeCreation, &fi.fdateCreation);
	}
	mkos2time(st->st_mtime, &fi.ftimeLastWrite, &fi.fdateLastWrite);
	DosSetPathInfo(name, FIL_STANDARD, &fi, sizeof fi, 0);
}

void
force_delete(char *file)
{
	DosForceDelete(file);
}

char *
os2error(char *msgf, int rc)
{
	static char buf[512];
	ULONG len;

	if (DosGetMessage(NULL, 0, buf, sizeof buf - 1, rc, msgf, &len))
		sprintf(buf, "error code %d", rc);
	else {
		while (len > 0 && isspace(buf[len-1]))
			--len;
		buf[len] = '\0';
	}
	return buf;
}

/*----------------------------------------------------------------------*/
/*		Child Process Operations				*/

static int	compress_pid;		/* process id of "compress" child */
static int	buffer_pid;		/* process id of "buffer" child */

static int	thread_in;		/* thread input fd */
static int	thread_out;		/* thread output fd */
static int	thread_id;		/* thread id */
static char *	thread_buf;		/* data buffer */
static int	thread_errno;		/* error code */

#define MaxArgs	10			/* max args for zip and buffer */
static char *	zip_args[MaxArgs+1];	/* compression program & options */
static char *	buffer_args[MaxArgs+1];	/* buffering program & options */

void
ck_pipe(pipes)
	int *pipes;
{
	unsigned r;
	if (r = DosCreatePipe((ULONG *)&pipes[0], (ULONG *)&pipes[1], 40 * 1024)) {
		msg("Cannot create a pipe (err=%u)", r);
		exit(EX_SYSTEM);
	}
}

/*
 * Duplicate a file descriptor into a certain slot.
 * Equivalent to BSD "dup2" with error reporting.
 */
static void
movefd(int from, int to)
{
	int err;

	if (from != to) {
		err=close(to);
		if(err<0 && errno!=EBADF) {
			msg_perror("Cannot close descriptor %d",to);
			exit(EX_SYSTEM);
		}
		err = dup(from);
		if (err != to) {
			msg_perror("Cannot dup descriptor %d",from);
			exit(EX_SYSTEM);
		}
		ck_close(from);
	}
}

static int
callv(int rd, int wr, char **argv)
{
	int r, oldrd = -1, oldwr = -1;

	oldrd = dup(0);
	noinherit(oldrd);
	movefd(rd, 0);
	inherit(0);

	oldwr = dup(1);
	noinherit(oldwr);
	movefd(wr, 1);
	inherit(1);

	r = spawnvp(P_NOWAIT, argv[0], (void *)argv);
	movefd(oldrd, 0);
	movefd(oldwr, 1);
	return r;
}

static int
call(int rd, int wr, ...)
{
	int r;
	va_list ap;
	va_start(ap, wr);
	r = callv(rd, wr, (void *)ap);
	va_end(ap);
	return r;
}

static int
start_compress(int fd)
{
	int ret_fd, pipe[2];

	ck_pipe(pipe);
	if (ar_reading) {
		ret_fd = pipe[0];
		noinherit(ret_fd);
		compress_pid = callv(fd, pipe[1], zip_args);
	} else {
		ret_fd = pipe[1];
		noinherit(ret_fd);
		compress_pid = callv(pipe[0], fd, zip_args);
	}
	if (compress_pid < 0) {
		msg_perror("Cannot start \"%s\"", zip_args[0]);
		exit(EX_SYSTEM);
	}
	return ret_fd;
}

static int
start_buffer(int fd)
{
	int ret_fd, pipe[2];

	ck_pipe(pipe);
	if (ar_reading) {
		ret_fd = pipe[0];
		noinherit(ret_fd);
		buffer_pid = callv(fd, pipe[1], buffer_args);
	} else {
		ret_fd = pipe[1];
		noinherit(ret_fd);
		buffer_pid = callv(pipe[0], fd, buffer_args);
	}
	if (buffer_pid < 0) {
		msg_perror("Cannot start \"%s\"", buffer_args[0]);
		exit(EX_SYSTEM);
	}
	return ret_fd;
}

static void
copy_in(void *arg)
{
	int nbuf, nread;

	DosSetPriority(PRTYS_THREAD, PRTYC_NOCHANGE, 31, 0);

	thread_errno == 0;
	do {
		nbuf = 0;
		do {
			nread = rmtread(thread_in, thread_buf + nbuf, blocksize - nbuf);
			if (nread > 0)
				nbuf += nread;
		} while (nread > 0 && nbuf < blocksize);
		if (nbuf > 0 && write(thread_out, thread_buf, nbuf) != nbuf)
			thread_errno = errno;
		if (nread < 0)
			thread_errno = errno;
	} while (nread > 0 && !thread_errno);
	close(thread_out);
}

static void
copy_out(void *arg)
{
	int nbuf, nread, qfa = 0, flag;
	FILE *qfamap;
	long baserec, record, treshold, block;

	DosSetPriority(PRTYS_THREAD, PRTYC_NOCHANGE, 31, 0);

	if (f_map_mode == 'a' && _isrmt(thread_out)) {
		qfa = 1;
		dir_qfa_init();
		dir_qfa_record(0, rmtseek(thread_out, 0L, 4));
		baserec = record = 0;
		treshold = ((1024L * 1024L) / blocksize) * blocking;
	}

	thread_errno == 0;
	do {
		if (qfa && record - baserec >= treshold) {
			block = rmtseek(thread_out, 0L, 4);
			flag = 1;
		} else
			flag = 0;

		nbuf = 0;
		do {
			nread = read(thread_in, thread_buf + nbuf, blocksize - nbuf);
			if (nread > 0)
				nbuf += nread;
		} while (nread > 0 && nbuf < blocksize);
		if (nbuf < blocksize) {
			memset(thread_buf + nbuf, 0, blocksize - nbuf);
			nbuf = blocksize;
		}
		if (nbuf > 0 && rmtwrite(thread_out, thread_buf, nbuf) != nbuf)
			thread_errno = errno;
		if (nread < 0)
			thread_errno = errno;

		if (nbuf > 0) {
			if (flag) {
				dir_qfa_record(record, block);
				baserec = record;
			}
			record += nbuf / 512;
		}
	} while (nread > 0 && !thread_errno);
	close(thread_in);

	if (qfa) {
		dir_qfa_record(record, block);
		dir_qfa_term();
	}
}

static int
start_thread(int fd)
{
#ifdef __MT__
	int ret_fd, pipe[2];
	void (*fcn)(void *);

	thread_errno = 0;
	if (thread_buf)
		free(thread_buf);
	thread_buf = ck_malloc(blocksize);
	ck_pipe(pipe);
	noinherit(pipe[0]);
	noinherit(pipe[1]);
	if (ar_reading) {
		thread_in = fd;
		thread_out = pipe[1];
		ret_fd = pipe[0];
		fcn = copy_in;
	} else {
		ret_fd = pipe[1];
		thread_in = pipe[0];
		thread_out = fd;
		fcn = copy_out;
	}
	if ((thread_id = _beginthread(fcn, 0, 8192, 0)) < 0) {
		msg_perror("Cannot start thread");
		exit(EX_SYSTEM);
	}
	return ret_fd;
#else
	msg_perror("Cannot start thread");
	exit(EX_SYSTEM);
#endif
}

static int
prog_control(char **args, char *opt, char *env)
{
	char *cp;
	int i = 0;

	if (!opt || !*opt)
		opt = getenv(env);
	if (!opt || !*opt)
		return 0;
	cp = strdup(opt);
	for (cp = strtok(cp, " ,"); cp; cp = strtok(NULL, " ,")) 
		if (i < MaxArgs)
			args[i++] = cp;
	return i;
}

int
child_open()
{
	int fd, i;
	char *opt;

	if (f_compress) {
		i = prog_control(zip_args, f_zip, "TAR_COMPRESS");
		if (i == 0)
			zip_args[i++] = (f_zip || ar_reading) ? "gzip" : "compress";
		if (ar_reading)
			zip_args[i++] = "-d";
		zip_args[i] = NULL;
	}
	if (f_buffered) {
		switch (i = prog_control(buffer_args, f_buffered, "TAR_BUFFER")) {
		case 0:
			buffer_args[0] = "buffer";
		case 1:
			if (ar_reading) {
				buffer_args[1] = "-i90";
				buffer_args[2] = "-o0";
				buffer_args[3] = "-p30";
			} else {
				buffer_args[1] = "-i0";
				buffer_args[2] = "-o90";
				buffer_args[3] = "-p30";
			}
			i = 4;
		default:
			;
		}
		buffer_args[i] = NULL;
	}

	compress_pid = buffer_pid = thread_id = -1;

	if (strcmp(ar_file, "-") == 0 || ar_file[0] == 0)
		fd = ar_reading ? 0 : 1;
	else {
		int mode = ar_reading ? O_RDONLY|O_BINARY
				      : O_WRONLY|O_CREAT|O_TRUNC|O_BINARY;
		if ((fd = rmtopen(ar_file, mode, 0666)) < 0) {
			msg_perror("Cannot open archive %s",ar_file);
			exit(EX_BADARCH);
		}
	}
	noinherit(fd);

	fd = start_thread(fd);
	if (f_buffered)
		fd = start_buffer(fd);
	if (f_compress)
		fd = start_compress(fd);
	archive = fd;
}

static void
child_status(void)
{
	int status, pid;

	DosWaitThread((ULONG *)&thread_id, DCWW_WAIT);
	while ((pid = wait(&status)) >= 0) {
		char *who = (pid == buffer_pid) ? buffer_args[0] : zip_args[0];
		if (status & 0xFF)
			msg("\"%s\" died of signal %d", who, status & 0x7F);
		else if (status >> 8)
			msg("\"%s\" exit status %d", who, status >> 8);
	}
}

void
child_close(force)
{
	if (force) {
		DosKillThread(thread_id);
		close(ar_reading ? thread_out : thread_in);
		DosKillProcess(DKP_PROCESS, buffer_pid);
		DosKillProcess(DKP_PROCESS, compress_pid);
	}
	child_status();
	rmtclose(ar_reading ? thread_in : thread_out);
	if (thread_errno) {
		errno = thread_errno;
		msg_perror("Thread i/o error");
	}
}

/*----------------------------------------------------------------------*/
/*		Device Interface					*/

#ifdef DYNAMIC

static HMODULE	hmod;
static int	(*rmt_open_p)();

static PFN
getfcn(char *name, PFN def)
{
	ULONG type;
	PFN addr;

	if (DosQueryProcType(hmod, 0, name, &type)
	 || type != 1
	 || DosQueryProcAddr(hmod, 0, name, &addr)) {
	 	if (def)
	 		return def;
		fprintf(stderr, "Failed to bind interface procedure '%s'\n", name);
		exit(EX_SYSTEM);
	}
	return addr;
}

int
open_rmt(char *path, int oflag, int mode)
{
	int bs, fd = rmt_open(strchr(path, ':') + 1, oflag, mode);
	if (fd < 0)
		return fd;
	bs = rmt_block(fd);
	if (bs > 0 && blocksize % bs) {
		msg("The tar blocksize is not a multiple of the tape blocksize");
		exit(EX_ARGSBAD);
	}
	return fd + _RMT_BIAS;
}

void
rmtinit(char *path)
{
	unsigned rc;

	if (strlen(path) > 2 && strchr(path+2, ':')) {
		char *cp, module[100];
		char errbuf[100];

		cp = module;
		*cp++ = 'r';
		*cp++ = 'm';
		*cp++ = 't';
		*cp++ = '_';
		while (*path != ':')
			*cp++ = *path++;
		*cp++ = '\0';

		if (rc = DosLoadModule(errbuf, sizeof errbuf, module, &hmod)) {
			fprintf(stderr, "Cannot load interface DLL %s\n", module);
			fprintf(stderr, "   Failed object: '%s', error code: %u\n", errbuf, rc);
			exit(EX_SYSTEM);
		}

		rmtflag    = 1;
		rmt_open   = (int   (*)()) getfcn("rmt_open",   0);
		rmt_read   = (int   (*)()) getfcn("rmt_read",   (PFN) read);
		rmt_write  = (int   (*)()) getfcn("rmt_write",  (PFN) write);
		rmt_seek   = (long  (*)()) getfcn("rmt_seek",   (PFN) seek);
		rmt_close  = (int   (*)()) getfcn("rmt_close",  0);
		rmt_ioctl  = (int   (*)()) getfcn("rmt_ioctl",  (PFN) def_ioctl);
		rmt_block  = (int   (*)()) getfcn("rmt_block",  (PFN) def_block);
		rmt_error  = (long  (*)()) getfcn("rmt_error",  (PFN) def_error);
		rmt_status = (char *(*)()) getfcn("rmt_status", (PFN) def_status);
	} else {
		rmtflag    = 0;
		rmt_open   = (int   (*)()) open;
		rmt_read   = (int   (*)()) read;
		rmt_write  = (int   (*)()) write;
		rmt_seek   = (long  (*)()) seek;
		rmt_close  = (int   (*)()) close;
		rmt_block  = (int   (*)()) def_block;
		rmt_error  = (long  (*)()) def_error;
		rmt_status = (char *(*)()) def_status;
	}
}

#endif
