/* INSTALL.CMD: Install Hexcalculator. */

'@Echo Off'

/* Set the installed object's title. */

Title = 'HexCalculator'


/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */
 
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing HexCalculator...'
Say ''

Result = SysFileTree( 'HEXCALC.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: HEXCALC.EXE not found!'
  Signal DONE
  End


Result = SysFileTree( 'HEXCALC.HLP', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERROR: HEXCALC.HLP not found!'
  Signal DONE
  End

/* Find the drive for the Default directory */

Drives = SysDriveMap(C,'LOCAL')
   do words(drives)
      parse var drives drive drives
      directory = drive||'\OS2\APPS'
      Result = SysFileTree(Directory,'Dirs','D')
      If Dirs.0 > 0 Then signal ASKDIR  	 
      end

Directory = 'C:\OS2\APPS'

/* Ask for the target directory name. */
ASKDIR: 
Say 'Please enter the full name of the directory to which'
Say 'you want HEXCALC installed (default' Directory '):'
Say 'or type Q to Quit'  
Parse upper pull Direct

if Direct = "Q" Then signal DONE
If Direct > "" Then Directory = Direct

/* Create the target directory if necessary. */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERROR: Unable to create target directory.'
    Signal DONE
    End
  End
Say ''


/* Perform the installation. */

Say 'Copying HEXCALC to ' Directory '...'
Copy "HEXCALC.EXE" Directory                   '1>NUL'
Copy "HEXCALC.HLP" Directory"\HEXCALC.HLP"  '1>NUL'

Say 'Creating program object...'
Type = 'WPProgram'
Folder = '<WP_DESKTOP>'
Parms = "MINWIN=VIEWER;PROGTYPE=PM;EXENAME="Directory"\HEXCALC.EXE;STARTUPDIR="Directory";OBJECTID=<HexCalculator>;NOPRINT=YES;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
 
If Result = 1 Then
  Say 'Object created!  Done.'
Else             
  Say 'ERROR: Object not created.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
