/*

                ***** READ THIS WHOLE SECTION BEFORE USING *****

        I wouldn't want for you to use this software while laboring
        under misconceptions that could lead to a bad end.

    Copyright:

        MADPOP.CMD - Ultra-simple REXX-based POP3 Client for OS/2 2.X,
        Copyright 1994, Michael Alan Dorman.

    Warranty:

        This software comes with absolutely no warranty.  While it was
        not written with destructive intent, Michael Alan Dorman shall
        not be held responsible for any loss or damages of or to
        person or property resulting from the use of this software. 
        Use at your own risk.  You have the source code.

    Distribution:

        There is no restriction on the distribution of this software,
        as long as it is not altered. If you decide that you simply
        must ignore this and change or "enhance" a few things anyway,
        please at least be polite enough to take my name off it and
        change the name of the file so I don't spend time looking at
        questions about someone else's changes.  If you want to send
        me copies of your changes, feel free--I'll certainly look at
        them--but don't expect me to support them.

    Requirements:

        This package requires IBM TCP/IP 2.0 with the REXX Sockets
        (RxSock) interface (which was a separate package until the
        June 1994 CSD).  You are responsible for making sure they are
        installed and working correctly.  You should thank Paul
        Mueller for producing this package in the first place, but
        don't bug him about problems with MADPOP.

    Support:

        This software comes with absolutely no support.  OK, it might
        come with just a little.  Mail me at mdorman@mallet.tiac.net
        (for the moment, not valid after 10/14/94) if you have a
        problem.  If I have an easy answer, I'll almost certainly give
        it to you.  If it requires research on my part, I may do it,
        it depends on whether or not I think the problem you need
        solved might apply to others.  Do not expect any significant
        enhancements to the functionality of this software.

        I know this might seem unkind, but you have to remember that I
        was not (and am not) looking to produce an add-on for another
        mailer--this was a first pass at routines for my shareware
        mailer to use, and I'm releasing them because I like basking
        in the adulation of worshipful users, and I figure it might
        make some people well-disposed to looking at (and maybe paying
        the shareware fee for) my mailer once it's done.  Nothing else.

    Usage:

        Assuming that you've read the above, and haven't been so
        offended as to feel that it is your moral obligation to
        eradicate this program from your HD, here's what you do:

            madpop llama.tdkcs.com mdorman ziggurat

        where 'madpop' is the name of this REXX file, 'llama.tdkcs.com'
        is replaced by the name of your POP3 host, 'mdorman' is
        replaced by the name of your account on the POP3 host, and
        'ziggurat' is replaced by the password for your account on the
        POP3 host.  The program will then retrieve mail from the host
        and leave it in its current directory in files named
        ?????.pop, where the five '?' characters are guaranteed to
        produce an unique filename.

        That's it.  Nothing more.  No fancy 'periodic checks', no
        deleting of mail, no adding to inbox files.  If you're using
        LaMail, you should be able to use the MAKENDX executable found
        in LAMPOP to update the INBOX.NDX file--but I've not even
        tested this (since it would have required installing
        LaMail--which is what I'm writing my own mailer to avoid), so
        I don't know.  Any other mail system (elm, UltiMail) and
        you're on your own, though if you're successful I'd love to
        have a copy of the instructions.

        Anyway, my boss is looking over my shoulder, so I gotta go.

        Mike Dorman, 9/21/94
*/

main:
    parse arg servername username password

    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs

    call RxFuncAdd 'SockLoadFuncs', 'RxSock', 'SockLoadFuncs'
    call SockLoadFuncs

    if SockGetHostByName(servername, 'host.') \= 0 then do
        socket = SockSocket('AF_INET', 'SOCK_STREAM', 0)
        if socket \= -1 then do
            server.family = 'AF_INET'
            server.port = 110
            server.addr = host.addr
            if SockConnect(socket, 'server.') \= -1 then do
                if GetReply(socket) then do
                    call SendLine socket, 'USER ' || username
                    if GetReply(socket) then do
                        call SendLine socket, 'PASS ' || password
                        if GetReply(socket) then do
                            call SendLine socket, 'STAT'
                            if GetReply(socket) then do
                                parse var response.1 status messages octets
                                say 'You have ' || messages || ' messages waiting, ' || octets || ' bytes.'
                                do msgi = 1 to messages
                                    say 'Getting message ' || msgi
                                    call SendLine socket, 'RETR ' || msgi
                                    if GetReply(socket, 1) then do
                                        mailfile = SysTempFileName('?????.mmm')
                                        do line = 2 to response.0
                                            call lineout mailfile, response.line
                                        end
                                    end ; else do
                                        say 'Failed at RETR ' || msgi || ': ' || errno
                                    end
                                end
                            end ; else do
                                say 'Failed at STAT: ' || errno
                            end
                        end ; else do
                            say 'Failed at PASS: ' || errno
                        end
                    end ; else do
                        say 'Failed at USER: ' || errno
                    end
                end ; else do
                    say 'Failed at OPEN: ' || errno
                end
                call SendLine socket, 'QUIT'
            end ; else do
                say 'Failed at Connect: ' || errno
            end
            call SockSoClose socket
        end ; else do
            say 'Failed at Socket: ' || errno
        end
    end ; else do
        say 'Failed at Resolve: ' || errno
    end
exit

GetReply: procedure expose response.
    socket = arg(1)

    response.0 = 1
    response.1 = GetLine(socket)

    if arg(2) = 1 then do
        do forever
            o = response.0 + 1
            response.o = GetLine(socket)
            if (response.o = '.') then do
                leave
            end
            response.0 = o
        end
    end

    if left(response.1, 1) = '+' then do
        return 1
    end
return 0

GetLine: procedure expose lb
    socket = arg(1)

    if symbol('lb') = 'LIT' then do
        lb = ''
    end

    do while pos('0d0a'x, lb) = 0
        rc = SockRecv(socket, 'data', 8000)
        lb = lb || data
    end

    p = pos('0d0a'x,lb)

    line = substr(lb,1,p-1)
    lb = substr(lb,p+2)
return line

SendLine: procedure
    socket = arg(1)
    sent = SockSend(socket, arg(2) || '0d0a'x)

    if (sent <= 0) then do
        say 'Failed at SEND: ' || errno
        call SockSoClose socket
        exit
    end
return 0
