
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/


class DialogShim;

class DialogBase
{
  DialogShim *parts;
  static MRESULT message_handler(HWND, unsigned long, MPARAM, MPARAM);
  MRESULT message(int, MPARAM, MPARAM);
protected:
  HWND window;
  void Register(DialogShim *);
  virtual void dialog_init();
  virtual void cmd_ok();
  virtual void cmd_cancel();
  MRESULT sendmsg_to (int id, int, MPARAM = 0, MPARAM = 0);
public:
  DialogBase();
  void dialog(HWND owner, int resource_id);
};

/* This next class shouldn't be neccessary */
/* I think it is a bug in gcc that causes me to be unable to access */
/* DialogBase::dialog from a user dialog class */
class UserDialogBase: public virtual DialogBase
{
public:
  void dialog(HWND owner, int resource_id)
    { DialogBase::dialog(owner, resource_id); }
};

class DialogShim: public virtual DialogBase
{
  friend DialogBase;
  DialogShim *next;
  virtual MRESULT message(int *accept, int, MPARAM, MPARAM) = 0;
protected:
  const int id;
  MRESULT sendmsg(int, MPARAM = 0, MPARAM = 0);
public:
  DialogShim(int);
};

class EntryField: public DialogShim
{
  virtual MRESULT message(int *accept, int, MPARAM, MPARAM);
protected:
  virtual void change();
public:
  EntryField(int aid);
};

class ComboBox: public DialogShim
{
  virtual MRESULT message(int *accept, int, MPARAM, MPARAM);
protected:
  virtual void efchange();
  virtual void lbselect();
  virtual void enter();
public:

  // List box methods
  int deleteall();
  short deleteitem(short);
  short insertitem(const char *, short);
  short insertitem_atend(const char *);
  short insertitem_sortascending (const char *);
  short insertitem_sortdescending (const char *);
  short queryitemcount();
  unsigned queryitemhandle(short);
  short queryitemtext (short index, short bufsize, char *buf); 
  short queryitemtextlength (short);
  short queryselection(short start_item = LIT_FIRST);
  short querytopindex();
  short searchstring(unsigned short flags, short index, const char *search);
  int selectitem(int, short = TRUE);
  int setitemhandle(short index, unsigned handle);
  int setitemheight(unsigned);
  int setitemtext(short index, const char *txt);
  int settopindex(short);

  // Entry field methods
  char *get_entryfield_text ();
  int set_entryfield_text (const char *newtext);

  ComboBox(int aid);
};

class Button: public DialogShim
{
  virtual MRESULT message(int *accept, int, MPARAM, MPARAM);
protected:
  virtual void clicked();
  virtual void dblclicked();
public:
  Button(int aid);
};

class OK_Button: public Button
{
  virtual void clicked();
protected:
  virtual void ok();
public:
  OK_Button();
};

class Cancel_Button: public Button
{
  virtual void clicked();
protected:
  virtual void cancel();
public:
  Cancel_Button();
};

class CommandMessage: public DialogShim
{
  virtual MRESULT message (int *accept, int, MPARAM, MPARAM);
protected:
  virtual void message (void);
public:
  CommandMessage (int id);
};

class OKMessage: public CommandMessage
{
  virtual void message ();
protected:
  virtual void ok_message ();
  int send_ok_message ();
public:
  OKMessage();
};
