/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <stdio.h>
#include <unistd.h>
#include <ctype.h>
#include "pmio.h"
#define INCL_WIN
#include <os2.h>

/*********************************/
/**** Generic Helper Routines ****/
/*********************************/

void title (const char *t, int anykey)
{
  const char * const msg = "PM/IO Demonstration: ";
  const char * const next = "Press any key to continue";
  int len = strlen (msg) + strlen (t);
  textbackground (WHITE);
  clrscr ();
  textcolor (YELLOW);
  textbackground (BLUE);
  gotoxy (1, 1);
  clreol ();
  gotoxy (40 - len / 2, 1);
  printf ("%s%s", msg, t);

  textcolor (BLACK);
  textbackground (WHITE);
  if (anykey)
    {
      gotoxy (1,2);
      clreol ();
      gotoxy (40 - strlen (next) / 2, 2);
      fputs (next, stdout);
    }
}

void keywait (void)
{
  getch ();
}

/********************************************************/
/**** Color Demo: Show names of all availible colors ****/
/********************************************************/

int color_line;

void showcolor(const char *color_name, int color)
{
  textbackground (color);
  gotoxy (1, color_line++);
  fputs (color_name, stdout);
  clreol ();
  textbackground (WHITE);
}

void test_color (void)
{
  title ("Color Demo", 1);
  textcolor (WHITE);
  color_line = 4;
  delayoutput ();
  showcolor("black", BLACK);
  showcolor("blue", BLUE);
  showcolor("green", GREEN);
  showcolor("cyan", CYAN);
  showcolor("red", RED);
  showcolor("magenta", MAGENTA);
  showcolor("brown", BROWN);
  showcolor("light gray", LIGHTGRAY);
  textcolor (BLACK);
  showcolor("dark gray", DARKGRAY);
  showcolor("light blue", LIGHTBLUE);
  showcolor("light green", LIGHTGREEN);
  showcolor("light cyan", LIGHTCYAN);
  showcolor("light red", LIGHTRED);
  showcolor("light magenta", LIGHTMAGENTA);
  showcolor("yellow", YELLOW);
  showcolor("white", WHITE);
  nodelayoutput ();
  keywait ();
}

/****************************************************************/
/**** Kbhit demo: Demonstrate ability to poll for key events ****/
/****************************************************************/

void test_kbhit (void)
{
  int count = 0;
  title ("Key Detection Demo", 1);
  gotoxy (1, 4);
  fputs ("Seconds waited: ", stdout);
  textcolor (YELLOW);
  textbackground (RED);
  while (!kbhit ())
    {
      gotoxy (17, 4);
      printf ("%d", count++);
      sleep (1);
    }
  getch ();
}

/*************************************************/
/**** Scroll demo: Demonstrate scroll ability ****/
/*************************************************/

void test_scroll (void)
{
  title ("Scroll Demo", 0);
  gotoxy (1, 4);
  fputs ("Press 'u' to scroll up, 'd' to scroll down, 'q' to quit", stdout);
  for (;;)
    switch (getch ())
      {
      case 'u':
	pmio_scroll (1);
	break;
      case 'U':
	pmio_scroll (2);
	break;
      case 'd':
	pmio_scroll (-1);
	break;
      case 'D':
	pmio_scroll (-2);
	break;
      case 'q':
      case 'Q':
	return;
      }
}

/************************************************************************/
/**** Typing demo: Show information about key hits as the user types ****/
/************************************************************************/

/* This routine is huge because it tries to decode *all* the availible
 * information about each key hit into English for printing on-screen
 */

void test_typing ()
{
  struct Event e;
  struct bitnames {
    unsigned short bitpattern;
    const char * const bitname;
  } flagbits[] = {
    { KC_CHAR, "KC_CHAR" },
    { KC_SCANCODE, "KC_SCANCODE" },
    { KC_VIRTUALKEY, "KC_VIRTUALKEY" },
    { KC_KEYUP, "KC_KEYUP" },
    { KC_PREVDOWN, "KC_PREVDOWN" },
    { KC_DEADKEY, "KC_DEADKEY" },
    { KC_COMPOSITE, "KC_COMPOSITE" },
    { KC_INVALIDCOMP, "KC_INVALIDCOMP" },
    { KC_LONEKEY, "KC_LONEKEY" },
    { KC_SHIFT, "KC_SHIFT" },
    { KC_ALT, "KC_ALT" },
    { KC_CTRL, "KC_CTRL" }
  };
  struct bitnames vkbits[] = {
    { VK_BUTTON1, "VK_BUTTON1" },
    { VK_BUTTON2, "VK_BUTTON2" },
    { VK_BUTTON3, "VK_BUTTON3" },
    { VK_BREAK, "VK_BREAK" },
    { VK_BACKSPACE, "VK_BACKSPACE" },
    { VK_TAB, "VK_TAB" },
    { VK_BACKTAB, "VK_BACKTAB" },
    { VK_NEWLINE, "VK_NEWLINE" },
    { VK_SHIFT, "VK_SHIFT" },
    { VK_CTRL, "VK_CTRL" },
    { VK_ALT, "VK_ALT" },
    { VK_ALTGRAF, "VK_ALTGRAF" },
    { VK_PAUSE, "VK_PAUSE" },
    { VK_CAPSLOCK, "VK_CAPSLOCK" },
    { VK_ESC, "VK_ESC" },
    { VK_SPACE, "VK_SPACE" },
    { VK_PAGEUP, "VK_PAGEUP" },
    { VK_PAGEDOWN, "VK_PAGEDOWN" },
    { VK_END, "VK_END" },
    { VK_HOME, "VK_HOME" },
    { VK_LEFT, "VK_LEFT" },
    { VK_UP, "VK_UP" },
    { VK_RIGHT, "VK_RIGHT" },
    { VK_DOWN, "VK_DOWN" },
    { VK_PRINTSCRN, "VK_PRINTSCRN" },
    { VK_INSERT, "VK_INSERT" },
    { VK_DELETE, "VK_DELETE" },
    { VK_SCRLLOCK, "VK_SCRLLOCK" },
    { VK_NUMLOCK, "VK_NUMLOCK" },
    { VK_ENTER, "VK_ENTER" },
    { VK_SYSRQ, "VK_SYSRQ" },
    { VK_F1, "VK_F1" },
    { VK_F2, "VK_F2" },
    { VK_F3, "VK_F3" },
    { VK_F4, "VK_F4" },
    { VK_F5, "VK_F5" },
    { VK_F6, "VK_F6" },
    { VK_F7, "VK_F7" },
    { VK_F8, "VK_F8" },
    { VK_F9, "VK_F9" },
    { VK_F10, "VK_F10" },
    { VK_F11, "VK_F11" },
    { VK_F12, "VK_F12" },
    { VK_F13, "VK_F13" },
    { VK_F14, "VK_F14" },
    { VK_F15, "VK_F15" },
    { VK_F16, "VK_F16" },
    { VK_F17, "VK_F17" },
    { VK_F18, "VK_F18" },
    { VK_F19, "VK_F19" },
    { VK_F20, "VK_F20" },
    { VK_F21, "VK_F21" },
    { VK_F22, "VK_F22" },
    { VK_F23, "VK_F23" },
    { VK_F24, "VK_F24" },
    { VK_ENDDRAG, "VK_ENDDRAG" }
  };
  const char * const function_key_name[256] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    "Shift Tab", /* 15 */
    /* Row 1 of the ALT keyboard... qwerty...p */
    "Alt-Q", "Alt-W", "Alt-E", "Alt-R", "Alt-T", "Alt-Y", "Alt-U", "Alt-I",
    "Alt-O", "Alt-P", 0, 0, 0, 0,
    /* Row 2 of the ALT Keyboard... asdfg...l */
    "Alt-A", "Alt-S", "Alt-D", "Alt-F", "Alt-G",
    "Alt-H", "Alt-J", "Alt-K", "Alt-L", 0, 0, 0, 0, 0,
    /* Row 3 of the ALT Keyboard... zxcv...m */
    "Alt-Z", "Alt-X", "Alt-C", "Alt-V", "Alt-B", "Alt-N", "Alt-M",
    0, 0, 0, 0, 0, 0, 0, 0,
    /* F1 through F10 */
    "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10",
    0, 0,
    /* Misc keys */
    "Home", "Up Arrow", "PgUp", 0, "Left Arrow", 0, "Right Arrow", 0,
    "End", "Down Arrow", "PgDn", "Ins", "Del",
    /* Shift F1 through Shift F10 */
    "Shift-F1", "Shift-F2", "Shift-F3", "Shift-F4", "Shift-F5",
    "Shift-F6", "Shift-F7", "Shift-F8", "Shift-F9", "Shift-F10",
    /* Control F1 through Control F10 */
    "Ctrl-F1", "Ctrl-F2", "Ctrl-F3", "Ctrl-F4", "Ctrl-F5",
    "Ctrl-F6", "Ctrl-F7", "Ctrl-F8", "Ctrl-F9", "Ctrl-F10",
    /* Alt F1 through Control F10 */
    "Alt-F1", "Alt-F2", "Alt-F3", "Alt-F4", "Alt-F5",
    "Alt-F6", "Alt-F7", "Alt-F8", "Alt-F9", "Alt-F10",
    /* Misc */
    "Ctrl-PrtSc", "Ctrl-Left Arrow", "Ctrl-Right Arrow", "Ctrl-End",
    "Ctrl-PgDn", "Ctrl-Home",
    /* Alt-1 through Alt-= */
    "Alt-1", "Alt-2", "Alt-3", "Alt-4", "Alt-5", "Alt-6",
    "Alt-7", "Alt-8", "Alt-9", "Alt-0", "Alt-minus", "Alt-Equal",
    /* Misc */
    "Ctrl-PgUp",
    /* Don't use these keys in real programs -- not everyone has them! */
    "F11", "F12", "Shift-F11", "Shift-F12", "Ctrl-F11", "Ctrl-F12",
    "Alt-F11", "Alt-F12"
  };
  int i;
  int exitflags = 0;
  char c1, c2;
    
  title ("Typing Demo", 0);
  gotoxy (1, 4);
  fputs ("Press ESC twice to exit", stdout);
/*  window (10, 5,  70, 20);*/
  gotoxy (1, 5);
  for (;;)
    {
      /* Get next input event */
      e = getevent ();
      cvt_event (e, &c1, &c2);

      /* Determine if we've seen two ESC keys in a row -- exit if we have */
      if (c1 == 27)
	if (exitflags)
	  break;
	else
	  exitflags = 1;
      else if (! (e.flags & KC_KEYUP))
	exitflags = 0;

      /* Verbosely show what we've got */
      delayoutput (); /* Reduce scrolling and re-writing */
      printf ("flags: %04X = ", e.flags);
      for (i = 0; i < sizeof (flagbits) / sizeof (flagbits[0]); i++)
	if (e.flags & flagbits[i].bitpattern)
	  printf ("%s ", flagbits[i].bitname);
      printf ("\n");
      printf ("  repeat=%d", e.repeat);
      if (e.flags & KC_SCANCODE)
	printf (", scancode=%02X", e.scancode);
      printf (", ch=%02X", (unsigned char) e.ch);
      if (isprint (e.ch))
	printf (" '%c' ", e.ch);
      if (e.flags & KC_VIRTUALKEY)
	{
	  printf (", vk=%02X", e.vk);
	  for (i = 0; i < sizeof (vkbits) / sizeof (vkbits[0]); i++)
	    if (e.vk == vkbits[i].bitpattern)
	      printf (" %s", vkbits[i].bitname);
	}
      printf ("\n");
      if (c1 == -1 && c2 == -1)
	printf ("  getch() ignores this event\n");
      else if (c1 == 0)
	{
	  printf ("  getch() returns function code 0x%02X = %d", 
		  (unsigned char) c2, (unsigned char) c2);
	  if (function_key_name[(unsigned char) c2])
	    {
	      printf (" = ");
	      textbackground (RED);
	      textcolor (YELLOW);
	      printf ("\"%s\"", function_key_name[(unsigned char) c2]);
	      textcolor (BLACK);
	      textbackground (WHITE);
	    }
	  printf ("\n");
	}
      else
	{
	  printf ("  getch() returns character code 0x%02X = %d",
		  (unsigned char) c1, (unsigned char) c1);
	  if (1 <= c1 && c1 <= 26)
	    {
	      printf (" = ");
	      textbackground (RED);
	      textcolor (YELLOW);
	      printf ("\"CTRL-%c\"", 'A' + (c1-1));
	      textcolor (BLACK);
	      textbackground (WHITE);
	    }
	  else if (isprint (c1))
	    {
	      printf (" = ");
	      textbackground (RED);
	      textcolor (YELLOW);
	      printf ("'%c'", c1);
	      textcolor (BLACK);
	      textbackground (WHITE);
	    }
	  else switch (c1)
	    {
	    case 27:
	      printf (" = ");
	      textbackground (RED);
	      textcolor (YELLOW);
	      printf ("ESC");
	      textcolor (BLACK);
	      textbackground (WHITE);
	      break;
	    case 0x7F:
	      printf (" = ");
	      textbackground (RED);
	      textcolor (YELLOW);
	      printf ("RUBOUT");
	      textcolor (BLACK);
	      textbackground (WHITE);
	      break;
	    }
	  printf ("\n");
	}
      nodelayoutput ();
    }
}

/**************/
/**** Main ****/
/**************/

int main()
{
  test_color ();
  test_kbhit ();
  test_scroll ();
  test_typing ();

  return 0;
}
