
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

class StdWin
{
private:
    static StdWin *stdwinlist, *new_window_object;
    StdWin *stdwinlist_next;
    static MRESULT ClientWndProcWhack(HWND, unsigned long, MPARAM, MPARAM);
    MRESULT ClientWndProc(USHORT, MPARAM, MPARAM);
protected:
    HWND frame;
public:
    static HAB hab;
    static HMQ hmq;
    HWND window;

#define MK_MSG(MSG_TYPE, msg_name) \
    virtual MRESULT Msg##msg_name(MPARAM, MPARAM, int *);
#include "msg.h"

#define MK_MSG(MSG_TYPE, msg_name) \
    virtual void DebugMsg##msg_name(MPARAM, MPARAM);
#include "msg.h"

    StdWin(void);
    void Init(HAB, const char *classname, ULONG message_flags, 
	ULONG frame_flags);
    void Destroy(void);

    static void StdStartup();
    static void StdMainLoop();
    static void StdExit();
};

class StdWinPlus: public StdWin
{
#if 0
    // I would like to use this construct - but gcc loses if I do
    typedef class StdWin inherited;
#endif
    // Improved Debugs
    virtual void DebugMsgChar(MPARAM, MPARAM);

    // Improved Messages
    virtual MRESULT MsgPaint(MPARAM, MPARAM, int *);
    virtual MRESULT MsgPaint(int *);

    virtual MRESULT MsgSize(MPARAM, MPARAM, int *);
    virtual MRESULT MsgSize(SHORT scxold, SHORT scyold, 
			    SHORT scxnew, SHORT scynew, int *);

    virtual MRESULT MsgCreate(MPARAM, MPARAM, int *);
    virtual MRESULT MsgCreate(PVOID ctldata, PCREATESTRUCT pCreate, int *);

    virtual MRESULT MsgVscroll(MPARAM, MPARAM, int *);
    virtual MRESULT MsgVscroll(USHORT usidentifier, SHORT sslider, 
			       USHORT uscmd, int *);

    virtual MRESULT MsgButton1Down(MPARAM, MPARAM, int *);
    virtual MRESULT MsgButton1Down(POINTS ptspointerpos, USHORT fshittestres, 
				   USHORT fsflags, int *);

    virtual MRESULT MsgCommand(MPARAM, MPARAM, int *);
    virtual MRESULT MsgCommand(USHORT uscmd, USHORT ussource, USHORT uspointer,
			       int *);

    virtual MRESULT MsgPresParamChanged(MPARAM, MPARAM, int *);
    virtual MRESULT MsgPresParamChanged(ULONG idAttrType, int *);

public:
    StdWinPlus();
};
