#ifndef include_pmio_h
#define include_pmio_h

#ifdef __cplusplus
extern "C" {
#endif

struct text_info
{
  /* Coordinates of current output window within the screen */
  unsigned char winleft;     /* Leftmost column of window */
  unsigned char wintop;      /* Topmost row of window */
  unsigned char winright;    /* Rightmost column of window */
  unsigned char winbottom;   /* Bottomost row of window */
  /* Current attributes for new screen output */
  unsigned char attribute;
  /* Total height and width of screen */
  unsigned char screenheight;
  unsigned char screenwidth;
  /* Current text cursor position within the window */
  unsigned char curx;
  unsigned char cury;
};

void pmio_write (int, const char *);
void pmio_ttywrite (int, const char *);
void pmio_stdiowrite (int, const char *);
void pmio_scroll (int);

void gotoxy (int, int);
void clreol (void);
void clrscr (void);
void textcolor (int);
void textbackground (int);
void gettextinfo (struct text_info *);
void settextinfo (const struct text_info *);
void window (int, int, int, int);

void delayoutput (void);
void nodelayoutput (void);

/* Keyboard events as seen by the window handler */
struct Event
{
  unsigned short flags;  /* Keyboard control codes */
  unsigned char repeat;  /* Repeat cound */
  unsigned char scancode;/* Hardware scan code */
  unsigned short ch;     /* Character code */
  unsigned short vk;     /* Virtual key codes */
};

/* Key event handling procedures */
struct Event getevent (void);
void cvt_event (struct Event, char *, char *);
int kbhit (void);
char getch (void);


/* Colors for textcolor () and textbackground () */

#define BLACK 0
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define LIGHTGRAY 7
#define DARKGRAY 8
#define LIGHTBLUE 9
#define LIGHTGREEN 10
#define LIGHTCYAN 11
#define LIGHTRED 12
#define LIGHTMAGENTA 13
#define YELLOW 14
#define WHITE 15

#ifdef __cplusplus
}
#endif

#endif /* include_pmio_h */
