/*
     Library PMIO: A library for stdio/pcio on a PM screen
     Copyright (C) 1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/
#define INCL_WIN
#include <os2.h>
#include "pmio.h"


void cvt_event (Event e, char *c1, char *c2)
{
#define CH(value) do { if (c1) *c1 = (value); return; } while (0)
#define FN(value) do { if (c2) *c2 = (value); return; } while (0)
#define NOKEY() do { if (c1) *c1 = 255; if (c2) *c2 = 255; return; } while (0)
  if (c1)
    *c1 = 0;
  if (c2)
    *c2 = 0;
  if (e.flags & KC_KEYUP)
    NOKEY ();
  if (e.flags & KC_CHAR)
    {
      if (c1 && /* 0 <= e.ch && */ e.ch <= 255)
	CH ((char) e.ch);
    }
  else if (e.flags & KC_CTRL)
    {
      if (e.flags & KC_VIRTUALKEY)
	switch (e.vk)
	  {
	  case VK_F1: 
	    FN (94);
	  case VK_F2:
	    FN (95);
	  case VK_F3:
	    FN (96);
	  case VK_F4:
	    FN (97);
	  case VK_F5:
	    FN (98);
	  case VK_F6:
	    FN (99);
	  case VK_F7:
	    FN (100);
	  case VK_F8:
	    FN (101);
	  case VK_F9:
	    FN (102);
	  case VK_F10:
	    FN (103);
	  case VK_PRINTSCRN:
	    FN (114);
	  case VK_LEFT:
	    FN (115);
	  case VK_RIGHT:
	    FN (116);
	  case VK_END:
	    FN (117);
	  case VK_PAGEDOWN:
	    FN (118);
	  case VK_HOME:
	    FN (119);
	  case VK_PAGEUP:
	    FN (132);
	  case VK_F11:
	    FN (137);
	  case VK_F12:
	    FN (138);
	  case VK_NEWLINE:
	    CH (10);
	  case VK_BACKSPACE:
	    CH (0x7F);
	  }
      else
	{
	  if ('A' <= e.ch && e.ch <= 'Z')
	    CH (1 + (e.ch - 'A'));
	  else if ('a' <= e.ch && e.ch <= 'z')
	    CH (1 + (e.ch - 'a'));
	  else if (e.ch == '@')
	    CH (0);  /* This obviously doesn't work right, 
			but what is the Right Thing to do here? */
	}
    }
  else if (e.flags & KC_ALT)
    {
      if (e.flags & KC_VIRTUALKEY)
	switch (e.vk)
	  {
	  case VK_F1:
	    FN (104);
	  case VK_F2:
	    FN (105);
	  case VK_F3:
	    FN (106);
	  case VK_F4:
	    FN (107);
	  case VK_F5:
	    FN (108);
	  case VK_F6:
	    FN (109);
	  case VK_F7:
	    FN (110);
	  case VK_F8:
	    FN (111);
	  case VK_F9:
	    FN (112);
	  case VK_F10:
	    FN (113);
	  case VK_F11:
	    FN (139);
	  case VK_F12:
	    FN (140);
	  }
      else
	switch (e.ch)
	  {
	  case 'Q':
	  case 'q':
	    FN (16);
	  case 'W':
	  case 'w':
	    FN (17);
	  case 'E':
	  case 'e':
	    FN (18);
	  case 'R':
	  case 'r':
	    FN (19);
	  case 'T':
	  case 't':
	    FN (20);
	  case 'Y':
	  case 'y':
	    FN (21);
	  case 'U':
	  case 'u':
	    FN (22);
	  case 'I':
	  case 'i':
	    FN (23);
	  case 'O':
	  case 'o':
	    FN (24);
	  case 'P':
	  case 'p':
	    FN (25);
	  case 'A':
	  case 'a':
	    FN (30);
	  case 'S':
	  case 's':
	    FN (31);
	  case 'D':
	  case 'd':
	    FN (32);
	  case 'F':
	  case 'f':
	    FN (33);
	  case 'G':
	  case 'g':
	    FN (34);
	  case 'H':
	  case 'h':
	    FN (35);
	  case 'J':
	  case 'j':
	    FN (36);
	  case 'K':
	  case 'k':
	    FN (37);
	  case 'L':
	  case 'l':
	    FN (38);
	  case 'Z':
	  case 'z':
	    FN (44);
	  case 'X':
	  case 'x':
	    FN (45);
	  case 'C':
	  case 'c':
	    FN (46);
	  case 'V':
	  case 'v':
	    FN (47);
	  case 'B':
	  case 'b':
	    FN (48);
	  case 'N':
	  case 'n':
	    FN (49);
	  case 'M':
	  case 'm':
	    FN (50);
	  case '1':
	    FN (120);
	  case '2':
	    FN (121);
	  case '3':
	    FN (122);
	  case '4':
	    FN (123);
	  case '5':
	    FN (124);
	  case '6':
	    FN (125);
	  case '7':
	    FN (126);
	  case '8':
	    FN (127);
	  case '9':
	    FN (128);
	  case '0':
	    FN (129);
	  case '-':
	    FN (130);
	  case '=':
	    FN (131);
	  }
    }
  else if (e.flags & KC_VIRTUALKEY)
    {
      /* A few vk's need special handling when used with just the
	 shift modifier */
      if (e.flags & KC_SHIFT)
	switch (e.vk)
	  {
	  case VK_F1:
	    FN (84);
	  case VK_F2:
	    FN (85);
	  case VK_F3:
	    FN (86);
	  case VK_F4:
	    FN (87);
	  case VK_F5:
	    FN (88);
	  case VK_F6:
	    FN (89);
	  case VK_F7:
	    FN (90);
	  case VK_F8:
	    FN (91);
	  case VK_F9:
	    FN (92);
	  case VK_F10:
	    FN (93);
	  case VK_F11:
	    FN (133);
	  case VK_F12:
	    FN (134);
	  }
      switch (e.vk)
	{
	case VK_BACKTAB:
	  FN (15);
	case VK_F1:
	  FN (59);
	case VK_F2:
	  FN (60);
	case VK_F3:
	  FN (61);
	case VK_F4:
	  FN (62);
	case VK_F5:
	  FN (63);
	case VK_F6:
	  FN (64);
	case VK_F7:
	  FN (65);
	case VK_F8:
	  FN (66);
	case VK_F9:
	  FN (67);
	case VK_F10:
	  FN (68);
	case VK_HOME:
	  FN (71);
	case VK_UP:
	  FN (72);
	case VK_PAGEUP:
	  FN (73);
	case VK_LEFT:
	  FN (75);
	case VK_RIGHT:
	  FN (77);
	case VK_END:
	  FN (79);
	case VK_DOWN:
	  FN (80);
	case VK_PAGEDOWN:
	  FN (81);
	case VK_INSERT:
	  FN (82);
	case VK_DELETE:
	  FN (83);
	case VK_F11:
	  FN (133);
	case VK_F12:
	  FN (134);
	case VK_TAB:
	  CH ('\t');
	case VK_ESC:
	  CH (27);
	}
    }
  NOKEY ();
}

// DOS Compatibility Functions
static char key;
static enum { key_none, key_character, key_function } keytype = key_none;

static void event_try (void)
{
  while (keytype == key_none
	 && pmio_event_availible ())
    {
      
    }
}

int kbhit (void)
{
  if (event_valid)
    return 1;
  while (pmio_event_availible ())
    {
      PMIOEvent e;
      pmio_get_event (&e);
      pmio_event_convert (
    }
}

char getch (void);
