
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993,1994  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

#include <stdlib.h>
#include <string.h>
#define INCL_GPIPRIMITIVES
#include <os2.h>
#include <ctype.h>
#ifndef NDEBUG
#define NDEBUG
#endif
#include "bugme.h"
#include "attr.h"
#include "view.h"

void View::append(const char *string)
{
    append_allocated(strdup(string));
}

View::~View()
{
}

SimpleView::SimpleView()
    : current_allocation(0),
      current_length(0),
      view(NULL)
{
  BUGME(("SimpleView::SimpleView: Invocation"));
}

int SimpleView::length()
{
    return current_length;
}

const char *SimpleView::line(int line_number)
{
    BUGME(("SimpleView::line(%d)", line_number));
    BUGME(("current_length=%d", current_length));
    if (line_number >= current_length) {
 	BUGME(("Error: line is out of range!!!!!"));
    } else {
 	BUGME(("view[%d]=*%ld=``%s''", line_number, view[line_number],
	       view[line_number]));
    }
    return (line_number >= current_length) ? NULL : view[line_number];
}

void SimpleView::append_allocated(char *new_line)
{
    BUGME(("SimpleView::append_allocated(*%ld=``%s'')", new_line, new_line));
    if (current_allocation == 0) {
	current_allocation = 64;
	view = (char **) malloc(sizeof(char *) * current_allocation);
    }
    while (current_allocation <= current_length+1) {
	current_allocation += 64;
	view = (char **) realloc(view, sizeof(char *) * current_allocation);
    }
    view[current_length++] = new_line;
}

void SimpleView::delete_trailing_blank_lines()
{
  while (current_length > 0) 
    {
      char *p = view[current_length - 1];
      while (isspace(*p))
	p++;
      if (*p != '\0')
	break;
      free (view[current_length - 1]);
      current_length--;
    }
}

SimpleView::~SimpleView()
{
    int i;

    for (i = 0; i < current_length; i++) {
	free(view[i]);
    }
    free(view);
}

StaticView::StaticView(int nlength, const char **nview)
    : view_length(nlength),
      view(nview)
{
}

int StaticView::length()
{
    return view_length;
}

const char *StaticView::line(int line_number)
{
    BUGME(("StaticView::line(%d)", line_number));
    BUGME(("view_length=%d", view_length));
    if (line_number >= view_length) {
 	BUGME(("Error: line is out of range!!!!!"));
    } else {
 	BUGME(("view[%d]=%ld", line_number, view[line_number]));
    }
    return (line_number >= view_length) ? NULL : view[line_number];
}

void StaticView::append_allocated(char *gr)
{
    // Dividing by zero is a good thing to do here
    // [This routine is not applicable to a static view]
    free(gr);
}

