#include "message.h"

@interface MessageList: Object
{
  id item;
  id next;
}
- append: printable;
- initItem: aItem;
- print;
@end

@implementation MessageList
- append: printable
{
  if (next == nil)
    next = [[MessageList alloc] initItem: printable];
  else
    [next append: printable];
  return self;
}
- initItem: aItem
{
  [super init];
  item = aItem;
  return self;
}
- print
{
  [item print];
  [next print];
}
@end

@implementation Message: Object
- init
{
  self = [super init];
  list = nil;
  return self;
}
- append: printable
{
  if (list == nil)
    list = [[MessageList alloc] initItem: printable];
  else
    [list append: printable];
}
- print
{
  if (list != nil)
    [list print];
}
@end
