// Sysbench main file

#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "pmb.h"
#include "pmb_bench.h"
#include "pmb_datatype.h"

#define CLS_CLIENT   "SysBenchWindowClass"
#define SYSB_VER     "0.9.0"
#define THR_DONE     (WM_USER + 1)
#define THR_UPDATE   (WM_USER + 2)
#define START_STACKSIZE 65536
#define DISP_LINES (56+19)
#define MB           (1048576)
#define KB            1024
#define MN            1000000

// ********** IMPORTED FUNCTIONS
extern int pmb_diskio_disksize(int nr);
extern int pmb_diskio_nrdisks(void);
extern void log(char* s);

// ********** EXPORTED FUNCTIONS
void err(char* s);
void InfoBox(char* s);
void WarnBox(char* s);
void ErrorBox(char* s);

// ********** LOCAL FUNCTIONS
static void SetTitle(char* s);
static void  UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue);
static void Print(s32 row, s32 col, char* string, PRECTL pRect, 
                  s32 scrollValue, HPS hpsPaint, s32 color);
static void SetMenuState(bool active);
static void UpdateAll(void);
static void SaveResults(void);
static void PrintFile(s32 newlines, s32 col, char* string, FILE* fp);

MRESULT EXPENTRY ClientWndProc ( HWND hwndWnd,
   ULONG ulMsg,
   MPARAM mpParm1,
   MPARAM mpParm2 );

// ********** EXPORTED DATA
double test_time;
HWND   hwndFrame;
HWND   hwndClient;
HWND   hwndVertScroll;
HWND   hwndMenu;

// ********** LOCAL DATA
static bool thread_running;
static s32  fontW;
static s32  fontH;
static HPS  mainHps;
static HAB         habAnchor;
static s32 scroll = 0;
static s32 oldscroll = 0;

struct glob_data data = {
  1,
  1,
  { 100, 100, 100, 100, 100, 100, 100, 100, 100, 100 },
  {
    { 
      "Graphics", 
      8,
      {
        { "BitBlt S->S cpy",  -1.0, MN, "Mpixels/s" },
        { "BitBlt M->S cpy",  -1.0, MN, "Mpixels/s" },
        { "Filled Rectangle", -1.0, MN, "Mpixels/s" },
        { "Pattern Fill",     -1.0, MN, "Mpixels/s" },
        { "Vertical Lines",   -1.0, MN, "Mpixels/s" },
        { "Horizontal Lines", -1.0, MN, "Mpixels/s" },
        { "Diagonal Lines",   -1.0, MN, "Mpixels/s" },
        { "Text Render",      -1.0, MN, "Mpixels/s" }
      },
      -1.0,
      "PM-marks"
    },
    {
      "CPU integer",
      4,
      {
        { "Dhrystone",      -1.0, MN, "VAX 11/780 MIPS" },
        { "Hanoi",          -1.0, 1, "moves/25 usec" },
        { "Heapsort",       -1.0, MN, "MIPS" },
        { "Sieve",          -1.0, MN, "MIPS" }
      },
      -1.0,
      "CPUint-marks"
    },
    {
      "CPU float",
      3,
      {
        { "Linpack",            -1.0, 1000, "MFLOPS" },
        { "Flops",              -1.0, MN, "MFLOPS" },
        { "Fast Fourier Tr.",   -1.0, 1, "VAX FFT's" }
      },
      -1.0,
      "CPUfloat-marks"
    },
    {
      "Direct Interface to video extensions - DIVE",
      5,
      {
        { "Video bus bandw.",    -1.0, MB, "MB/s" },
        { "DIVE fun",            -1.0, 1, "fps"  },
        { "M->S, DD,   1.00:1",  -1.0, 1, "fps"  },
        { "M->S, DD,   2.00:1",  -1.0, 1, "fps" },
        { "M->S, DD,   2.43:1",  -1.0, 1, "fps" }
      },
      -1.0,
      "DIVE-marks"
    },
    {
      "Disk I/O",
      2,
      {
        { "Average seek time",   -1.0, 1.0e-3, "ms" },
        { "Transfer speed",      -1.0, MB, "MB/s" }
      },
      -1.0,
      "DiskIO-marks"
    },
    {
      "Memory",
      27,
      {
        { "5    kB copy", -1.0, MB, "MB/s" },
        { "10   kB copy", -1.0, MB, "MB/s" },
        { "20   kB copy", -1.0, MB, "MB/s" },
        { "40   kB copy", -1.0, MB, "MB/s" },
        { "80   kB copy", -1.0, MB, "MB/s" },
        { "160  kB copy", -1.0, MB, "MB/s" },
        { "320  kB copy", -1.0, MB, "MB/s" },
        { "640  kB copy", -1.0, MB, "MB/s" },
        { "1280 kB copy", -1.0, MB, "MB/s" },
        { "5    kB read", -1.0, MB, "MB/s" },
        { "10   kB read", -1.0, MB, "MB/s" },
        { "20   kB read", -1.0, MB, "MB/s" },
        { "40   kB read", -1.0, MB, "MB/s" },
        { "80   kB read", -1.0, MB, "MB/s" },
        { "160  kB read", -1.0, MB, "MB/s" },
        { "320  kB read", -1.0, MB, "MB/s" },
        { "640  kB read", -1.0, MB, "MB/s" },
        { "1280 kB read", -1.0, MB, "MB/s" },
        { "5    kB write", -1.0, MB, "MB/s" },
        { "10   kB write", -1.0, MB, "MB/s" },
        { "20   kB write", -1.0, MB, "MB/s" },
        { "40   kB write", -1.0, MB, "MB/s" },
        { "80   kB write", -1.0, MB, "MB/s" },
        { "160  kB write", -1.0, MB, "MB/s" },
        { "320  kB write", -1.0, MB, "MB/s" },
        { "640  kB write", -1.0, MB, "MB/s" },
        { "1280 kB write", -1.0, MB, "MB/s" },
      },
      -1.0,
      "Mem-marks"
    }
  }
};


INT main ( VOID )
{
      FATTRS      fat;
      LONG        match;
      FONTMETRICS fmMetrics ;
  HMQ         hmqQueue;
  ULONG       ulFlags;
  BOOL        bLoop;
  QMSG        qmMsg;
  RECTL       rect;
  s32         x,y,w,h, i;
  MENUITEM    mi;
  HWND        hwndPullDown;
  CHAR        tmp[256];

  habAnchor = WinInitialize ( 0 );
  hmqQueue = WinCreateMsgQueue ( habAnchor, 0 );

  WinRegisterClass ( habAnchor,
                     CLS_CLIENT,
                     ClientWndProc,
                     CS_SYNCPAINT | CS_SIZEREDRAW,
                     0 );

  ulFlags = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MENU |
            FCF_MINMAX | FCF_TASKLIST | FCF_NOBYTEALIGN | FCF_VERTSCROLL;

  hwndFrame = WinCreateStdWindow ( HWND_DESKTOP,
                                   WS_VISIBLE,
                                   &ulFlags,
                                   CLS_CLIENT,
                                   "SysBench " SYSB_VER,
                                   0,
                                   NULLHANDLE,
                                   WND_MAIN,
                                   &hwndClient );

  mainHps = WinGetPS(hwndClient);

  fat.usRecordLength = sizeof(FATTRS); /* sets size of structure   */
  fat.fsSelection = 0;         /* uses default selection           */
  fat.lMatch = 0L;             /* does not force match             */
  fat.idRegistry = 0;          /* uses default registry            */
  fat.usCodePage = 850;        /* code-page 850                    */
  fat.lMaxBaselineExt = 12L;   /* requested font height is 12 pels */
  fat.lAveCharWidth = 8L;     /* requested font width is 12 pels  */
  fat.fsType = 0;              /* uses default type                */
  fat.fsFontUse = FATTR_FONTUSE_NOMIX;/* doesn't mix with graphics */

  strcpy(fat.szFacename ,"System VIO");

  match = GpiCreateLogFont(mainHps,        /* presentation space               */
                           NULL,       /* does not use logical font name   */
                           1L,         /* local identifier                 */
                           &fat);      /* structure with font attributes   */

  // match should now be 2 == FONT_MATCH */

  if (match != 2) {
    log("Can't get the right font");
    exit(1);
  }

  GpiSetCharSet(mainHps, 1L);      /* sets font for presentation space */

  GpiQueryFontMetrics ( mainHps,
                        sizeof ( fmMetrics ) ,
                        &fmMetrics ) ;

  fontH = (14 * fmMetrics.lMaxBaselineExt)/10;
  fontW = fmMetrics.lMaxCharInc;

  GpiSetBackMix( mainHps, BM_OVERPAINT );  // how it mixes,         
  GpiSetMix( mainHps, FM_OVERPAINT );  // how it mixes,         

  hwndVertScroll = WinWindowFromID( hwndFrame, FID_VERTSCROLL);

  WinQueryWindowRect(HWND_DESKTOP, &rect);
  w = 636;
  h = (rect.yTop-rect.yBottom) - 40;
  x = (rect.xRight-rect.xLeft)/2 - w/2;
  y = 40;
  WinSetWindowPos(hwndFrame, false, x, y, w, h, SWP_SIZE | SWP_MOVE | SWP_ACTIVATE);

  WinQueryWindowRect(hwndClient, &rect);

  WinSendMsg( hwndVertScroll,
              SBM_SETSCROLLBAR,
              MPFROMSHORT(0),
              MPFROM2SHORT(0, (DISP_LINES * fontH) - (rect.yTop - rect.yBottom)));

  WinSendMsg( hwndVertScroll,
              SBM_SETTHUMBSIZE,
              MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
              NULL);

  SetTitle("Ready");

  thread_running = false;


  data.nr_fixed_disks = pmb_diskio_nrdisks();
  if (data.nr_fixed_disks > MAX_FIXED_DISKS) {
    log("Number of fixed disks is too high");
    exit(1);
  }

  for (i = 0; i < data.nr_fixed_disks; i++) {
    data.fixed_disk_size[i] = pmb_diskio_disksize(i);
    sprintf(tmp, "Disk %d: %d MB", i+1, data.fixed_disk_size[i]/(1000*1000));
    hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);
    WinSendMsg(hwndMenu, MM_QUERYITEM, MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE), 
               (MPARAM) &mi);  
    hwndPullDown = mi.hwndSubMenu;
    mi.iPosition = MIT_END;
    mi.afStyle = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id = MI_MENU_DISKIO_SELECT+1+i;
    mi.hwndSubMenu = null;
    mi.hItem = 0;
    WinSendMsg(hwndPullDown, MM_INSERTITEM, (MPARAM) &mi,
               (MPARAM)tmp);
  }

  if (!data.nr_fixed_disks) {
    hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);
    WinSendMsg(hwndMenu, MM_QUERYITEM, MPFROM2SHORT(MI_MENU_DISKIO_SELECT, TRUE), 
               (MPARAM) &mi);  
    hwndPullDown = mi.hwndSubMenu;
    mi.iPosition = MIT_END;
    mi.afStyle = MIS_TEXT;
    mi.afAttribute = 0;
    mi.id = MI_MENU_DISKIO_SELECT+1;
    mi.hwndSubMenu = null;
    mi.hItem = 0;
    WinSendMsg(hwndPullDown, MM_INSERTITEM, (MPARAM) &mi,
               (MPARAM)"No fixed disks found");

    WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, false);
  } else {
    hwndMenu = WinWindowFromID(hwndFrame, FID_MENU);
    WinCheckMenuItem(hwndMenu, MI_MENU_DISKIO_SELECT + 1, true);
    data.selected_disk = 0;
    sprintf(data.c[comp_disk].title, "Disk I/O - disk %d: %d MB", data.selected_disk+1, data.fixed_disk_size[data.selected_disk]/(1000*1000));
  }

  WinEnableMenuItem(hwndMenu, MI_MENU_DIVE, false);

  UpdateAll();

  if ( hwndFrame != NULLHANDLE ) {
    bLoop = WinGetMsg ( habAnchor,
                        &qmMsg,
                        NULLHANDLE,
                        0,
                        0 );
    while ( bLoop ) {
       WinDispatchMsg ( habAnchor, &qmMsg );
       bLoop = WinGetMsg ( habAnchor,
                           &qmMsg,
                           NULLHANDLE,
                           0,
                           0 );
    }

    WinReleasePS(mainHps);
    WinDestroyWindow ( hwndFrame );
  }

  WinDestroyMsgQueue ( hmqQueue );
  WinTerminate ( habAnchor );
  return 0;
}

MRESULT EXPENTRY ClientWndProc ( HWND hwndWnd,
                                 ULONG ulMsg,
                                 MPARAM mpParm1,
                                 MPARAM mpParm2 )
{
  void *pv = null;
  static bool initialized = false;
  RECTL rect;
  s32 tmp;
  bool updateScroll;
  QMSG qmsgPeek;
  bool fDone;
  char tmps[256];

  switch ( ulMsg ) {

  case WM_COMMAND:

    if (thread_running) {
      switch (SHORT1FROMMP(mpParm1)) {
      case MI_PROJ_QUIT:
        WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
        break;
      case MI_PROJ_ABOUT:
        InfoBox("SysBench "SYSB_VER" by Henrik Harmsen 1994-10-01.\nEmail: harmsen@eritel.se\n"
                "Thanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
        break;
      }
      return false;
    }

    if ((SHORT1FROMMP(mpParm1) > MI_MENU_DISKIO_SELECT) && 
        (SHORT1FROMMP(mpParm1) <= (data.nr_fixed_disks + MI_MENU_DISKIO_SELECT))) {
      s32 i, disk;
      disk = SHORT1FROMMP(mpParm1) - (MI_MENU_DISKIO_SELECT + 1);
      if (disk == data.selected_disk) 
        return false;
      data.selected_disk = disk;
      for (i = 0; i < data.nr_fixed_disks; i++) {
        WinCheckMenuItem(hwndMenu, MI_MENU_DISKIO_SELECT + i + 1, false);
      }
      WinCheckMenuItem(hwndMenu, MI_MENU_DISKIO_SELECT + data.selected_disk + 1, true);
      sprintf(data.c[comp_disk].title, "Disk I/O - disk %d: %d MB", data.selected_disk+1, data.fixed_disk_size[data.selected_disk]/(1000*1000));
      data.c[comp_disk].datalines[disk_avseek].value = -1.0;
      data.c[comp_disk].datalines[disk_transf].value = -1.0;
      data.c[comp_disk].total = -1.0;
      UpdateAll();
      return false;
    }

    switch (SHORT1FROMMP(mpParm1)) {
    case MI_PROJ_QUIT:
      WinPostMsg(hwndWnd, WM_CLOSE, NULL, NULL);
      break;
    case MI_PROJ_ABOUT:
        InfoBox("SysBench "SYSB_VER" by Henrik Harmsen 1994-10-01.\nEmail: harmsen@eritel.se\n"
                "\nThanks to Kai Uwe Rommel for the disk IO tests, and Al Aburto for the CPU tests.");
      break;
    case MI_PROJ_SAVE:
      SaveResults();
      break;
    case MI_PROJ_ALL:
      SetTitle("Running All tests");
      SetMenuState(false);
      _beginthread(DoAll, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_BITBLIT_SS:
      SetTitle("Running BitBlit S->S");
      SetMenuState(false);
      _beginthread(DoGfxBlitBlitSS, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_BITBLIT_MS:
      SetTitle("Running BitBlit M->S");
      SetMenuState(false);
      _beginthread(DoGfxBlitBlitMS, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_FILLRECT:
      SetTitle("Running Filled Rectangle");
      SetMenuState(false);
      _beginthread(DoGfxFillRect, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_PATFIL:
      SetTitle("Running Pattern Fill");
      SetMenuState(false);
      _beginthread(DoGfxPatFil, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_VLINES:
      SetTitle("Running VerticalLines");
      SetMenuState(false);
      _beginthread(DoGfxVLines, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_HLINES:
      SetTitle("Running HorizontalLines");
      SetMenuState(false);
      _beginthread(DoGfxHLines, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_DLINES:
      SetTitle("Running DiagonalLines");
      SetMenuState(false);
      _beginthread(DoGfxDLines, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_TEXTRENDER:
      SetTitle("Running TextRender");
      SetMenuState(false);
      _beginthread(DoGfxTextRender, null, START_STACKSIZE, pv);
      break;
    case MI_GFX_ALL:
      SetTitle("Running All Graphics tests");
      SetMenuState(false);
      _beginthread(DoAllGraphics, null, START_STACKSIZE, pv);
      break;
    case MI_CPUINT_DHRY:
      SetTitle("Running Dhrystone");
      SetMenuState(false);
      _beginthread(DoCPUIntDhry, null, START_STACKSIZE, pv);
      break;
    case MI_CPUINT_HANOI:
      SetTitle("Running Hanoi");
      SetMenuState(false);
      _beginthread(DoCPUIntHanoi, null, START_STACKSIZE, pv);
      break;
    case MI_CPUINT_HEAPS:
      SetTitle("Running Heapsort");
      SetMenuState(false);
      _beginthread(DoCPUIntHeaps, null, START_STACKSIZE, pv);
      break;
    case MI_CPUINT_SIEVE:
      SetTitle("Running Sieve");
      SetMenuState(false);
      _beginthread(DoCPUIntSieve, null, START_STACKSIZE, pv);
      break;
    case MI_CPUINT_ALL:
      SetTitle("Running All CPU integer tests");
      SetMenuState(false);
      _beginthread(DoAllCPUInt, null, START_STACKSIZE, pv);
      break;
    case MI_CPUFLOAT_LINPACK:
      SetTitle("Running Linpack");
      SetMenuState(false);
      _beginthread(DoCPUFloatLinpack, null, START_STACKSIZE, pv);
      break;
    case MI_CPUFLOAT_FLOPS:
      SetTitle("Running FLOPS");
      SetMenuState(false);
      _beginthread(DoCPUFloatFlops, null, START_STACKSIZE, pv);
      break;
    case MI_CPUFLOAT_FFT:
      SetTitle("Running FFT");
      SetMenuState(false);
      _beginthread(DoCPUFloatFFT, null, START_STACKSIZE, pv);
      break;
    case MI_CPUFLOAT_ALL:
      SetTitle("Running All CPU float tests");
      SetMenuState(false);
      _beginthread(DoAllCPUFloat, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_5:
      SetTitle("Running Memcopy 5kB");
      SetMenuState(false);
      _beginthread(DoMem5, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_10:
      SetTitle("Running Memcopy 10kB");
      SetMenuState(false);
      _beginthread(DoMem10, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_20:
      SetTitle("Running Memcopy 20kB");
      SetMenuState(false);
      _beginthread(DoMem20, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_40:
      SetTitle("Running Memcopy 40kB");
      SetMenuState(false);
      _beginthread(DoMem40, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_80:
      SetTitle("Running Memcopy 80kB");
      SetMenuState(false);
      _beginthread(DoMem80, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_160:
      SetTitle("Running Memcopy 160kB");
      SetMenuState(false);
      _beginthread(DoMem160, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_320:
      SetTitle("Running Memcopy 320kB");
      SetMenuState(false);
      _beginthread(DoMem320, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_640:
      SetTitle("Running Memcopy 640kB");
      SetMenuState(false);
      _beginthread(DoMem640, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_1280:
      SetTitle("Running Memcopy 1280kB");
      SetMenuState(false);
      _beginthread(DoMem1280, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_5:
      SetTitle("Running Memory Read 5kB");
      SetMenuState(false);
      _beginthread(DoMemR5, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_10:
      SetTitle("Running Memory Read 10kB");
      SetMenuState(false);
      _beginthread(DoMemR10, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_20:
      SetTitle("Running Memory Read 20kB");
      SetMenuState(false);
      _beginthread(DoMemR20, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_40:
      SetTitle("Running Memory Read 40kB");
      SetMenuState(false);
      _beginthread(DoMemR40, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_80:
      SetTitle("Running Memory Read 80kB");
      SetMenuState(false);
      _beginthread(DoMemR80, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_160:
      SetTitle("Running Memory Read 160kB");
      SetMenuState(false);
      _beginthread(DoMemR160, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_320:
      SetTitle("Running Memory Read 320kB");
      SetMenuState(false);
      _beginthread(DoMemR320, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_640:
      SetTitle("Running Memory Read 640kB");
      SetMenuState(false);
      _beginthread(DoMemR640, null, START_STACKSIZE, pv);
      break;
    case MI_MEMR_1280:
      SetTitle("Running Memory Read 1280kB");
      SetMenuState(false);
      _beginthread(DoMemR1280, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_5:
      SetTitle("Running Memory Write 5kB");
      SetMenuState(false);
      _beginthread(DoMemW5, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_10:
      SetTitle("Running Memory Write 10kB");
      SetMenuState(false);
      _beginthread(DoMemW10, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_20:
      SetTitle("Running Memory Write 20kB");
      SetMenuState(false);
      _beginthread(DoMemW20, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_40:
      SetTitle("Running Memory Write 40kB");
      SetMenuState(false);
      _beginthread(DoMemW40, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_80:
      SetTitle("Running Memory Write 80kB");
      SetMenuState(false);
      _beginthread(DoMemW80, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_160:
      SetTitle("Running Memory Write 160kB");
      SetMenuState(false);
      _beginthread(DoMemW160, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_320:
      SetTitle("Running Memory Write 320kB");
      SetMenuState(false);
      _beginthread(DoMemW320, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_640:
      SetTitle("Running Memory Write 640kB");
      SetMenuState(false);
      _beginthread(DoMemW640, null, START_STACKSIZE, pv);
      break;
    case MI_MEMW_1280:
      SetTitle("Running Memory Write 1280kB");
      SetMenuState(false);
      _beginthread(DoMemW1280, null, START_STACKSIZE, pv);
      break;
    case MI_MEM_ALL:
      SetTitle("Running All Memory tests");
      SetMenuState(false);
      _beginthread(DoAllMem, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_VIDEO_BW:
      SetTitle("Running Video Bandwidth");
      SetMenuState(false);
      _beginthread(DoDiveVBW, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_ROTATE_SCREEN:
      SetTitle("Running DIVE fun");
      SetMenuState(false);
      _beginthread(DoDiveRot, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_MS_11:
      SetTitle("Running DIVE M->S 1:1");
      SetMenuState(false);
      _beginthread(DoDiveMS11, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_MS_12:
      SetTitle("Running DIVE M->S 2:1");
      SetMenuState(false);
      _beginthread(DoDiveMS12, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_MS_125:
      SetTitle("Running DIVE M->S 2.43:1");
      SetMenuState(false);
      _beginthread(DoDiveMS125, null, START_STACKSIZE, pv);
      break;
    case MI_DIVE_ALL:
      SetTitle("Running All DIVE tests");
      SetMenuState(false);
      _beginthread(DoAllDIVE, null, START_STACKSIZE, pv);
      break;
    case MI_DISKIO_AVSEEK:
      SetTitle("Running Average Seek Time");
      SetMenuState(false);
      _beginthread(DoDiskIOAvSeek, null, START_STACKSIZE, pv);
      break;
    case MI_DISKIO_TRANS_SPEED:
      SetTitle("Running Max. transfer speed");
      SetMenuState(false);
      _beginthread(DoDiskIOTransSpeed, null, START_STACKSIZE, pv);
      break;
    case MI_DISKIO_ALL:
      SetTitle("Running All disk IO tests");
      SetMenuState(false);
      _beginthread(DoAllDiskIO, null, START_STACKSIZE, pv);
      break;
    }
    break;

  case WM_PAINT:
    {
      FATTRS      fat;
      LONG        match;
      FONTMETRICS fmMetrics ;
      HPS               hpsPaint ;
      RECTL             rclRect ;
      RECTL             rclWindow ;
      ULONG             ulCharHeight ;
      HWND              hwndEnum ;
      HWND              hwndFrame ;
      HENUM             heEnum ;
      POINTL            point;
      HRGN              newHrgn, oldHrgn, dummy;
      s32               complexity;
      RECTL             clipRect;

      if (!initialized) {
        initialized = true;
      }

      hpsPaint = WinBeginPaint ( hwndWnd,
                                 NULLHANDLE,
                                 &rclRect ) ;

// This should work, but there was a bug in Warp II
//      newHrgn = GpiQueryClipRegion(hpsPaint);
//      complexity = GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
//      WinEndPaint(hpsPaint);

      GpiQueryClipBox(hpsPaint, &clipRect);
      clipRect.xRight++;
      clipRect.yTop++;
      newHrgn = GpiCreateRegion(mainHps, 1, &clipRect);
      GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
      if (NULLHANDLE != oldHrgn) {
        GpiDestroyRegion(mainHps, oldHrgn);
      }

      WinFillRect(mainHps, &rclRect, CLR_BLACK);

      WinQueryWindowRect ( hwndWnd, &rclWindow );
      UpdateWindow(mainHps,
                   &rclWindow,
                   scroll);

      oldscroll = scroll;
      WinEndPaint(hpsPaint);
    }
    break;

  case THR_DONE:
    SetTitle("Ready");
    SetMenuState(true);
    thread_running = false;
    break;

  case THR_UPDATE:
    UpdateAll();
    break;

  case WM_SIZE:
    { 
      s32 tmp;

      WinQueryWindowRect(hwndClient, &rect);

      tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);

      if (tmp < 0) tmp = 0;
      if (scroll > tmp) scroll = tmp;

      WinSendMsg( hwndVertScroll,
                  SBM_SETSCROLLBAR,
                  MPFROMSHORT(scroll),
                  MPFROM2SHORT(0, tmp));

      WinSendMsg( hwndVertScroll,
                  SBM_SETTHUMBSIZE,
                  MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
                  NULL);

    }
    break;

  case WM_VSCROLL:
    updateScroll = false;
    WinQueryWindowRect(hwndClient, &rect);
    switch( SHORT2FROMMP( mpParm2) )
    {
    case SB_LINEUP:
      scroll -= fontH;
      updateScroll = true;;
      break;
    case SB_LINEDOWN:
      scroll += fontH;
      updateScroll = true;;
      break;
    case SB_PAGEUP:
      scroll -= rect.yTop-rect.yBottom;
      updateScroll = true;;
      break;
    case SB_PAGEDOWN:
      scroll += rect.yTop-rect.yBottom;
      updateScroll = true;;
      break;
    case SB_SLIDERTRACK:
    case SB_SLIDERPOSITION:
      scroll = SHORT1FROMMP( mpParm2);
               /*(USHORT) WinSendMsg(hwndVertScroll,
                SBM_QUERYPOS, (MPARAM) NULL, (MPARAM) NULL);*/
      break;
    case SB_ENDSCROLL:
      break;
    default:
      break;
    }

    if (updateScroll) {
      WinQueryWindowRect(hwndClient, &rect);
      tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);
      if (tmp < 0) tmp = 0;
      if (scroll > tmp) scroll = tmp;
      WinSendMsg( hwndVertScroll,
                  SBM_SETSCROLLBAR,
                  MPFROMSHORT(scroll),
                  MPFROM2SHORT(0, tmp));
      WinSendMsg( hwndVertScroll,
                  SBM_SETTHUMBSIZE,
                  MPFROM2SHORT(rect.yTop - rect.yBottom, DISP_LINES * fontH),
                  NULL);
    }

    tmp = DISP_LINES * fontH - (rect.yTop - rect.yBottom);
    if (scroll > tmp) scroll = tmp;
    if (scroll < 0) scroll = 0;

    WinScrollWindow(hwndClient, 0, scroll-oldscroll, NULL, NULL, NULLHANDLE, NULL, SW_INVALIDATERGN);
    break;

  case WM_ERASEBACKGROUND:
    return MRFROMSHORT ( false );  // No, we'll do this ourselves

  default:
    return WinDefWindowProc ( hwndWnd,
                              ulMsg,
                              mpParm1,
                              mpParm2 );
  }

  return MRFROMSHORT ( FALSE );
}

void 
PostFin(int onlyupdate) {
  if (onlyupdate) {
    WinPostMsg(hwndClient, THR_UPDATE, NULL, NULL);
  } else {
    WinPostMsg(hwndClient, THR_DONE, NULL, NULL);
  }
}

void err(char* s) {
  log(s);
  ErrorBox(s);
  exit(1);
}

void warn(char* s) {
  WarnBox(s);
}

static void 
SetTitle(char* s) {
  char tmp[100];
  sprintf(tmp, "SysBench %s - %s", SYSB_VER, s);
  WinSetWindowText(hwndFrame, tmp);
}

static void 
UpdateWindow(HPS hpsPaint, PRECTL pRect, s32 scrollValue) {
  static char tmp[256];
  s32 i, comp;
  s32 line = 0;

  // print header

  line++;
//  line++;

  for (comp = 0; comp < NUM_COMPONENTS; comp++) {
    // print title
    Print(line, 1, data.c[comp].title, pRect, scrollValue, hpsPaint, CLR_GREEN);
    line++;
    // print lines of data
    for (i = 0; i < data.c[comp].ndatalines; i++) {
      if (data.c[comp].datalines[i].value < 0.0)
        sprintf(tmp, "%-21s :       --.---    %s", data.c[comp].datalines[i].entry, 
                data.c[comp].datalines[i].unit);
      else
        sprintf(tmp, "%-21s : %12.3f    %s", data.c[comp].datalines[i].entry, 
                data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val, 
                data.c[comp].datalines[i].unit);
      Print(line, 3, tmp, pRect, scrollValue, hpsPaint, CLR_WHITE);
      line++;
    }
    Print(line, 3, "", pRect, scrollValue, hpsPaint, CLR_PALEGRAY);
    line++;
    if (data.c[comp].total < 0.0)
      sprintf(tmp, "Total                 :       --.---    %s", 
              data.c[comp].unit_total);
    else
      sprintf(tmp, "Total                 : %12.3f    %s", data.c[comp].total, 
              data.c[comp].unit_total);
    Print(line, 3, tmp, pRect, scrollValue, hpsPaint, CLR_YELLOW);
    line++;
    line++;
  }
}

static void
Print(s32 row, s32 col, char* string, PRECTL pRect, s32 scrollValue, HPS hpsPaint, s32 color) {
  RECTL printRect;

  printRect.xLeft = col * fontW;
  printRect.xRight = pRect->xRight;
  printRect.yTop = pRect->yTop - row * fontH + scrollValue;
  printRect.yBottom = printRect.yTop - fontH;

  WinDrawText(hpsPaint, -1, (PCH)string, &printRect, color, CLR_BLACK, DT_TOP | DT_LEFT);
}

static void
PrintFile(s32 newlines, s32 col, char* string, FILE* fp) {
  s32 i;
  for (i = 0; i < col; i++)
    fprintf(fp, " ");

  fprintf(fp, "%s", string);

  for (i = 0; i < newlines; i++)
    fprintf(fp, "\n");
}

void
InfoBox(char* s) {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Info",
                WND_MESSAGEB,
                MB_OK | MB_INFORMATION | MB_APPLMODAL | MB_MOVEABLE);
}


void
ErrorBox(char* s) {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Error !",
                WND_MESSAGEB,
                MB_OK | MB_ERROR | MB_APPLMODAL | MB_MOVEABLE);
}


void
WarnBox(char* s) {
  WinMessageBox(HWND_DESKTOP,
                hwndFrame,
                s,
                "Warning !",
                WND_MESSAGEB,
                MB_OK | MB_WARNING | MB_APPLMODAL | MB_MOVEABLE);
}

void
UpdateAll(void) {
  RECTL rclWindow, cliprect;
  HRGN  newHrgn, oldHrgn, dummy;
  s32 i, comp;
  bool calcav = true;


  // calculate averages
  for (comp = 0; comp < NUM_COMPONENTS; comp++) {
    calcav = true;
    for (i = 0; i < data.c[comp].ndatalines; i++) {
      calcav = calcav && (data.c[comp].datalines[i].value >= 0.0);
    }
    if (!calcav)
      continue;
    switch (comp) {
    case comp_gfx:
      data.c[comp_gfx].total = CalcGfxAv();
      break;
    case comp_cpuint:
      data.c[comp_cpuint].total = CalcCPUIntAv();
      break;
    case comp_cpufloat:
      data.c[comp_cpufloat].total = CalcCPUFloatAv();
      break;
    case comp_mem:
      data.c[comp_mem].total = CalcMemAv();
      break;
    case comp_dive:
      data.c[comp_dive].total = CalcDIVEAv();
      break;
    case comp_disk:
      data.c[comp_disk].total = CalcDiskIOAv();
      break;
    }
  }

  // update screen
  WinQueryWindowRect ( hwndClient, &rclWindow ); // update whole window
  cliprect.xLeft = rclWindow.xLeft;
  cliprect.xRight = rclWindow.xRight+1;
  cliprect.yBottom = rclWindow.yBottom;
  cliprect.yTop = rclWindow.yTop+1;
  newHrgn = GpiCreateRegion(mainHps, 1, &cliprect);
  GpiSetClipRegion(mainHps, newHrgn, &oldHrgn);
  if (NULLHANDLE != oldHrgn)
    GpiDestroyRegion(mainHps, oldHrgn);
  UpdateWindow(mainHps, &rclWindow, scroll);
  oldscroll = scroll;
}

static void SetMenuState(bool active) { // if active == true => all items enabled
                                        // otherw. all items but the about and close are disabled
  WinEnableMenuItem(hwndMenu, MI_PROJ_SAVE, active);
  WinEnableMenuItem(hwndMenu, MI_PROJ_ALL, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_GFX, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUINT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_CPUFLOAT, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_MEM, active);
  WinEnableMenuItem(hwndMenu, MI_MENU_DIVE, false);
  if (data.nr_fixed_disks)
    WinEnableMenuItem(hwndMenu, MI_MENU_DISKIO, active);
}


static void SaveResults(void) {
  FILE* fp;
  static char tmp[256];
  s32 i, comp;
  struct tm *newtime;
  time_t ltime;



  // print header

  fp = fopen("result.txt", "wb");
  if (!fp) {
    WarnBox("Cannot open file result.txt for output");
    return;
  }

  time(&ltime);
  newtime = localtime(&ltime);
  fprintf(fp, "\n\nSysbench " SYSB_VER " result file created %s\n\n", asctime(newtime));

  for (comp = 0; comp < NUM_COMPONENTS; comp++) {
    // print title
    PrintFile(1, 1, data.c[comp].title, fp);
    // print lines of data
    for (i = 0; i < data.c[comp].ndatalines; i++) {
      if (data.c[comp].datalines[i].value < 0.0)
        sprintf(tmp, "%-21s :       --.---    %s", data.c[comp].datalines[i].entry, 
                data.c[comp].datalines[i].unit);
      else
        sprintf(tmp, "%-21s : %12.3f    %s", data.c[comp].datalines[i].entry, 
                data.c[comp].datalines[i].value / data.c[comp].datalines[i].unit_val, 
                data.c[comp].datalines[i].unit);
      PrintFile(1, 3, tmp, fp);
    }
//  PrintFile(1, 3, "", fp);
    PrintFile(1, 3, "------------------------------------------------------------", fp);
    if (data.c[comp].total < 0.0)
      sprintf(tmp, "Total                 :       --.---    %s", 
              data.c[comp].unit_total);
    else
      sprintf(tmp, "Total                 : %12.3f    %s", data.c[comp].total, 
              data.c[comp].unit_total);
    PrintFile(2, 3, tmp, fp);
  }

  fclose(fp);
  InfoBox("Result file saved as result.txt");
}


