
#define INCL_DOSSEMAPHORES
#define INCL_DOSERRORS
#include <os2.h>
#include "eventq.h"

class ActualPMIOEventQ: public PMIOEventQ
{
  const unsigned q_size;
  unsigned q_head, q_tail, q_len;
  HEV q_event_semaphore;
  HMTX q_mutex_semaphore;
  PMIOEvent * const q;
  virtual void nonblocking_insert (const PMIOEvent *);
  virtual void blocking_remove (PMIOEvent *);
  virtual int event_availible ();
public:
  ActualPMIOEventQ (unsigned size);
};

void ActualPMIOEventQ::nonblocking_insert (const PMIOEvent *e)
{
  int rc;
  // Obtain mutex access
  do
    rc = DosRequestMutexSem (q_mutex_semaphore,
			     (unsigned) SEM_INDEFINITE_WAIT);
  while (rc == ERROR_INTERRUPT);
  // Insert
  if (q_len < q_size)
    {
      q[q_head] = *e;
      q_len++;
      if (++q_head >= q_size)
	q_head = 0;
    }
  // Unblock anyone waiting for this to happen
  DosPostEventSem (q_event_semaphore);
  // Release mutex access
  DosReleaseMutexSem (q_mutex_semaphore);
}

void ActualPMIOEventQ::blocking_remove (PMIOEvent *e)
{
  // Clear the event semaphore
  unsigned long foo;
  DosResetEventSem (q_event_semaphore, &foo);

  int rc;
  for (;;)
    {
      // Get mutex
      do
	rc = DosRequestMutexSem (q_mutex_semaphore,
				 (unsigned) SEM_INDEFINITE_WAIT);
      while (rc == ERROR_INTERRUPT);
      // Get the length of the queue
      unsigned len = q_len;
      // If there is something in the queue, dequeue it
      if (len > 0)
	{
	  *e = q[q_tail];
	  q_len--;
	  if (++q_tail >= q_size)
	    q_tail = 0;
	}
      // Release the mutex
      DosReleaseMutexSem (q_mutex_semaphore);
      // If we got something, we're done
      if (len > 0)
	break;
      // Otherwise, wait for an event to come in
      DosWaitEventSem (q_event_semaphore, (unsigned) SEM_INDEFINITE_WAIT);
    }
}

int ActualPMIOEventQ::event_availible ()
{
  // Get mutex
  int rc;
  do
    rc = DosRequestMutexSem (q_mutex_semaphore,
			     (unsigned) SEM_INDEFINITE_WAIT);
  while (rc == ERROR_INTERRUPT);
  // Get the length of the queue
  unsigned len = q_len;
  // Release the mutex
  DosReleaseMutexSem (q_mutex_semaphore);
  // return the result
  return len > 0;
}
  
ActualPMIOEventQ::ActualPMIOEventQ (unsigned size)
: q_size (size),
  q_head (0),
  q_tail (0),
  q_len (0),
  q (new PMIOEvent[size])
{
  DosCreateEventSem (0, &q_event_semaphore, 0, 0);
  DosCreateMutexSem (0, &q_mutex_semaphore, 0, 0);
}

PMIOEventQ *pmio_make_eventq (unsigned size)
{
  return new ActualPMIOEventQ (size);
}
