#ifndef include_textwin_h
#define include_textwin_h

class TextWindow
{
private:
  // Size of whole screen
  int screen_width, screen_height;
  // Size of current viewport within the screen
  int window_width, window_height;
  // Position of current viewport
  int window_x_offset, window_y_offset;
  // Cursor position in the range (0,0) thru (window_width-1, window_height-1)
  int cx, cy;
  // Current attribute
  unsigned char text_attr;
  // Current window content 
  char *current_text;
  unsigned char *current_attr;
  char *current_dirt;

  // Hack to create a namespace of functions which can access the internals
  // of a TextWindow Object.  Used in the implementation of this class.
  friend class TextWindowAux;
  
protected:
  // A hook so that a derived class can implement scroll "directly" if
  // there is a way to implement it faster than repainting all the lines
  // in a scrolled region.  Method should return non-zero if the scroll
  // was implemented.
  virtual int scroll_region_draw (int scroll_distance,
				  int x1, int y1, int x2, int y2);

  // Accessing the cursor position relative to the screen rather than
  // the window.  This is useful for derived classes that want to
  // draw something special to indicate the current cursor position
  int get_screen_x () const;
  int get_screen_y () const;
  
public:
  TextWindow (int init_width = 80, int init_height = 25);

  // Functions for configuring the window shape
  void set_screen_size (int width, int height);
  void set_width (int width);
  void set_height (int height);
  int get_screen_width () const;
  int get_screen_height () const;

  // Functions for setting the current text colors
  void set_attr (unsigned char attr);
  void set_fg (unsigned char fg_color);
  void set_bg (unsigned char bg_color);

  // Functions associated with the current text insertion position
  int getx () const;
  int gety () const;
  void gotoxy (int x, int y);

  // Functions for drawing text at the current position
  void put_raw (int len, const char *text);
  void put_tty (int len, const char *text);
  void put_std (int len, const char *text);
  void set_cells (int len, const char *text);

  // Functions for clearing an area of the screen
  void clrscr ();
  void clreol ();

  // Other modifications to the content
  void scroll_window (int scroll_distance);
  
  // Functions for determining what text has changed
  void get_dirt (int y, int *left, int *right);
  int repaint_needed ();
  const char *get_text (int x, int y) const;
  const unsigned char *get_attr (int x, int y) const;

  // Functions for manipulating a "viewport" within the window
  void set_window (int x1, int y1, int x2, int y2);
  void unset_window ();

  // Function for saving and restore the content of the whole screen
  void *save_screen_content ();
  void restore_screen_content (void *);
};

#endif /* include_textwin_h */
