#ifndef include_stdfont_h
#define include_stdfont_h

#define INCL_PM
#include <os2.h>

class FontInformation
{
  int font_count;
  FONTMETRICS *font_metrics;
  long xres, yres;
  const FONTMETRICS *default_font_set[256];
  unsigned default_font_pointsize[256];
  
  // Function to find a font index that matches a desired font string
  int find_match (const char *fontspec, unsigned *pointsize);
  
public:
  FontInformation (HWND);
  ~FontInformation ();

  // Function to install a font (referenced with a font index) into the
  // set of fonts we want availible by default.  Returns a handle
  // by which the font may be referred to in the future.
  int install_font (const char *fontspec);
  
  // Remove a font from the default list of availible fonts.
  void deinstall_font (int fonthandle);

  // Configure a HPS so that all of the fonts which are availible by
  // default are availible
  void make_fonts_availible (HPS hps);

  // Set the drawing font to a given font
  void use_font (HPS hps, int fonthandle);

  // Access to font metric information
  const FONTMETRICS *get_fontmetrics (int fonthandle);

  // Access size information about the default set of fonts
  int get_font_height (int fonthandle);
  int get_fonts_height ();
  int get_font_width (int fonthandle);
  int get_fonts_width ();
  int get_font_descender (int fonthandle);
  int get_fonts_descender ();

  // Find a text width in the currently selected font of an hps
  static int string_width (HPS hps, int length, const char *text);
};

extern FontInformation *desktop_fontinfo;
void init_desktop_fontinfo ();


#endif /* include_stdfont_h */
