
#include "stdframe.h"

class StdFrameAux
{
public:
  static MRESULT FrameWindowProcedure (HWND, unsigned long, MPARAM, MPARAM);
};

MRESULT StdFrameAux::FrameWindowProcedure (HWND frame, unsigned long msg,
					   MPARAM mp1, MPARAM mp2)
{
  StdFrame *instance = (StdFrame *) WinQueryWindowPtr (frame, QWL_USER);
  return instance->frame_message (msg, mp1, mp2);
}

StdFrame::StdFrame ()
: is_attached (0)
{
}

StdFrame::~StdFrame ()
{
  if (is_attached)
    detach ();
}

MRESULT StdFrame::frame_message (unsigned long amsg, MPARAM amp1, MPARAM amp2)
{
  unsigned long save_msg = msg;
  MPARAM save_mp1 = mp1;
  MPARAM save_mp2 = mp2;
  msg = amsg;
  mp1 = amp1;
  mp2 = amp2;
  MRESULT ret;
  
  switch (msg)
    {
    case WM_WINDOWPOSCHANGED:
      framemsg_windowposchanged ((SWP *) mp1, (unsigned) mp2);
      ret = 0;
      break;
    case WM_QUERYTRACKINFO:
      ret = (MRESULT)
	framemsg_querytrackinfo (SHORT1FROMMP (mp1), (TRACKINFO *) mp2);
      break;
    default:
      ret = default_frame_message ();
    }
  
  msg = save_msg;
  mp1 = save_mp1;
  mp2 = save_mp2;
  return ret;
}

virtual MRESULT StdFrame::default_frame_message ()
{
  return old_wndproc (frame, msg, mp1, mp2);
}

void StdFrame::framemsg_windowposchanged (SWP *, unsigned)
{
  default_frame_message ();
}

int StdFrame::framemsg_querytrackinfo (unsigned short, TRACKINFO *)
{
  return (int) default_frame_message ();
}

void StdFrame::attach (HWND aframe)
{
  if (is_attached)
    detach ();
  frame = aframe;
  is_attached = 1;
  WinSetWindowPtr (frame, QWL_USER, this);
  old_wndproc = WinSubclassWindow (frame, StdFrameAux::FrameWindowProcedure);
}

void StdFrame::detach ()
{
  if (is_attached)
    {
      is_attached = 0;
      WinSubclassWindow (frame, old_wndproc);
    }
}
