#ifndef include_msgs_h
#define include_msgs_h

#include "pmtext.h"

class MessageWindow: public PMTextWindow
{
private:
  typedef PMTextWindow inherited;
  int batch_count;
  virtual MRESULT msg_user1 (MRESULT mp1, MRESULT mp2);
  void send_message (void *msg);
public:
  MessageWindow (const char *fontspec,
		 int init_width = 80, int init_height = 25);
  virtual ~MessageWindow ();

  void batch_on ();
  void batch_off ();
  void set_screen_size (int width, int height);
  void set_width (int width);
  void set_height (int height);
  int get_screen_width ();
  int get_screen_height ();
  void set_attr (unsigned char attr);
  void set_fg (unsigned char fg_color);
  void set_bg (unsigned char bg_color);
  int getx ();
  int gety ();
  void gotoxy (int x, int y);
  void put_raw (int len, const char *text);
  void put_tty (int len, const char *text);
  void put_std (int len, const char *text);
  void set_cells (int len, const char *text);
  void clrscr ();
  void clreol ();
  void scroll_window (int scroll_distance);
  void set_window (int x1, int y1, int x2, int y2);
  void unset_window ();
  void hide_cursor ();
  void set_cursor (int start_line, int stop_line);
  void set_cursor_color (int cursor_color);
  int get_cursor_color ();
  void *save_screen_content ();
  void restore_screen_content (void *);
};


#endif /* include_msgs_h */
