#include <pmio.h>
#include <stdio.h>

static int pmio_stdwrite (void *, char *buf, int len)
{
  put_std (len, buf);
  return len;
}

// Note: Backspace doesn't work correctly.
static int pmio_stdread (void *, char *buf, int len)
{
  if (len == 0)
    return 0;
  buf[0] = getch ();
  while (buf[0] == 0)
    {
      (void) getch ();
      buf[0] = getch ();
    }
  if (buf[0] == '\r')
    buf[0] = '\n';
  put_std (1, &buf[0]);
  return 1;
}

void start_pmstdio ()
{
  FILE *f;
  f = fwopen (0, pmio_stdwrite);
  if (!f)
    return; // This should never happen...
  setvbuf (f, 0, _IONBF, 0);
  fclose (stdout);
  fclose (stderr);
  *stdout = *f;  // Evil! evil! evil!
  *stderr = *f;
  
  f = fropen (0, pmio_stdread);
  if (!f)
    return; // This should never happen...
  setvbuf (f, 0, _IONBF, 0);
  fclose (stdin);
  *stdin = *f;
}
