
#include "framectl.h"

FrameControl::FrameControl ()
: mode (frmctl_mode_normal),
  resize_lockout (0)
{
}

void FrameControl::set_behavior_normal ()
{
  mode = frmctl_mode_normal;
}

void FrameControl::set_exact_size (int awidth, int aheight)
{
  width = awidth;
  height = aheight;
  mode = frmctl_mode_absolute;
}


void FrameControl::framemsg_windowposchanged (SWP *swp, unsigned flags)
{
  switch (mode)
    {
    case frmctl_mode_absolute:
      if (swp->fl & SWP_SIZE)
	{
	  // Calc the current size of the frame rectangle
	  RECTL rectl;
	  rectl.xLeft = swp->x;
	  rectl.yBottom = swp->y;
	  rectl.xRight = rectl.xLeft + swp->cx;
	  rectl.yTop = rectl.yBottom + swp->cy;
	  // Then convert this size into a client rectangle size
	  WinCalcFrameRect (frame, &rectl, TRUE);
	  // If the current client size is wrong, correct the problem
	  if (rectl.xRight - rectl.xLeft != width
	      || rectl.yTop - rectl.yBottom != height)
	    {
	      // Otherwise, alter the client rectangle into a shape that
	      // does have the correct dimensions
	      rectl.xRight = rectl.xLeft + width;
	      rectl.yBottom = rectl.yTop - height;
	      // Then calculate the frame rectangle that corresponds to such
	      // a client rectangle
	      WinCalcFrameRect (frame, &rectl, FALSE);
	      // Then reconfigure the frame into the desired shape
	      WinSetWindowPos (frame, 0,
			       rectl.xLeft, rectl.yBottom,
			       rectl.xRight - rectl.xLeft,
			       rectl.yTop - rectl.yBottom,
			       SWP_SIZE | SWP_MOVE);
	      resize_lockout = 1;
	      return;
	    }
	}
      inherited::framemsg_windowposchanged (swp, flags);
      resize_lockout = 1;
      return;
    case frmctl_mode_normal:
      break;
    }
  inherited::framemsg_windowposchanged (swp, flags);
}

int FrameControl::framemsg_querytrackinfo (unsigned short flags,
					   TRACKINFO *trackinfo)
{
  int ret;
  switch (mode)
    {
    case frmctl_mode_absolute:
      // Let the default routine perform the calculation
      ret = inherited::framemsg_querytrackinfo (flags, trackinfo);
      // If the default routine fails, punt
      if (ret == 0)
	return ret;
      // If resize lockout has not yet been activated, don't do anything
      // extra
      if (!resize_lockout)
	return ret;
      // Get the frame rectangle
      RECTL rectl = trackinfo->rclTrack;
      // Convert the rectangle into a client rectangle
      WinCalcFrameRect (frame, &rectl, TRUE);
      // Calculate the width and height of both rectangles
      int frame_width = trackinfo->rclTrack.xRight - trackinfo->rclTrack.xLeft;
      int frame_height= trackinfo->rclTrack.yTop - trackinfo->rclTrack.yBottom;
      int client_width = rectl.xRight - rectl.xLeft;
      int client_height = rectl.yTop - rectl.yBottom;
      // Calculate how much extra space the frame is using up above and
      // beyond what the client needs
      int extra_width = frame_width - client_width;
      int extra_height = frame_height - client_height;
      // Constrain all resize operations so that they leave the client
      // with the required fixed dimensions
      trackinfo->ptlMinTrackSize.x = trackinfo->ptlMaxTrackSize.x
	= width + extra_width;
      trackinfo->ptlMinTrackSize.y = trackinfo->ptlMaxTrackSize.y
	= height + extra_height;
      return ret;
    case frmctl_mode_normal:
      break;
    }
  return inherited::framemsg_querytrackinfo (flags, trackinfo);
}

void FrameControl::attach (HWND aframe)
{
  inherited::attach (aframe);
  screen_width = WinQuerySysValue (HWND_DESKTOP, SV_CXSCREEN);
  screen_height = WinQuerySysValue (HWND_DESKTOP, SV_CYSCREEN);
}
