#include <stdio.h>

#ifdef NDEBUG
#define LOG(format, args...)
#else
FILE *logfile;
#define LOG(format, args...) \
fprintf (logfile, "%s:%d: " format "\n", __FILE__, __LINE__ , ##args )
#endif


#include <stdwin.h>
#include <stdfont.h>
#include <stdlib.h>

#define countof(A) (sizeof (A) / sizeof ((A)[0]))

const char * const fontnames[] = {
  "10.System Monospaced",
  "12.Courier Bold",
  "8.System VIO",
  "14.Courier",
  "16.System VIO",
  "14.Times New Roman Bold",
  "14.System VIO",
  "12.Helvetica Bold Italic",
  "12.Helv",
  "10.Times New Roman Italic"
};

class BlankWindow: public StdWin
{
  typedef StdWin inherited;
  int *f;
  virtual MRESULT msg_paint ();
  virtual MRESULT msg_create ();
};

MRESULT BlankWindow::msg_create ()
{
  init_desktop_fontinfo ();
  f = (int *) malloc (countof (fontnames) * sizeof (int));
  for (int i = 0; i < countof (fontnames); i++)
    f[i] = desktop_fontinfo->install_font (fontnames[i]);
  return inherited::msg_create ();
}

MRESULT BlankWindow::msg_paint ()
{
  HPS hps = WinBeginPaint (window, 0, 0);
  GpiErase (hps);
  desktop_fontinfo->make_fonts_availible (hps);

  const int number_of_lines = countof (fontnames);
  int i;
  POINTL pt;
  pt.x = 0;
  pt.y = 0;
  for (i = 0; i < number_of_lines; i++)
    {
      const int fi = number_of_lines - i - 1; // Invert the print order
      const char * const text = fontnames[fi];
      const int textlen = strlen (text);
      if (f[fi] == 0)
	continue;
      // Set the current font
      desktop_fontinfo->use_font (hps, f[fi]);
      // Then print out the name of the current font at an appropriate place
      pt.y += desktop_fontinfo->get_font_descender (f[fi]);
      LOG ("Output font %d at (%d,%d) text `%s'", f[fi], pt.x, pt.y, text);
      GpiMove (hps, &pt);
      GpiCharString (hps, textlen, text);
      // Then move onwards
      pt.x = 0;
      pt.y -= desktop_fontinfo->get_font_descender (f[fi]);
      pt.y += desktop_fontinfo->get_font_height (f[fi]);
      LOG ("Now at (%d, %d)", pt.x, pt.y);
    }

  pt.y += desktop_fontinfo->get_fonts_descender ();
  const char * const sample_text =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
  for (i = 0; sample_text[i] != '\0'; i++)
    {
      // Set a different font every letter
      desktop_fontinfo->use_font (hps, f[i % number_of_lines]);
      // Move to the right place
      GpiMove (hps, &pt);
      LOG ("Output font %d at (%d,%d) text `%c'", f[i % number_of_lines],
	   pt.x, pt.y, sample_text[i]);
      // Print out one character
      GpiCharString (hps, 1, &sample_text[i]);
      // Then advance the insertion point
      pt.x += FontInformation::string_width (hps, 1, &sample_text[i]);
    }
  
  WinEndPaint (hps);
  return 0;
}

int main(void)
{
  BlankWindow window;
  window.activate_window ();
  StdWin::StdMessageLoop ();
  return 0;
}
