#ifndef include_pmio_h
#define include_pmio_h

#ifdef __cplusplus
extern "C" {
#endif

#define BLACK 0
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define LIGHTGRAY 7
#define DARKGRAY 8
#define LIGHTBLUE 9
#define LIGHTGREEN 10
#define LIGHTCYAN 11
#define LIGHTRED 12
#define LIGHTMAGENTA 13
#define YELLOW 14
#define WHITE 15

extern int origin_x;
extern int origin_y;
extern const char *pmio_fontspec;

void pmio_batch_on (void);
void pmio_batch_off (void);
void set_screen_size (int width, int height);
void set_width (int width);
void set_height (int height);
int get_screen_width (void);
int get_screen_height (void);
void set_attr (unsigned char attr);
void set_fg (unsigned char fg_color);
void set_bg (unsigned char bg_color);
int getx (void);
int gety (void);
void gotoxy (int x, int y);
void put_raw (int len, const char *text);
void put_tty (int len, const char *text);
void put_std (int len, const char *text);
void set_cells (int len, const char *text);
void clrscr (void);
void clreol (void);
void scroll_window (int scroll_distance);
void set_window (int x1, int y1, int x2, int y2);
void unset_window (void);
void hide_cursor (void);
void set_cursor (int start_line, int stop_line);
void set_cursor_color (int cursor_color);
int get_cursor_color (void);
void *pmio_save_screen_content (void);
void pmio_restore_screen_content (void *);

void start_pmio (void);


/*
 * Data Structure for Event Reading Routines
 */
typedef enum {
  pmio_event_char,
} PMIOEventType;

typedef struct {
  unsigned short flags;
  unsigned char repeat_count;
  unsigned char scancode;
  char ch;
  unsigned short charcode;
  unsigned short virtualkeycode;
} PMIOEventKey;

typedef struct {
  PMIOEventType event_type;
  union {
    PMIOEventKey key;
  } e;
} PMIOEvent;

void pmio_get_event (PMIOEvent *e);
int pmio_event_availible (void);

void pmio_event_convert (const PMIOEvent *e, char *c1, char *c2);
int kbhit (void);
char getch (void);
char getche (void);

#ifdef __cplusplus
};
#endif

#endif /* include_pmio_h */
