#ifndef include_pmtext_h
#define include_pmtext_h

#include <stdwin.h>
#include <framectl.h>
#include <textwin.h>

class PMTextWindow: public StdWin, protected TextWindow
{
private:
  FrameControl framectl;
  int char_width, char_height, char_descender;
  const char * const fontspec;
  int font;
  int visible_cursor;
  int cursor_start_line, cursor_stop_line;
  int cursor_color;
protected:  
  virtual MRESULT msg_paint ();
  virtual MRESULT msg_create ();
  void refresh_window ();
  virtual int scroll_region_draw (int scroll_distance,
				  int x1, int y1, int x2, int y2);

  void hide_cursor ();
  void set_cursor (int start_line, int stop_line);
  void set_cursor_color (int cursor_color);
  int get_cursor_color () const;
  
public:
  PMTextWindow (const char *afontspec,
		int init_width = 80, int init_height = 25);
  virtual ~PMTextWindow ();
};

#endif /* include_pmtext_h */
