#ifndef include_stdwin_h
#define include_stdwin_h

#define INCL_PM
#include <os2.h>

class StdWinUtils;

class StdWin
{
  friend StdWinUtils;
public:
  static HAB hab;
  static HMQ hmq;
  StdWin ();
  virtual ~StdWin ();
  void activate_window ();
  void destroy_window ();
  static void StdMessageLoop ();

  HWND window;
  HWND frame;
protected:
  int window_is_active;
  unsigned resource_id;
  unsigned msg;
  MPARAM mp1, mp2;
  virtual MRESULT message (HWND, unsigned, MPARAM, MPARAM);
  virtual MRESULT default_message ();

  virtual MRESULT msg_create ();
  virtual MRESULT msg_activate (int, HWND);
  virtual MRESULT msg_adjustwindowpos (SWP *);
  virtual MRESULT msg_char (unsigned short flags, unsigned char repeat_count,
			    unsigned char scancode, unsigned short charcode,
			    unsigned short virtualkeycode);
  virtual MRESULT msg_close ();
  virtual MRESULT msg_controlpointer (unsigned short, HPOINTER);
  virtual MRESULT msg_destroy ();
  virtual MRESULT msg_erasebackground (HPS, RECTL *);
  virtual MRESULT msg_focuschange (HWND, unsigned short, unsigned short);
  virtual MRESULT msg_formatframe (SWP *, RECTL *);
  virtual MRESULT msg_mousemove (short x, short y,
				 unsigned short, unsigned short);
  virtual MRESULT msg_paint ();
  virtual MRESULT msg_realizepalette ();
  virtual MRESULT msg_saveapplication ();
  virtual MRESULT msg_setfocus (HWND, unsigned short);
  virtual MRESULT msg_setselection (unsigned short);
  virtual MRESULT msg_show (unsigned short);
  virtual MRESULT msg_size (short old_width, short old_height,
			    short new_width, short new_heigth);
  virtual MRESULT msg_windowposchanged (SWP *, unsigned);
  // Messages with user-defined meanings
  virtual MRESULT msg_user1 (MPARAM mp1, MPARAM mp2);
  virtual MRESULT msg_user2 (MPARAM mp2, MPARAM mp2);
  virtual MRESULT msg_user3 (MPARAM mp2, MPARAM mp2);
  virtual MRESULT msg_user4 (MPARAM mp2, MPARAM mp2);
  // Arguments of the following are not yet decoded
  virtual MRESULT msg_querydlgcode ();
  virtual MRESULT msg_queryfocuschain ();

  // Sending user defined messages
  MRESULT send_msg (unsigned msg, MPARAM mp1, MPARAM mp2);
  MRESULT send_close ();
  MRESULT send_user1 (MPARAM mp1, MPARAM mp2);
  MRESULT send_user2 (MPARAM mp1, MPARAM mp2);
  MRESULT send_user3 (MPARAM mp1, MPARAM mp2);
  MRESULT send_user4 (MPARAM mp1, MPARAM mp2);
  

  // Configuring the look of the frame before the window is created.
  unsigned long style_flags;
  void enable_acceltable ();
  void enable_icon ();
  void enable_maxbutton ();
  void enable_menu ();
  void enable_minbutton ();
  void enable_minmax ();
  void enable_shellposition ();
  void enable_sizeborder ();
  void enable_sysmenu ();
  void enable_tasklist ();
  void enable_titlebar ();
  void disable_acceltable ();
  void disable_icon ();
  void disable_maxbutton ();
  void disable_menu ();
  void disable_minbutton ();
  void disable_minmax ();
  void disable_shellposition ();
  void disable_sizeborder ();
  void disable_sysmenu ();
  void disable_tasklist ();
  void disable_titlebar ();

  // Configuring resource id to be used
  void set_resource_id (unsigned id) { resource_id = id; }
};

#endif /* include_stdwin_h */
