/* -----------------------------   Rexx   -------------------------------- */
/*                                                                         */
/* ZIPBRAND.CMD -- BRAND THE ZIP FILES WITH BBS SPECIFIC COMMENT v1.0      */
/*                                                                         */
/* This REXX exec will brand all zip files in a path with a user supplied  */
/* comment.  It also changes the date on the file to the 'true' date, this */
/* is newest date of any file contained in the archive.                    */
/*                                                                         */
/*  Syntax: zipbrand /P{filespec} /C{filespec} /L{filespec} /V /Q          */
/*                                                                         */
/*      OPTION   DESCRIPTION                 DEFAULT                       */
/*        /P     Starting path filespec      ./                            */
/*        /C     Comment file filespec       ./zipbrand.cmt                */
/*        /L     Log file filespec           stdout                        */
/*        /V     Verbose logging             Errors only                   */
/*        /Q     Quiet                       Write stdout, stderr          */
/*                                                                         */
/*               Tested with: Zip 2.0.1 (Sept 19th 1993)                   */
/*                No other archive program was tested!                     */
/*                                                                         */
/*  KNOWN PROBLEMS AND BUGS:                                               */
/*  1) None, perfection is so seldom seen (-:                              */
/*                                                                         */
/*  HISTORY                                                                */
/*  94/11/17 - Released version 1.0 into public domain.                    */
/*                                                                         */
/* ----- DISCLAIMER ---- DISCLAIMER ---- DISCLAIMER ---- DISCLAIMER ------ */
/* Engage! BBS and Jona Computer Associates offers this code to the public */
/* domain with no written or expressed warranties.  You may use this code  */
/* for any reason.  You are authorized to alter this code, but we ask that */
/* if you distribute the altered code, that this original code be packaged */
/* with the altered code.                                                  */
/* ----- DISCLAIMER ---- DISCLAIMER ---- DISCLAIMER ---- DISCLAIMER ------ */
/*                                                                         */
/*      (C) Copyright Engage! BBS and Jona Computer Associates 1994.       */
/*                           All rights reserved.                          */
/*                                                                         */
/*            Author: Joel R. Derider   Date Written: 11/01/94             */
/* ----------------------------------------------------------------------- */

spawnbbs: arg arg.1 arg.2 arg.3 arg.4 arg.5 .;arg arg.0; arg.0 = words(arg.0)

   call init_program
   call modify_zip_files
   call end_program
   exit 0

/* ----------------------------------------------------------------------- */
/* initialize the program                                                  */
/* ----------------------------------------------------------------------- */
init_program: ;
   ask         =  0
   rdebug      =  0
   verbose     =  0
   zipparms    = '-o -z'
   quiet       =  0
   timestamp   =  date('S')'.'substr(time('L'),1,length(time('L'))-4)

   call Verify_input_parameters
   call Set_necessary_defaults
   call Set_log_redirection

   return
/* ----------------------------------------------------------------------- */
/* verify the input parameters.  Will exit from here if input is bad       */
/* ----------------------------------------------------------------------- */
verify_input_parameters: ;
   do ctr = 1 to arg.0 by 1
      select
         when substr(arg.ctr,1,2) = '/P' then do
              spath   = substr(arg.ctr,3)
              '@cd 'spath
              if rc > 0 then show_syntax(P)
                                              end
         when substr(arg.ctr,1,2) = '/C' then do
              cpath   = substr(arg.ctr,3)
              if stream(cpath,'C','query exists') = "" then show_syntax(C)
                                              end
         when substr(arg.ctr,1,2) = '/L' then do
              lpath   = substr(arg.ctr,3)
              if stream(lpath,'C','query exists') = "" then do
                 rc = lineout(lpath,timestamp' ===== CREATED LOG FILE==============================')
                 if rc <> 0 then show_syntax(L)
                                                            end
                                              end
         when substr(arg.ctr,1,2) = '/V' then verbose = 1
         when substr(arg.ctr,1,2) = '/Q' then quiet   = 1
         otherwise show_syntax(arg.ctr,1,length(arg.ctr))
      end
   end

   return
/* ----------------------------------------------------------------------- */
/* Set the necessary defaults (if the command line doesn't override)       */
/* ----------------------------------------------------------------------- */
set_necessary_defaults: ;
   if spath = 'SPATH' then spath = './'
   if cpath = 'CPATH' then cpath = './zipbrand.cmt'
   if stream(cpath,'C','query exists') = "" then show_syntax(C)

   return
/* ----------------------------------------------------------------------- */
/* set the log redirection variable based on command line input            */
/* ----------------------------------------------------------------------- */
set_log_redirection: ;
   if lpath = 'LPATH' then do
      lpath2 = ''
      select
         when  verbose &  quiet then lpath = ' > nul'
         when  verbose & quiet then lpath = ''
         when verbose &  quiet then lpath = ' > nul'
         when verbose & quiet then lpath = ' 1> nul'
         otherwise say 'how did I get here?'
      end
                           end
   else do
      lpath2 = lpath
      select
         when  verbose &  quiet then lpath = ' > nul '
         when  verbose & quiet then lpath = ' >> 'lpath
         when verbose &  quiet then lpath = ' > nul '
         when verbose & quiet then lpath = ' 1> nul 2>> 'lpath
         otherwise say 'how did I get here?'
      end
        end
   return
/* ----------------------------------------------------------------------- */
/* show the syntax of this utility then exit                               */
/* ----------------------------------------------------------------------- */
show_syntax: ; arg badopt
   say ''; say ''
   if badopt = '/?' | badopt = '?' | badopt = 'help' | badopt = '/help' | ,
      badopt = 'h'  | badopt = '/h' then
      nop
   else  say 'Syntax error has occured!  Please correct syntax and try again'
      say ''
   select
      when badopt = 'C' then say 'Error - Comment  filespec not found'
      when badopt = 'P' then say 'Error - Starting filespec not found'
      when badopt = 'L' then say 'Error - Logging  filespec not found'
      otherwise nop
   end
   say 'Syntax: zipbrand /P{filespec} /C{filespec} /L{filespec} /V /Q      '
   say '                                                                   '
   say '  OPTION   DESCRIPTION                 DEFAULT                     '
   say '    /P     Starting path filespec      ./                          '
   say '    /C     Comment file filespec       ./zipbrand.cmt              '
   say '    /L     Log file filespec           stdout                      '
   say '    /V     Verbose logging             Errors only                 '
   say '    /Q     Quiet                       Write stdout, stderr        '
   say '    /?     Display this help           N/A                         '
   say '                                                                   '
   say '  EXAMPLE: To brand all files in the directory tree d:\max\file\dos'
   say '           Using comments in file d:\zipbrand.cmt                  '
   say '           Logging errors to file d:\logs\zipbrand.log             '
   say '                                                                   '
   say '  zipbrand /Pd:\max\file\dos /Cd:\zipbrand\zipbrand.cmt /Ld:\logs\zipbrand.log'
   SAY '                                                                   '
   exit 8
/* ----------------------------------------------------------------------- */
/* modify all zip files in the directory tree                              */
/* ----------------------------------------------------------------------- */
modify_zip_files: ;

   rc = sysfiletree(spath'\*.zip',zipfiles,'fs')

   rc = lineout(lpath2,'')
   rc = lineout(lpath2,timestamp' ===== BEGIN =======================================')
   rc = lineout(lpath2,'                     Options in effect')
   rc = lineout(lpath2,'                        Start  ='spath)
   rc = lineout(lpath2,'                        Comment='cpath)
   rc = lineout(lpath2,'                        Log    ='lpath)
   rc = lineout(lpath2,'                        Verbose='verbose)
   rc = lineout(lpath2,'                        Quiet  ='quiet)
   rc = lineout(lpath2,'                     Processing 'zipfiles.0' .zip files')
   if lpath2 <> '' then rc = stream(lpath2,'c','close')

   do ctr = 1 to zipfiles.0 by 1
      zipfile = strip(substr(zipfiles.ctr,38),'b')
      archbit = substr(zipfiles.ctr,31,1)
      '@type 'cpath' | zip 'zipparms zipfile lpath
      if archbit = '-' then '@attrib -A 'zipfile' > nul'
   end

   return
/* ----------------------------------------------------------------------- */
/* end the program                                                         */
/* ----------------------------------------------------------------------- */
end_program: ;
   endtimestamp = date('S')'.'substr(time('L'),1,length(time('L'))-4)

   rc = lineout(lpath2,timestamp' ===== END ============================ 'endtimestamp)

   return
