/***************************************************************************
                                                                               
G-Stat v1.03 Graphical File Stat Program               
(C) 1993 Steven Wishart                                                         
                                                                               
    This program is free software; you can redistribute it and/or modify       
    it under the terms of the GNU General Public License as published by       
    the Free Software Foundation; either version 1, or (at your option)        
    any later version.                                                         
                                                                               
    This program is distributed in the hope that it will be useful,            
    but WITHOUT ANY WARRANTY; without even the implied warranty of             
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              
    GNU General Public License for more details.                               
                                                                               
    You should have received a copy of the GNU General Public License          
    along with this program; if not, write to the Free Software                
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                  
                                                                               
***************************************************************************/

#include "gstat.h"

int i,x,z;

main(int argc, char **argv, char **envp)
{
struct stat gstat;
	struct passwd *getpwuid();  
	struct group *getgrgid();   

		int perms,pmode,uid,gid,ret,read,write,exe;  
		char *Path;
		char A;

if(argc < 2)
	{
	printf(CLEAR);
	printf("%s %s\n",VERSION,HEADING);
	printf("%s %s\n",COPYRIGHT,RIGHTS);
	printf("Email: steven@snarf.UUCP (South Africa)\n");
   printf("Last Compiled -> %s %s\n\n",COMPTIME,COMPDATE);
	printf("Usage: %s <filename>\n", argv[0]);
	}

else

{
	if(stat(argv[1],&gstat) != 0)
		{
		perror("Error in \"stat\"");
		exit(1);
		}

if ( ( Path = getenv("PWD")) == NULL)                                     
		{                                                                            
		perror("Could not get PWD environment variable");                           
		}                   

		read =  FALSE;				/* Initialise read, write exec */          
		write = FALSE;				/* flags to not set */                     
		exe   = FALSE;                                               
		uid=geteuid(); 			/* Get effective UID of caller */          
		gid=getegid();				/* Get effective GID of caller */          
		if (!getpwuid(uid))                                          
			{                                                           
			perror("getpwuid() ");                                      
			endpwent();                                                 
			exit(1);                                                    
			}                                                           
		if (!getgrgid(gid))                                          
			{                                                           
			perror("getgrgid() ");                                      
			endgrent();                                                 
			exit(1);                                                    
			}                                                           

		perms=gstat.st_mode;                                                
		if ((perms | 256) == perms )  /* Owner Read */                     
			flags[1] ='r';                                                    
		if ((perms | 128) == perms )  /* Owner Write */                    
			flags[2] ='w';                                                    
		if ((perms | 64) == perms )	/* Owner Execute */                    
			flags[3] ='x';                                                    
		if ((perms | 32) == perms )	/* Group Read */                       
			flags[4] ='r';                                                    
		if ((perms | 16) == perms)    /* Group Write */                    
			flags[5] ='w';                                                    
		if ((perms | 8) == perms)	/* Group Execute */                      
			flags[6] ='x';                                                    
		if ((perms | 4) == perms)	/* Other Read */                         
			flags[7] ='r';                                                    
		if ((perms | 2) == perms)	/* Other Write */                        
			flags[8] ='w';                                                    
		if ((perms | 1) == perms)	/* Other Execute */                      
			flags[9] ='x';                                                    
		if ((perms | 512) == perms )  /* Save Text Image after exec */     
			flags[9] ='T';		                                                  
		if ((perms | 513) == perms )  /* Sticky Bit Set */                 
			flags[9] ='t';			/* Must be after other execute check */          
		if ((perms | 1024) == perms ) /* Lock bit Set */                   
			flags[6] ='S';	                                                   
		if ((perms | 1032) == perms)  /* Set GID  */                       
			flags[6] ='s';			/* Must be after group execute check */          
		if ((perms | 2048) == perms ) /* Set UID no execute */             
			flags[3] ='S';			/* Must Be after user execute check */           
		if ((perms | 2112) == perms ) /* Set UID */                        
			flags[3] ='s';			/* Must Be after user execute check */           
		if ((perms | 4096) == perms ) /* Named Pipe */                     
			flags[0] ='p';                                                    
		if ((perms | 8192) == perms ) /* Character Special */              
			flags[0] ='c';                                                    
		if ((perms | 16384) == perms) /* Directory */                      
			flags[0] ='d';                                                    
		if ((perms | 20480) == perms) /* Named Special File */             
			flags[0] ='s';                                                    
		if ((perms | 24576) == perms) /* Block Special */                  
			flags[0] ='b';                                                    

	if( gstat.st_mode >= 32768)
	pmode = (gstat.st_mode - 32768);
	else
	pmode = gstat.st_mode;

		if (uid != 0)                 
			{                            
			if (flags[7] == 'r')         
				read = TRUE;                
			if (flags[8] == 'w')         
				write = TRUE;               
			if (flags[9] == 'x')         
				exe = TRUE;                 
			if (gid == gstat.st_gid)      
				{                           
				if (flags[4] == 'r')        
					read = TRUE;               
		    	if (flags[5] == 'w')     
					write = TRUE;              
				if (flags[6] == 'x')        
					exe = TRUE;		              
				}                           
			}

	BackScreen();

	printf(BLUE"\x1B[2;1H\x1B[2;3H %s                %s",VERSION,HEADING);

	printf("\x1B[4H");
	printf(BLUE"  File  %s\n",argv[1]);
   printf(BLUE"  Inode Number  %d\n", gstat.st_ino);
	printf(BLUE"  Number of Link(s) - %d\n", gstat.st_nlink);
   printf(BLUE"  Size - %ld bytes\n",gstat.st_size);
	printf(BLUE"  File ID (for c/b devices)  %ld \n",gstat.st_rdev);
	printf(BLUE"  Group Id - %d  \x1B[9;36H-> %s\n",gstat.st_gid,getgrgid(gstat.st_gid)->gr_name);
   printf(BLUE"  User Id - %d  \x1B[10;36H-> %s\n",gstat.st_uid,getpwuid(gstat.st_uid)->pw_name);
   printf(BLUE"  Permissions - %s\n",flags);
   printf(BLUE"  Bit Mask Mode - %o\n",pmode);							  
   printf(BLUE"  Last Accessed - %s",ctime(&gstat.st_atime));
	printf(BLUE"  Last Modified - %s",ctime(&gstat.st_mtime));
	printf(BLUE"  Last Status Change - %s\n\n",ctime(&gstat.st_ctime));  
	
	printf(RESET);
	}
		return(0);
}

void BackScreen()
{

	printf(CLEAR);

	printf("\x1B[1;1H");
	printf(BLUE"");
		for(i=0;i<77;i++)
			printf("");
				printf("");
								printf("\x1B[2;0H");
							for(z=0;z<14;z++)
							{
								for(x=0;x<6;x++)
									printf(BLUE"             ");
											printf("\n");
							}
													printf("\x1B[3;1H"); 
														for(i=0;i<78;i++)
															printf("");
														printf("\x1B[3;79H");

		
	printf("\x1B[16;1H");  
	printf(BLUE"");      
		for(i=0;i<77;i++)    
			printf("");        
				printf("");       


	printf("\x1B[5;55H");  
	printf(RRED"");      
		for(i=0;i<12;i++)    
			printf("");        
				printf("");       
			
					printf("\x1B[6;55H");
						printf(RRED" \x1B[6;57H%s%s ",RRED,flags);

					printf("\x1B[7;55H");  	
					printf(RRED"");       
						for(i=0;i<12;i++)     
							printf("");         
								printf("");        

}
