; LPTMON.ASM by Celso Minnitti, Jr
;
; Date: 01-16-1994
;
; Compile:  TASM /m2 LPTMON
;	    TLINK /t LPTMON

ATTR            EQU     70h
REFRESH         EQU     9                        ;55ms*9 = 0.495 seconds

_TEXT   segment byte public 'CODE'
	assume cs:_TEXT, ds:_TEXT
		org	100h

start:          jmp     install
pause           db      0

old08           dd      0
old0f		dd	0
old2f		dd	0

column          dw      70 * 2
lptIO		dw	378h
vidseg		dw	0b800h

count_08        db      0
count_0f	db	0			 ;counter of int fh (irq 7)


int_08: 	pushf
		call	cs:old08
		pushf
		cmp	byte ptr cs:[pause],1
		je	int08_ret
		inc	byte ptr cs:[count_08]
		cmp	byte ptr cs:[count_08],REFRESH
		jb	int08_ret

		push	ax
		push	cx
                push    dx
		push	di
		push	si
		push	ds
		push	es

		push	cs
		pop	ds
		mov	byte ptr [count_08],0

		call	print_lptmon

		pop	es
		pop	ds
		pop	si
		pop	di
		pop	dx
		pop	cx
		pop	ax
int08_ret:	popf
		iret

int_0f: 	inc	byte ptr cs:[count_0f]
		jmp	cs:old0f

int_2f: 	cmp	ah,90h
		je	int2f_00
		jmp	cs:old2f

int2f_00:	cmp	al,0			 ;is function 0?
		jne	int2f_01
		mov	ax,0ffffh		 ;return 0ffffh to show that
		iret				 ;lptmon is resident

int2f_01:	cmp	al,1			 ;is function 1?
		jne	int2f_02
		xor	byte ptr cs:[pause],1	 ;turn on/off lptmon
		iret


int2f_02:	push	ds			 ;function 2, uninstall
		mov	ax,2508h		 ;restore int 8
		lds	dx,cs:[old08]
		int	21h

		mov	al,0fh			 ;restore int 0fh
		lds	dx,cs:[old0f]
		int	21h

		mov	al,2fh			 ;restore int 2fh
		lds	dx,cs:[old2f]
		int	21h

		mov	es,word ptr cs:[2ch]	 ;release enviroment
		mov	ah,49h
		int	21h

		push	cs
		pop	es			 ;release psp
		mov	ah,49h
		int	21h
		pop	ds
		iret

;--------------------------------------------------------------------------
print_lptmon:	cld
		push	cs
		pop	es
		call	read_port

                mov     es,[vidseg]
                mov     di,word ptr [column]
		mov	ax,6			 ;print 6 lines
		mov	si,offset LPTMON

print_lptmon1:	mov	cx,10			 ;each line has 10 chars
		rep	movsw
		add	di,140			 ;go to next line
		dec	ax
		jnz	print_lptmon1
		ret

;--------------------------------------------------------------------------
read_port:	mov	dx,[lptIO]		 ;get port address
		xor	si,si
		mov	cx,3

read_port1:	in	al,dx
		mov	di,word ptr [si+XY]
		call	print8h
		inc	si
		inc	si
		inc	dx
		loop	read_port1

		mov	al,[count_0f]
		mov	di,word ptr [si+XY]
		call	print8h
		ret

;**************************************************************************
;				PRINT8H
;
;enter: 	AL = # to print in hexadecimal at ES:DI
;**************************************************************************
print8h 	proc	near
		push	ax
		push	cx
		push	dx
		push	di

pri81:		mov	cx,2
		mov	dl,al
		mov	ah,ATTR
pri82:		rol	dl,4
		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		stosw
		loop	pri82

		pop	di
		pop	dx
		pop	cx
		pop	ax
		ret
print8h 	endp

XY		dw	offset LPTMON+1*20+6*2
		dw	offset LPTMON+2*20+6*2
		dw	offset LPTMON+3*20+6*2
		dw	offset LPTMON+4*20+6*2

; This data was created using Thedraw
LPTMON LABEL BYTE
        DB      '',122,'',122,'L',126,'P',126,'T',126,'M',126,'O',126
        DB      'N',126,'',122,'',122,'',122,'3',123,'7',123,'8',123
        DB      '=',123,' ',123,' ',122,' ',122,' ',122,'',122,'',122
        DB      '3',123,'7',123,'9',123,'=',123,' ',123,' ',122,' ',122
        DB      ' ',122,'',122,'',122,'3',123,'7',123,'A',123,'=',123
        DB      ' ',123,' ',122,' ',122,' ',122,'',122,'',122,'I',123
        DB      'R',123,'Q',123,'7',123,'=',123,' ',123,' ',122,' ',122
        DB      '',122,'',122,'',122,'',122,'',122,'',122,'',122
        DB      '',122,'',122,'',122,'',122

;--------------------------------------------------------------------------
install:	mov	al,byte ptr ds:[80h]	 ;get # of chars in cmd line
		cmp	al,2			 ;space + 1st argument
		jne	install0

		mov	al,byte ptr ds:[82h]	 ;get 1st argument
                cmp     al,'u'
		je	uninstall
		cmp	al,'U'
		je	uninstall
		cmp	al,'-'                   ;turn pause on/off
		jne	install0
		mov	ax,9001h
		int	2fh
		jmp	exit

install0:	mov	ax,9000h		 ;is lptmon already installed?
		int	2fh
		cmp	ax,0ffffh
		jne	install1
		mov	dx,offset msg00 	 ;already installed
		jmp	print

install1:	mov	ah,9			 ;ok to install
		mov	dx,offset copyright
		int	21h

		call	init			 ;setup vidseg variable

		mov	ax,3508h		 ;save int 08
		int	21h
		mov	word ptr [old08],bx
		mov	word ptr [old08+2],es
		mov	dx,offset int_08
		mov	ah,25h			 ;set int 08
		int	21h

		mov	ax,350fh		 ;save int 0f
		int	21h
		mov	word ptr [old0f],bx
		mov	word ptr [old0f+2],es
		mov	dx,offset int_0f
		mov	ah,25h			 ;set int 0fh
		int	21h

		mov	ax,352fh		 ;save int 2fh
		int	21h
		mov	word ptr [old2f],bx
		mov	word ptr [old2f+2],es
		mov	dx,offset int_2f
		mov	ah,25h			 ;set int 2fh
		int	21h

		mov	dx,offset install	 ;tsr
		int	27h

print:		mov	ah,9
		int	21h
exit:		int	20h			 ;return to DOS

uninstall:	mov	ax,9002h
		int	2fh
		mov	dx,offset msg01
		jmp	print

;**************************************************************************
;				   INIT
; Initialize:
; vidseg = B800 (color) or B000 (mono)
;**************************************************************************
init		proc	near
		push	ds
		xor	ax,ax
		mov	ds,ax
                mov     al,byte ptr ds:[410h]
		pop	ds

		and	al,30h
		cmp	al,30h
		mov	ax,0B800h
		jnz	init1
		mov	ax,0B000h
init1:		mov	word ptr [vidseg],ax
		ret
init		endp


copyright	db	'LPTMON 1.0  Public Domain by Celso Minnitti Jr  '
		db	'01-16-94',10,13,24h
msg00		db	'Usage:   LPTMON [option]',10,13
		db	'         U   Uninstall LPTMON',10,13
		db	'         -   Turn on/off the display of LPTMON',10,13,24h
msg01		db	'LPTMON successfully uninstalled',10,13,24h

_TEXT	ends
end	start
