/*
 
                                                                           
  install.c                                                                
                                                                           
  Creates a job server and job queue to process DOS commands submitted by  
  submit.exe                                                               
 
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <dos.h>
#include <dir.h>
#include <nwcalls.h>
#include "..\doit.h"

#define NWDOS

NWCCODE		cCode;
struct ffblk	ffblk;
int		found;
DWORD		queueID,
		serverID;
NWFILE_HANDLE	fileHandle;
NWCONN_HANDLE	connID;
NWCONN_NUM	connNumber;
char NWFAR	userName[48];
char		response;
NWFLAGS NWFAR	installed;
NWSEGMENT_DATA	segment;

void main()
{
	found = findfirst(JOBSERV_PATH, &ffblk, FA_DIREC);
	if (found != 0) {
		printf("You must create the queue directory\n");
		printf("%s before installing the job server.\n", JOBSERV_PATH);
		exit(-1);
	}

	cCode = NWCallsInit(NULL, NULL);
	if (cCode != 0) {
		printf("Unable to initialize NetWare interface\n");
		exit(-1);
	}

	/* get the connection ID of the server you're installing on */
	cCode = NWGetDefaultConnectionID(&connID);
	if (cCode != 0) {
		printf("Unable to get connection ID of default server\n");
		exit(-1);
	}

	/* create job server object */
	cCode = NWCreateObject(connID, JOBSERV_NAME, OT_DOIT, BF_STATIC, BS_LOGGED_READ | BS_OBJECT_WRITE);
	if (cCode == 0)
		printf("Created job server bindery object\n");
	else {
		switch (cCode) {
			case 0x89EE :	printf("Job server bindery object already created on default server\n");
					response = ' ';
					do {
						printf("Continue anyway?  (y/n)");
						response = toupper(getche());
						printf("\n");
					} while ((response !=  'Y') && (response  !=  'N'));
					if (response == 'N')
						exit(-1);
					break;
			case 0x89F5 :	printf("You must be supervisor or supervisor-equivalent to install job server\n");
					exit(-1);
					break;
			default :	printf("Call to NWCreateObject failed\n");
					exit(-1);
					break;
		}
	}

	/* create a password for the job server */
	cCode = NWChangeObjectPassword(connID, JOBSERV_NAME, OT_DOIT, "", JOBSERV_PWORD);
	if (cCode == 0)
		printf("Set job server password\n");
	else {
		printf("Call to NWChangeObjectPassword failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* see if accounting is installed; if so, create account balance property */
	cCode = NWQueryAccountingInstalled(connID, &installed);
	if (installed == 1) {
		cCode = NWCreateProperty(connID, JOBSERV_NAME, OT_DOIT, "ACCOUNT_BALANCE", BF_ITEM | BF_STATIC, BS_OBJECT_READ | BS_SUPER_WRITE);
		if (cCode != SUCCESSFUL) {
			printf("Unable to create Account Balance property for job server object\n");
			exit(-1);
		}

		/* set account balance to allow unlimited credit */
		segment = (NWSEGMENT_DATA)calloc(128, sizeof(BYTE));
		segment[4] = 0x80;
		cCode = NWWritePropertyValue(connID, JOBSERV_NAME, OT_DOIT, "ACCOUNT_BALANCE", 1, segment, 0);
		if (cCode != SUCCESSFUL) {
			printf("Unable to set account balance for job server object\n");
			exit(-1);
		}
	}

	/* create a job queue */
	cCode = NWCreateQueue(connID, JOBSERV_NAME, OT_DOIT_Q, 0, JOBSERV_PATH, &queueID);
	if (cCode == 0)
		printf("Created job queue\n");
	else {
		printf("Call to NWCreateQueue failed, cCode = %X\n", cCode);
		if ((cCode == 0x8998) || (cCode == 0x899C))
			printf("Invalid queue directory path\n");
			exit(-1);
	}

	/* get your connection number */
	cCode = NWGetConnectionNumber(connID, &connNumber);
	if (cCode != 0) {
		printf("Unable to get your connection number to default server\n");
		exit(-1);
	}

	/* get your user name */
	cCode = NWGetConnectionInformation(connID, connNumber, userName, NULL, NULL, NULL);
	if (cCode != 0) {
		printf("Unable to get your user name\n");
		exit(-1);
	}

	/* add your user to the set of queue users */
	cCode = NWAddObjectToSet(connID, JOBSERV_NAME, OT_DOIT_Q, "Q_USERS", userName, OT_USER);
	if (cCode == 0)
		printf("Added your object to queue users set\n");
	else {
		printf("Call to NWAddObjectToSet failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* add your user to the set of queue operators */
	cCode = NWAddObjectToSet(connID, JOBSERV_NAME, OT_DOIT_Q, "Q_OPERATORS", userName, OT_USER);
	if (cCode == 0)
		printf("Added your object to queue operators set\n");
	else {
		printf("Call to NWAddObjectToSet failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* add your new server to the set of queue servers */
	cCode = NWAddObjectToSet(connID, JOBSERV_NAME, OT_DOIT_Q, "Q_SERVERS", JOBSERV_NAME, OT_DOIT);
	if (cCode == 0)
		printf("Added job server to queue servers set\n");
	else {
		printf("Call to NWAddObjectToSet failed, cCode = %X\n", cCode);
		exit(-1);
	}

	printf("Job server installed\n");
}
