/*
 
                                                                           
  jobserv.c                                                                
                                                                           
  service a DOS command line job that has been put in the job queue by     
  doit.exe                                                                 
                                                                           
 
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <mem.h>
#include <conio.h>
#include <string.h>
#include <nwcalls.h>
#include <nwerror.h>
#include "..\doit.h"

#define NWDOS

#define ESC 0x1B

#ifndef SUCCESSFUL
#define SUCCESSFUL 0x0000
#endif

int			done=0,
			gotone;
NWCCODE         	cCode;
NWOBJ_ID		oID;
DWORD           	queueID;
NWFILE_HANDLE   	fileHandle;
NWCONN_HANDLE		connID;
char            	command[181],
			line[80],
			ch;
WORD            	jobType;
NWQueueJobStruct	jobStructure;

void process_job(void);

void main()
{
	cCode = NWCallsInit(NULL, NULL);
	if (cCode == SUCCESSFUL)
		printf("Call to NWCallsInit successful\n");
	else {
		printf("Call to NWCallsInit failed\n");
		exit(-1);
	}

	/* get the connection ID of the default server */
	cCode = NWGetDefaultConnectionID(&connID);
	if (cCode == SUCCESSFUL)
		printf("Call to NWGetDefaultConnectionID successful\n");
	else {
		printf("Call to NWGetDefaultConnectionID failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* check to see if the default server has had the job server
	   object installed on it
	   If so, assume that queue directory exists, queue object was created, etc. */
	cCode = NWScanObject(connID, JOBSERV_NAME, OT_DOIT, &oID, NULL, NULL, NULL, NULL, NULL);
	if (cCode != SUCCESSFUL) {
		printf("Job server has not been installed on this file server.\n");
		exit(-1);
	}

	/* log out as who you were */
	cCode = NWLogoutFromFileServer(connID);
	if (cCode != SUCCESSFUL) {
		printf("Call to NWLogoutFromFileServer failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* log in as the job server object */
	cCode = NWLoginToFileServer(connID, JOBSERV_NAME, OT_DOIT, JOBSERV_PWORD);
	if (cCode != SUCCESSFUL) {
		printf("Call to NWLoginToFileServer failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* get the bindery object ID of the queue we will be servicing */
	cCode = NWGetObjectID(connID, JOBSERV_NAME, OT_DOIT_Q, &queueID);
	if (cCode != SUCCESSFUL) {
		printf("Call to NWGetObjectID failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* attach to the queue we are going to service */
	cCode = NWAttachQueueServerToQueue(connID, queueID);
	if (cCode != SUCCESSFUL) {
		printf("Call to NWAttachQueueServerToQueue failed, cCode = %X\n", cCode);
		exit(-1);
	}

	/* display prompt */
	memset(line, '-', 79);
	clrscr();
	printf("Job server example program\n");
	printf("Press ESC to exit\n");
	gotoxy(1,5);
	printf("%s\n", line);
	printf("> \n");
	printf("%s\n", line);

	/* continue requesting jobs from the queue until user presses ESC */
	while (!(done)) {
		do {
			/* first, look for priority 1 */
			jobType = DOIT_JOB_PRIORITY_1;

			/* see if there are any jobs to be serviced */
			cCode = NWServiceQueueJob2(connID, queueID, jobType, &jobStructure, &fileHandle);
			if (cCode != SUCCESSFUL) {
				jobType = DOIT_JOB_PRIORITY_2;
				cCode = NWServiceQueueJob2(connID, queueID, jobType, &jobStructure, &fileHandle);
				if (cCode != SUCCESSFUL) {
					gotoxy(1,4);
					printf("No jobs in queue");
				}
			}

			/* if there is a job then process it, otherwise keep asking */
			if (!(cCode)) {
				/* assume the rights of the client who submitted the job */
				cCode = NWChangeToClientRights2(connID, queueID, jobStructure.jobNumber);
				if (cCode != SUCCESSFUL) {
					printf("Call to NWChangeToClientRights2 failed, cCode = %X\n", cCode);
					exit(-1);
				}

				/* process the job */
				process_job();

				/* redisplay prompt */
				gotoxy(1,1);
				printf("Job server example program\n");
				printf("Press ESC to exit\n");
				gotoxy(1,5);
				printf("%s\n", line);
				printf("> \n");
				printf("%s\n", line);

				/* clear the command string */
				memset(command,0,181);

				/* set flag saying there is a job to service */
				gotone = 1;
			}

			/* check to see if ESC has been hit */
			if (kbhit()) {
				ch = getch();
				if (ch == ESC) done = 1;
			}

		/* loop until done or until we have a job */
		} while ((!(gotone)) && (!(done)));

		if (gotone) {
			/* tell QMS we've successfully serviced the queue job */
			cCode = NWFinishServicingQueueJob2(connID, queueID, jobStructure.jobNumber, fileHandle);
			if (cCode != SUCCESSFUL) {
				gotoxy(1,3);
				printf("Call to NWFinishServicingQueueJob2 failed, cCode = %X", cCode);
				exit(-1);
			}
		}

		/* continue looking for commands */
		gotone = 0;
	}

	/* if the user hit ESC, then detach from the queue and logout */
	/* the workstation will remain connected and default to the LOGIN directory */

	/* detach from the queue */
	gotoxy(1,24);
	cCode = NWDetachQueueServerFromQueue(connID, queueID);
	if (cCode == SUCCESSFUL)
		printf("Call to NWDetachQueueServerFromQueue successful\n");
	else {
		printf("Call to NWDetachQueueServerFromQueue failed, cCode = %X\n", cCode);
	}

	/* logout from the file server */
	cCode = NWLogoutFromFileServer(connID);
	if (cCode == SUCCESSFUL)
		printf("Call to NWLogoutFromFileServer successful\n");
	else
		printf("Call to NWLogoutFromFileServer failed, cCode = %X\n", cCode);
}

void process_job(void)
{
	/* process the job by reading the file and sending the command to */
	/* system() */
	clrscr();
	read(fileHandle, command, 181);
	gotoxy(3,6);
	printf("%s\n",command);
	gotoxy(1,8);
	system(command);
}
